/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.features;

import com.skyblock21.config.Skyblock21ConfigManager;
import com.skyblock21.events.EntityEvents;
import com.skyblock21.util.ColorUtil;
import com.skyblock21.util.Render3DUtil;
import com.skyblock21.util.TextUtils;
import com.skyblock21.util.TickSchedulerHelper;
import com.skyblock21.util.Utils;
import java.awt.Color;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;

public class RunicMobsHighlight {
    private static ConcurrentMap<Integer, class_1297> runicEntities = new ConcurrentHashMap<Integer, class_1297>();

    public static void init() {
        TickSchedulerHelper.repeat(RunicMobsHighlight::onTick, 5L);
        EntityEvents.REMOVE.register(RunicMobsHighlight::onEntityRemove);
        WorldRenderEvents.AFTER_ENTITIES.register(RunicMobsHighlight::renderRunicBox);
    }

    private static void onTick() {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        if (!Utils.isOnSkyblock()) {
            return;
        }
        if (!Skyblock21ConfigManager.get().general.runicMobHighlight) {
            return;
        }
        for (class_1297 entity : client.field_1687.method_18112()) {
            class_1297 originalEntity;
            if (!RunicMobsHighlight.isRunicMobName(entity) || (originalEntity = (class_1297)client.field_1687.method_8335(entity, entity.method_5829().method_1009(0.2, 1.0, 0.2)).stream().findFirst().orElse(null)) == null) continue;
            runicEntities.put(originalEntity.method_5628(), originalEntity);
        }
    }

    private static boolean isRunicMobName(class_1297 entity) {
        return entity instanceof class_1531 && entity.method_16914() && TextUtils.toLegacy(entity.method_5797()).contains("\u00a75]");
    }

    private static void renderRunicBox(WorldRenderContext worldRenderContext) {
        if (!Utils.isOnSkyblock()) {
            return;
        }
        if (!Skyblock21ConfigManager.get().general.runicMobHighlight) {
            return;
        }
        runicEntities.entrySet().removeIf(entry -> entry.getValue() == null || ((class_1297)entry.getValue()).method_31481() || !((class_1297)entry.getValue()).method_5805());
        for (Map.Entry e : runicEntities.entrySet()) {
            class_310 client = class_310.method_1551();
            class_243 cameraPos = client.field_1773.method_19418().method_19326();
            class_4587 matrices = worldRenderContext.matrixStack();
            Render3DUtil.renderEntityFilledBox(worldRenderContext, matrices, (class_1297)e.getValue(), cameraPos, ColorUtil.getIntFromColor(new Color(155, 0, 255, 255)), 0.7f, 0.3f);
        }
    }

    private static void onEntityRemove(int entityId) {
        runicEntities.remove(entityId);
    }
}

