/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.features;

import com.skyblock21.config.Skyblock21ConfigManager;
import com.skyblock21.util.Render3DUtil;
import com.skyblock21.util.TextUtils;
import com.skyblock21.util.Utils;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1431;
import net.minecraft.class_1531;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_9290;
import net.minecraft.class_9334;

public class SpinHelper {
    private static final List<SpinEntry> spinEntries = new ArrayList<SpinEntry>();
    private static boolean isHoldingFishingNet = false;
    private static int pullAmount = 0;

    public static void init() {
        ClientTickEvents.END_CLIENT_TICK.register(SpinHelper::onTick);
        WorldRenderEvents.AFTER_ENTITIES.register(SpinHelper::renderSpinEntities);
    }

    private static void renderSpinEntities(WorldRenderContext worldRenderContext) {
        if (!(Utils.isOnSkyblock() && Utils.isInGalatea() && isHoldingFishingNet)) {
            return;
        }
        if (!Skyblock21ConfigManager.get().hunting.spinHelper) {
            return;
        }
        for (SpinEntry entry : spinEntries) {
            if (!entry.isValidForRendering()) {
                return;
            }
            class_310 client = class_310.method_1551();
            class_243 cameraPos = client.field_1773.method_19418().method_19326();
            class_4587 matrices = worldRenderContext.matrixStack();
            Render3DUtil.renderEntityFilledBox(worldRenderContext, matrices, (class_1297)entry.spinFish, cameraPos, entry.canSpin(pullAmount) ? 65280 : 0xFF5555, 0.5f);
        }
    }

    private static void onTick(class_310 client) {
        if (client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        if (!Utils.isOnSkyblock() || !Utils.isInGalatea()) {
            return;
        }
        if (!Skyblock21ConfigManager.get().hunting.spinHelper) {
            return;
        }
        spinEntries.forEach(SpinEntry::update);
        SpinHelper.updateFishingNetState(client);
        SpinHelper.updateSpinEntries(client);
        SpinHelper.cleanupInvalidEntries();
    }

    private static void updateFishingNetState(class_310 client) {
        class_1799 mainHandItem = client.field_1724.method_6047();
        if (mainHandItem == null || mainHandItem.method_7909() != class_1802.field_8786) {
            isHoldingFishingNet = false;
            pullAmount = 0;
            return;
        }
        String itemName = mainHandItem.method_65130() != null ? mainHandItem.method_65130().getString() : "";
        isHoldingFishingNet = itemName.endsWith("Fishing Net");
        if (isHoldingFishingNet) {
            pullAmount = SpinHelper.extractPullAmount(mainHandItem);
        }
    }

    private static int extractPullAmount(class_1799 fishingNet) {
        class_9290 loreComponent = (class_9290)fishingNet.method_58694(class_9334.field_49632);
        if (loreComponent == null || loreComponent.comp_2400().isEmpty()) {
            return 0;
        }
        for (class_2561 loreLine : loreComponent.comp_2400()) {
            if (!loreLine.getString().contains("Pull")) continue;
            String cleanText = TextUtils.removeFormatting(loreLine).replace("Pull: +", "").trim();
            return (int)Math.ceil(Double.parseDouble(cleanText));
        }
        return 0;
    }

    private static void updateSpinEntries(class_310 client) {
        List<class_1531> newSpinArmorStands = SpinHelper.findNewSpinArmorStands(client);
        for (class_1531 spinArmorStand : newSpinArmorStands) {
            SpinEntry newEntry = SpinHelper.createSpinEntry(client, spinArmorStand);
            if (newEntry == null) continue;
            spinEntries.add(newEntry);
        }
    }

    private static List<class_1531> findNewSpinArmorStands(class_310 client) {
        class_238 searchBox = client.field_1724.method_5829().method_1009(18.0, 18.0, 18.0);
        List allSpinArmorStands = client.field_1687.method_8390(class_1531.class, searchBox, SpinHelper::isSpinArmorStand);
        return allSpinArmorStands.stream().filter(armorStand -> spinEntries.stream().noneMatch(entry -> entry.armorStand.equals(armorStand))).toList();
    }

    private static boolean isSpinArmorStand(class_1531 armorStand) {
        return armorStand.method_16914() && armorStand.method_5797().getString().contains("\u00ab SPIN \u00bb");
    }

    private static SpinEntry createSpinEntry(class_310 client, class_1531 spinArmorStand) {
        class_1531 percentageArmorStand = SpinHelper.findPercentageArmorStand(client, spinArmorStand);
        if (percentageArmorStand == null) {
            return null;
        }
        class_1431 spinFish = SpinHelper.findSpinFish(client, percentageArmorStand);
        if (spinFish == null) {
            return null;
        }
        return new SpinEntry(spinArmorStand, percentageArmorStand, spinFish);
    }

    private static class_1531 findPercentageArmorStand(class_310 client, class_1531 spinArmorStand) {
        class_238 searchBox = spinArmorStand.method_5829().method_1009(0.1, 0.6, 0.1);
        return client.field_1687.method_8390(class_1531.class, searchBox, SpinHelper::isPercentageArmorStand).stream().findFirst().orElse(null);
    }

    private static boolean isPercentageArmorStand(class_1531 armorStand) {
        return armorStand.method_16914() && armorStand.method_5797().getString().endsWith("%");
    }

    private static class_1431 findSpinFish(class_310 client, class_1531 percentageArmorStand) {
        class_238 searchBox = percentageArmorStand.method_5829().method_1009(0.1, 0.6, 0.1);
        return client.field_1687.method_8390(class_1431.class, searchBox, entity -> true).stream().findFirst().orElse(null);
    }

    private static void cleanupInvalidEntries() {
        spinEntries.removeIf(entry -> !entry.isValid());
    }

    private static class SpinEntry {
        private final class_1531 armorStand;
        private final class_1531 spinArmorStand;
        private final class_1431 spinFish;
        public double spinPercentage;

        public SpinEntry(class_1531 armorStand, class_1531 spinArmorStand, class_1431 spinFish) {
            this.armorStand = armorStand;
            this.spinArmorStand = spinArmorStand;
            this.spinFish = spinFish;
        }

        public void update() {
            if (this.spinArmorStand == null || this.spinFish == null) {
                return;
            }
            String percString = this.spinArmorStand.method_5797().getString();
            if (percString.endsWith("%")) {
                try {
                    this.spinPercentage = Double.parseDouble(percString.replace("%", ""));
                }
                catch (NumberFormatException e) {
                    this.spinPercentage = 0.0;
                }
            } else {
                this.spinPercentage = 0.0;
            }
        }

        private boolean canSpin(int spinPercentage) {
            return this.spinPercentage + (double)spinPercentage <= 100.0;
        }

        public boolean isValid() {
            return this.armorStand != null && !this.armorStand.method_31481() && this.armorStand.method_5805();
        }

        public boolean isValidForRendering() {
            return this.isValid() && this.spinFish != null && !this.spinFish.method_31481() && this.spinFish.method_5805();
        }
    }
}

