/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.features.commandaliases;

import com.skyblock21.config.persistent.PersistentData;
import com.skyblock21.features.commandaliases.Alias;
import com.skyblock21.gui.Theme;
import com.skyblock21.gui.ThemeManager;
import com.skyblock21.gui.components.Button;
import com.skyblock21.gui.components.Checkbox;
import com.skyblock21.gui.components.Label;
import com.skyblock21.gui.components.RoundedContainer;
import com.skyblock21.gui.components.TextBox;
import com.skyblock21.util.ColorUtil;
import com.skyblock21.util.TickSchedulerHelper;
import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Animatable;
import io.wispforest.owo.ui.core.Animation;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Easing;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;

public class CommandAliasesScreen
extends BaseOwoScreen<FlowLayout> {
    private final class_437 parent;
    private final List<AliasEntry> entries = new ArrayList<AliasEntry>();
    private FlowLayout entriesContainer;
    private ScrollContainer<FlowLayout> scrollContainer;
    private static Animation animation;

    public CommandAliasesScreen(class_437 parent) {
        this.parent = parent;
        this.loadAliases();
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::verticalFlow);
    }

    public void method_25426() {
        super.method_25426();
        animation.forwards();
    }

    protected void build(FlowLayout rootComponent) {
        Theme theme = ThemeManager.getCurrentTheme();
        rootComponent.surface(Surface.blur((float)3.0f, (float)10.0f)).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER);
        FlowLayout mainContainer = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)85), (Sizing)Sizing.fixed((int)0)).horizontalAlignment(HorizontalAlignment.CENTER);
        animation = mainContainer.verticalSizing().animate(500, Easing.CUBIC, (Animatable)Sizing.fill((int)90));
        mainContainer.gap(10);
        rootComponent.child((Component)mainContainer);
        mainContainer.child((Component)new Label((class_2561)class_2561.method_43470((String)"Command Aliases")).shadow(true).color(Color.ofArgb((int)ColorUtil.getIntFromColor(theme.getPrimary()))));
        FlowLayout headerRow = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill(), (Sizing)Sizing.content()).padding(Insets.both((int)5, (int)5));
        headerRow.gap(10);
        headerRow.child(new Label((class_2561)class_2561.method_43470((String)"Enabled")).color(Color.ofArgb((int)ColorUtil.getIntFromColor(theme.text))).horizontalSizing(Sizing.fill((int)7))).child(new Label((class_2561)class_2561.method_43470((String)"Alias Command")).color(Color.ofArgb((int)ColorUtil.getIntFromColor(theme.text))).horizontalSizing(Sizing.fill((int)30))).child(new Label((class_2561)class_2561.method_43470((String)"Target Command")).color(Color.ofArgb((int)ColorUtil.getIntFromColor(theme.text))).horizontalSizing(Sizing.fill((int)50))).child(new Label((class_2561)class_2561.method_43470((String)"Actions")).color(Color.ofArgb((int)ColorUtil.getIntFromColor(theme.text))).horizontalSizing(Sizing.fill((int)20)));
        mainContainer.child((Component)new RoundedContainer(Sizing.content(), Sizing.content(), theme.getRounding(), theme.getSecondaryBackground(), FlowLayout.Algorithm.HORIZONTAL).child((Component)headerRow).padding(Insets.both((int)10, (int)5)));
        this.entriesContainer = Containers.verticalFlow((Sizing)Sizing.fill(), (Sizing)Sizing.content());
        this.entriesContainer.gap(5);
        this.scrollContainer = Containers.verticalScroll((Sizing)Sizing.fill(), (Sizing)Sizing.fill((int)80), (Component)this.entriesContainer);
        this.scrollContainer.scrollbar(ScrollContainer.Scrollbar.flat((Color)Color.ofArgb((int)ColorUtil.getIntFromColor(theme.getPrimary()))));
        mainContainer.child((Component)new RoundedContainer(Sizing.content(), Sizing.content(), theme.getRounding(), theme.getBackground(), FlowLayout.Algorithm.VERTICAL).child((Component)this.scrollContainer).surface(Surface.VANILLA_TRANSLUCENT).padding(Insets.both((int)10, (int)10)));
        FlowLayout buttonsContainer = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        buttonsContainer.gap(10);
        buttonsContainer.child(new Button((class_2561)class_2561.method_43470((String)"Add New Alias"), theme.getPrimary(), theme.getBackground(), button -> this.addNewEntry()).textShadow(false).horizontalSizing(Sizing.content((int)10))).child(new Button((class_2561)class_2561.method_43470((String)"Done"), theme.getPrimary(), theme.getBackground(), button -> {
            this.save();
            this.method_25419();
        }).textShadow(false).horizontalSizing(Sizing.content((int)6))).child(new Button((class_2561)class_2561.method_43470((String)"Cancel"), theme.getSecondaryBackground(), theme.text, button -> this.method_25419()).textShadow(false).horizontalSizing(Sizing.content((int)6)));
        mainContainer.child((Component)buttonsContainer);
        this.buildEntryWidgets();
    }

    private void loadAliases() {
        this.entries.clear();
        for (Alias alias : PersistentData.get().aliases) {
            this.entries.add(new AliasEntry(alias));
        }
        if (this.entries.isEmpty() || !this.entries.get(this.entries.size() - 1).isEmpty()) {
            this.entries.add(new AliasEntry(new Alias()));
        }
    }

    private void buildEntryWidgets() {
        if (this.entriesContainer == null) {
            return;
        }
        this.saveFormState();
        this.entriesContainer.clearChildren();
        for (int i = 0; i < this.entries.size(); ++i) {
            int index = i;
            AliasEntry entry = this.entries.get(i);
            FlowLayout entryRow = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
            entryRow.gap(10);
            entryRow.margins(Insets.vertical((int)2));
            entryRow.verticalAlignment(VerticalAlignment.CENTER);
            entry.enabledCheckbox = new Checkbox((class_2561)class_2561.method_43470((String)"")).checked(entry.alias.enabled);
            entryRow.child(entry.enabledCheckbox.sizing(Sizing.fixed((int)16)));
            entry.aliasField = new TextBox(Sizing.fill((int)30), (class_2561)class_2561.method_43470((String)"Alias"));
            entry.aliasField.method_1852(entry.alias.aliasCommand);
            entry.aliasField.method_1880(64);
            entryRow.child((Component)entry.aliasField);
            entry.targetField = new TextBox(Sizing.fill((int)50), (class_2561)class_2561.method_43470((String)"Target"));
            entry.targetField.method_1852(entry.alias.targetCommand);
            entry.targetField.method_1880(512);
            entryRow.child((Component)entry.targetField);
            Button removeButton = (Button)new Button((class_2561)class_2561.method_43470((String)"Remove"), ThemeManager.getCurrentTheme().getSecondaryBackground(), ThemeManager.getCurrentTheme().text, button -> this.removeEntry(index)).textShadow(false).horizontalSizing(Sizing.fill((int)7));
            entryRow.child((Component)removeButton);
            Theme theme = ThemeManager.getCurrentTheme();
            FlowLayout entryContainer = (FlowLayout)new RoundedContainer(Sizing.content(), Sizing.content(), theme.getRounding(), theme.getBackground(), FlowLayout.Algorithm.HORIZONTAL).child((Component)entryRow).padding(Insets.both((int)8, (int)5));
            this.entriesContainer.child((Component)entryContainer);
        }
        Label countLabel = new Label((class_2561)class_2561.method_43470((String)String.format("Aliases: %d", Math.max(0, this.entries.size() - 1)))).color(Color.ofArgb((int)ColorUtil.getIntFromColor(ThemeManager.getCurrentTheme().getTextSecondary())));
        this.entriesContainer.child((Component)countLabel);
    }

    private void addNewEntry() {
        this.saveFormState();
        this.entries.add(new AliasEntry(new Alias()));
        this.buildEntryWidgets();
    }

    private void removeEntry(int index) {
        this.updateEntriesFromFields();
        if (index < this.entries.size()) {
            this.entries.remove(index);
            this.buildEntryWidgets();
        }
    }

    private void saveFormState() {
        for (AliasEntry entry : this.entries) {
            if (entry.aliasField != null) {
                entry.alias.aliasCommand = entry.aliasField.method_1882();
            }
            if (entry.targetField != null) {
                entry.alias.targetCommand = entry.targetField.method_1882();
            }
            if (entry.enabledCheckbox == null) continue;
            entry.alias.enabled = entry.enabledCheckbox.method_20372();
        }
    }

    private void updateEntriesFromFields() {
        AliasEntry lastEntry;
        this.saveFormState();
        if (!(this.entries.isEmpty() || (lastEntry = this.entries.get(this.entries.size() - 1)).isEmpty() || lastEntry.alias.aliasCommand.trim().isEmpty() && lastEntry.alias.targetCommand.trim().isEmpty())) {
            this.entries.add(new AliasEntry(new Alias()));
            this.buildEntryWidgets();
        }
    }

    private void save() {
        this.updateEntriesFromFields();
        PersistentData.get().aliases.clear();
        for (AliasEntry entry : this.entries) {
            String targetCommand;
            String aliasCommand;
            if (entry.alias.aliasCommand.trim().isEmpty() || entry.alias.targetCommand.trim().isEmpty() || (aliasCommand = entry.alias.aliasCommand.trim()) == (targetCommand = entry.alias.targetCommand.trim())) continue;
            if (aliasCommand.startsWith("/")) {
                aliasCommand = aliasCommand.substring(1).trim();
            }
            if (targetCommand.startsWith("/")) {
                targetCommand = targetCommand.substring(1).trim();
            }
            Alias cleanedAlias = new Alias();
            cleanedAlias.aliasCommand = aliasCommand;
            cleanedAlias.targetCommand = targetCommand;
            cleanedAlias.enabled = entry.alias.enabled;
            PersistentData.get().aliases.add(cleanedAlias);
        }
        PersistentData.get().aliases.removeIf(alias -> {
            for (Alias other : PersistentData.get().aliases) {
                if (alias.equals(other) || !alias.targetCommand.equals(other.aliasCommand)) continue;
                return true;
            }
            return false;
        });
        PersistentData.save();
    }

    public void method_25419() {
        animation.backwards();
        TickSchedulerHelper.runAfter(() -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507(this.parent);
            }
        }, 10L);
    }

    private static class AliasEntry {
        public final Alias alias;
        public TextBox aliasField;
        public TextBox targetField;
        public Checkbox enabledCheckbox;

        public AliasEntry(Alias alias) {
            this.alias = alias;
        }

        public boolean isEmpty() {
            return this.alias.aliasCommand.trim().isEmpty() && this.alias.targetCommand.trim().isEmpty();
        }
    }
}

