/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.features.itemcustomization;

import com.skyblock21.config.persistent.PersistentData;
import com.skyblock21.features.itemcustomization.ItemCustomization;
import com.skyblock21.gui.Theme;
import com.skyblock21.gui.ThemeManager;
import com.skyblock21.gui.components.Button;
import com.skyblock21.gui.components.Checkbox;
import com.skyblock21.gui.components.Label;
import com.skyblock21.gui.components.RoundedContainer;
import com.skyblock21.gui.components.TextBox;
import com.skyblock21.util.ItemUtils;
import com.skyblock21.util.TextUtils;
import com.skyblock21.util.TickSchedulerHelper;
import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.ItemComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Animatable;
import io.wispforest.owo.ui.core.Animation;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Easing;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_7923;
import net.minecraft.class_9279;
import net.minecraft.class_9290;
import net.minecraft.class_9322;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class ItemCustomizationScreen
extends BaseOwoScreen<FlowLayout> {
    private final class_1799 itemStack;
    private final String itemUuid;
    private ItemCustomization customization;
    private TextBox itemNameComponent;
    private Checkbox glintComponent;
    private TextBox itemIdComponent;
    private ItemComponent preview;
    private static final String[][] COLOR_CODES = new String[][]{{"&0", "Black", "0x000000"}, {"&1", "Dark Blue", "0x0000AA"}, {"&2", "Dark Green", "0x00AA00"}, {"&3", "Dark Aqua", "0x00AAAA"}, {"&4", "Dark Red", "0xAA0000"}, {"&5", "Dark Purple", "0xAA00AA"}, {"&6", "Gold", "0xFFAA00"}, {"&7", "Gray", "0xAAAAAA"}, {"&8", "Dark Gray", "0x555555"}, {"&9", "Blue", "0x5555FF"}, {"&a", "Green", "0x55FF55"}, {"&b", "Aqua", "0x55FFFF"}, {"&c", "Red", "0xFF5555"}, {"&d", "Light Purple", "0xFF55FF"}, {"&e", "Yellow", "0xFFFF55"}, {"&f", "White", "0xFFFFFF"}};
    private static final String[][] FORMAT_CODES = new String[][]{{"&k", "Obfuscated", "Random chars"}, {"&l", "Bold", "Bold text"}, {"&m", "Strikethrough", "Crossed out"}, {"&n", "Underline", "Underlined"}, {"&o", "Italic", "Italic text"}, {"&r", "Reset", "Reset formatting"}};
    private static Animation animation;

    public ItemCustomizationScreen(class_1799 itemStack) {
        this.itemStack = itemStack;
        this.itemUuid = ItemUtils.getItemUUID((class_9322)itemStack);
        this.customization = PersistentData.get().itemCustomizations.getOrDefault(this.itemUuid, new ItemCustomization());
        String name = this.customization.customName.isEmpty() ? (itemStack.method_65130() != null ? TextUtils.translateColorCodes(TextUtils.toLegacy(itemStack.method_65130()), true) : "") : this.customization.customName;
        this.itemNameComponent = new TextBox(Sizing.fixed((int)210), (class_2561)class_2561.method_43470((String)"Item name"));
        this.itemNameComponent.method_1880(200);
        this.itemNameComponent.method_1852(name);
        this.itemNameComponent.setPreviewColors(true);
        this.glintComponent = new Checkbox((class_2561)class_2561.method_43470((String)"Glint")).checked(this.customization.hasGlint);
        this.itemIdComponent = new TextBox(Sizing.fixed((int)150), (class_2561)class_2561.method_43470((String)"ID"));
        this.itemIdComponent.method_1852(this.customization.customItemId.isEmpty() ? class_7923.field_41178.method_10221((Object)itemStack.method_7909()).method_12832() : this.customization.customItemId);
        this.itemIdComponent.onChanged().subscribe(s -> {
            class_1799 newPreviewStack = this.createPreviewStack();
            this.preview.stack(newPreviewStack);
        });
        this.itemNameComponent.onChanged().subscribe(s -> {
            class_1799 newPreviewStack = this.createPreviewStack();
            this.preview.stack(newPreviewStack);
        });
        this.glintComponent.onChanged(s -> {
            class_1799 newPreviewStack = this.createPreviewStack();
            this.preview.stack(newPreviewStack);
        });
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::horizontalFlow);
    }

    public void method_25426() {
        super.method_25426();
        animation.forwards();
    }

    protected void build(FlowLayout rootComponent) {
        String name;
        String code;
        class_1799 previewStack = this.createPreviewStack();
        Theme theme = ThemeManager.getCurrentTheme();
        this.preview = Components.item((class_1799)previewStack);
        this.preview.sizing(Sizing.fixed((int)80));
        this.preview.setTooltipFromStack(true);
        this.preview.margins(Insets.both((int)10, (int)10));
        FlowLayout idGlintContainer = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).gap(6);
        idGlintContainer.child((Component)this.itemIdComponent).child((Component)this.glintComponent);
        rootComponent.horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER);
        FlowLayout container = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fixed((int)0), (Sizing)Sizing.fill()).alignment(HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        animation = container.horizontalSizing().animate(500, Easing.CUBIC, (Animatable)Sizing.fill());
        rootComponent.child((Component)container);
        FlowLayout buttonsContainer = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).gap(6);
        buttonsContainer.child(new Button((class_2561)class_2561.method_43470((String)"Apply"), theme.primary, theme.background, button -> this.save()).textShadow(false).horizontalSizing(Sizing.content((int)6))).child(new Button((class_2561)class_2561.method_43470((String)"Reset"), theme.getSecondaryBackground(), theme.text, button -> this.reset()).textShadow(false).horizontalSizing(Sizing.content((int)6))).child(new Button((class_2561)class_2561.method_43470((String)"Cancel"), theme.getSecondaryBackground(), theme.text, button -> this.method_25419()).textShadow(false).horizontalSizing(Sizing.content((int)6)));
        container.child((Component)new RoundedContainer(Sizing.content(), Sizing.content(), theme.getRounding(), theme.background, FlowLayout.Algorithm.VERTICAL).gap(8).child((Component)this.preview).child((Component)this.itemNameComponent).child((Component)idGlintContainer).child((Component)buttonsContainer).surface(Surface.VANILLA_TRANSLUCENT).padding(Insets.both((int)15, (int)15)).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER));
        FlowLayout stylingContainer = new RoundedContainer(Sizing.content(), Sizing.content(), theme.getRounding(), theme.background, FlowLayout.Algorithm.VERTICAL).gap(5);
        stylingContainer.surface(Surface.VANILLA_TRANSLUCENT);
        stylingContainer.padding(Insets.both((int)15, (int)15));
        for (String[] colorCode : COLOR_CODES) {
            code = colorCode[0];
            name = colorCode[1];
            String formattedCode = code.replace('&', '\u00a7');
            stylingContainer.child((Component)new Label((class_2561)class_2561.method_43470((String)(formattedCode + code + " " + name))).shadow(true));
        }
        for (String[] formatCode : FORMAT_CODES) {
            code = formatCode[0];
            name = formatCode[1];
            stylingContainer.child((Component)new Label((class_2561)class_2561.method_43470((String)(code + " " + name))).shadow(true));
        }
        container.child((Component)Components.spacer((int)2));
        container.child((Component)stylingContainer);
        rootComponent.surface(Surface.blur((float)3.0f, (float)10.0f));
    }

    private class_1799 createPreviewStack() {
        String customName;
        class_1799 preview = this.itemStack.method_7972();
        String customItemId = this.itemIdComponent.method_1882().trim();
        if (!customItemId.isEmpty()) {
            try {
                class_1792 customItem;
                class_2960 id = class_2960.method_12829((String)customItemId);
                if (id != null && (customItem = (class_1792)class_7923.field_41178.method_63535(id)) != null && !customItem.equals(class_7923.field_41178.method_63535(class_2960.method_60654((String)"air")))) {
                    preview = new class_1799((class_1935)customItem, preview.method_7947());
                    preview.method_57379(class_9334.field_49628, (Object)((class_9279)this.itemStack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302)));
                    class_9290 lore = (class_9290)this.itemStack.method_58694(class_9334.field_49632);
                    if (lore != null) {
                        preview.method_57379(class_9334.field_49632, (Object)lore);
                    }
                }
            }
            catch (Exception id) {
                // empty catch block
            }
        }
        if (!(customName = this.itemNameComponent.method_1882().trim()).isEmpty()) {
            String formattedName = TextUtils.translateColorCodes(customName, false);
            preview.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)formattedName));
        }
        if (this.glintComponent.method_20372()) {
            preview.method_57379(class_9334.field_49641, (Object)true);
        } else {
            preview.method_57379(class_9334.field_49641, (Object)false);
        }
        return preview;
    }

    private void save() {
        ItemCustomization newCustomization;
        ItemCustomization temp;
        String itemId = this.itemIdComponent.method_1882().trim();
        if (!itemId.isEmpty() && !(temp = new ItemCustomization("", itemId, false)).isValidItemId()) {
            itemId = class_7923.field_41178.method_10221((Object)this.itemStack.method_7909()).method_12832();
        }
        if ((newCustomization = new ItemCustomization(this.itemNameComponent.method_1882(), itemId, this.glintComponent.method_20372())).hasCustomName() || newCustomization.hasCustomItemId() || newCustomization.hasGlint) {
            PersistentData.get().itemCustomizations.put(this.itemUuid, newCustomization);
        } else {
            PersistentData.get().itemCustomizations.remove(this.itemUuid);
        }
        PersistentData.save();
        this.method_25419();
    }

    private void reset() {
        this.itemNameComponent.method_1852(this.itemStack.method_65130() != null ? TextUtils.translateColorCodes(TextUtils.toLegacy(this.itemStack.method_65130()), true) : "");
        this.itemIdComponent.method_1852(class_7923.field_41178.method_10221((Object)this.itemStack.method_7909()).method_12832());
    }

    public void method_25419() {
        animation.backwards();
        TickSchedulerHelper.runAfter(() -> super.method_25419(), 10L);
    }
}

