/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.features.items;

import com.skyblock21.config.Skyblock21Config;
import com.skyblock21.config.Skyblock21ConfigManager;
import com.skyblock21.util.TextUtils;
import com.skyblock21.util.Utils;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2561;

public class CompactStars {
    private static final String star = "\u272a";
    private static final List<String> masterStars = Arrays.asList("\u278a", "\u278b", "\u278c", "\u278d", "\u278e");
    private static final List<String> circledNumbers = Arrays.asList("\u278a", "\u278b", "\u278c", "\u278d", "\u278e", "\u277b", "\u277c", "\u277d", "\u277e", "\u277f");
    private static final Pattern starRegex = Pattern.compile("\u00a76" + Pattern.quote("\u272a") + "+");
    private static final Pattern masterStarRegex = Pattern.compile("\u00a7c(?<tier>[\u278a\u278b\u278c\u278d\u278e])");

    public static class_2561 modifyText(class_2561 text) {
        if (text == null || !Utils.isOnSkyblock() || Skyblock21ConfigManager.get().general.compactStarMode == Skyblock21Config.General.CompactStarMode.NONE || !text.getString().contains(star)) {
            return text;
        }
        String modifiedName = CompactStars.modifyStars(TextUtils.toLegacy(text));
        if (modifiedName.equals(TextUtils.toLegacy(text))) {
            return text;
        }
        return class_2561.method_43470((String)modifiedName);
    }

    private static String modifyStars(String displayName) {
        if (!Utils.isOnSkyblock() || Skyblock21ConfigManager.get().general.compactStarMode == Skyblock21Config.General.CompactStarMode.NONE || !displayName.contains(star)) {
            return displayName;
        }
        try {
            int totalStarLevel;
            int regularStars = CompactStars.countMatches(displayName, star);
            int masterStars = 0;
            Matcher masterStarMatcher = masterStarRegex.matcher(displayName);
            if (masterStarMatcher.find()) {
                String masterStarSymbol = masterStarMatcher.group("tier");
                masterStars = CompactStars.masterStars.indexOf(masterStarSymbol) + 1;
            }
            if ((totalStarLevel = regularStars + masterStars) == 0) {
                return displayName;
            }
            String cleanedName = displayName.replaceAll(starRegex.pattern(), "").replaceAll(masterStarRegex.pattern(), "");
            switch (Skyblock21ConfigManager.get().general.compactStarMode) {
                case COMPACT: {
                    if (totalStarLevel <= 5) {
                        String circledNumber = circledNumbers.get(totalStarLevel - 1);
                        return cleanedName + "\u00a76" + circledNumber;
                    }
                    int masterLevel = totalStarLevel - 5;
                    String circledNumber = circledNumbers.get(masterLevel - 1);
                    return cleanedName + "\u00a7c" + circledNumber;
                }
                case COMPACT_TILL_TEN: {
                    String colorCode = totalStarLevel > 5 ? "\u00a7c" : "\u00a76";
                    String circledNumber = circledNumbers.get(totalStarLevel - 1);
                    return cleanedName + colorCode + circledNumber;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return displayName;
    }

    private static int countMatches(String text, String pattern) {
        int count = 0;
        int index = 0;
        while ((index = text.indexOf(pattern, index)) != -1) {
            ++count;
            index += pattern.length();
        }
        return count;
    }

    private static String repeat(String str, int times) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < times; ++i) {
            sb.append(str);
        }
        return sb.toString();
    }
}

