/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.features.keyshortcuts;

import com.skyblock21.config.persistent.PersistentData;
import com.skyblock21.features.keyshortcuts.Modifier;
import com.skyblock21.features.keyshortcuts.Shortcut;
import com.skyblock21.gui.Theme;
import com.skyblock21.gui.ThemeManager;
import com.skyblock21.gui.components.Button;
import com.skyblock21.gui.components.Checkbox;
import com.skyblock21.gui.components.Label;
import com.skyblock21.gui.components.RoundedContainer;
import com.skyblock21.gui.components.TextBox;
import com.skyblock21.util.ColorUtil;
import com.skyblock21.util.TickSchedulerHelper;
import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Animatable;
import io.wispforest.owo.ui.core.Animation;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Easing;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFW;

public class KeyShortcutsScreen
extends BaseOwoScreen<FlowLayout> {
    private final List<ShortcutEntry> entries = new ArrayList<ShortcutEntry>();
    private ScrollContainer<FlowLayout> scrollContainer;
    private FlowLayout entriesContainer;
    private ShortcutEntry listeningEntry = null;
    private Animation animation;
    private class_437 parent;

    public KeyShortcutsScreen(class_437 parent) {
        this.parent = parent;
        this.loadEntries();
    }

    private void loadEntries() {
        this.entries.clear();
        for (Shortcut shortcut : PersistentData.get().shortcuts) {
            this.entries.add(new ShortcutEntry(shortcut));
        }
        if (this.entries.isEmpty() || !this.entries.get(this.entries.size() - 1).isEmpty()) {
            this.entries.add(new ShortcutEntry(new Shortcut()));
        }
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::verticalFlow);
    }

    protected void build(FlowLayout rootComponent) {
        Theme theme = ThemeManager.getCurrentTheme();
        rootComponent.horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER).surface(Surface.blur((float)3.0f, (float)10.0f));
        FlowLayout mainContainer = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)85), (Sizing)Sizing.fixed((int)0)).horizontalAlignment(HorizontalAlignment.CENTER);
        this.animation = mainContainer.verticalSizing().animate(500, Easing.CUBIC, (Animatable)Sizing.fill((int)90));
        mainContainer.gap(10);
        rootComponent.child((Component)mainContainer);
        mainContainer.child((Component)new Label((class_2561)class_2561.method_43470((String)"Key Shortcuts")).shadow(true).color(io.wispforest.owo.ui.core.Color.ofArgb((int)ColorUtil.getIntFromColor(theme.getPrimary()))));
        FlowLayout headerRow = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill(), (Sizing)Sizing.content()).padding(Insets.both((int)5, (int)5));
        headerRow.gap(10);
        headerRow.child(new Label((class_2561)class_2561.method_43470((String)"Enabled")).color(io.wispforest.owo.ui.core.Color.ofArgb((int)ColorUtil.getIntFromColor(theme.text))).horizontalSizing(Sizing.fill((int)6))).child(new Label((class_2561)class_2561.method_43470((String)"Command")).color(io.wispforest.owo.ui.core.Color.ofArgb((int)ColorUtil.getIntFromColor(theme.text))).horizontalSizing(Sizing.fill((int)45))).child(new Label((class_2561)class_2561.method_43470((String)"Keybind")).color(io.wispforest.owo.ui.core.Color.ofArgb((int)ColorUtil.getIntFromColor(theme.text))).horizontalSizing(Sizing.fill((int)20))).child(new Label((class_2561)class_2561.method_43470((String)"Actions")).color(io.wispforest.owo.ui.core.Color.ofArgb((int)ColorUtil.getIntFromColor(theme.text))).horizontalSizing(Sizing.fill((int)7)));
        mainContainer.child((Component)new RoundedContainer(Sizing.content(), Sizing.content(), theme.getRounding(), theme.getSecondaryBackground(), FlowLayout.Algorithm.HORIZONTAL).child((Component)headerRow).padding(Insets.both((int)10, (int)5)));
        this.entriesContainer = Containers.verticalFlow((Sizing)Sizing.fill(), (Sizing)Sizing.content());
        this.entriesContainer.gap(5);
        this.scrollContainer = Containers.verticalScroll((Sizing)Sizing.fill(), (Sizing)Sizing.fill((int)80), (Component)this.entriesContainer);
        this.scrollContainer.scrollbar(ScrollContainer.Scrollbar.flat((io.wispforest.owo.ui.core.Color)io.wispforest.owo.ui.core.Color.ofArgb((int)ColorUtil.getIntFromColor(theme.getPrimary()))));
        mainContainer.child((Component)new RoundedContainer(Sizing.content(), Sizing.content(), theme.getRounding(), theme.background, FlowLayout.Algorithm.VERTICAL).child((Component)this.scrollContainer).surface(Surface.VANILLA_TRANSLUCENT).padding(Insets.both((int)10, (int)10)));
        FlowLayout buttonsContainer = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        buttonsContainer.gap(10);
        buttonsContainer.child(new Button((class_2561)class_2561.method_43470((String)"Cancel"), theme.getSecondaryBackground(), theme.text, button -> super.method_25419()).textShadow(false).horizontalSizing(Sizing.content((int)6)));
        mainContainer.child((Component)buttonsContainer);
        this.rebuildEntries();
    }

    public void method_25426() {
        super.method_25426();
        this.animation.forwards();
    }

    private void rebuildEntries() {
        this.saveFormState();
        this.entriesContainer.clearChildren();
        for (int i = 0; i < this.entries.size(); ++i) {
            boolean hasConflict;
            int index = i;
            ShortcutEntry entry = this.entries.get(i);
            FlowLayout entryRow = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
            entryRow.gap(10);
            entryRow.margins(Insets.vertical((int)2));
            entryRow.verticalAlignment(VerticalAlignment.CENTER);
            entry.enabledBox = new Checkbox((class_2561)class_2561.method_43470((String)"")).checked(entry.shortcut.enabled);
            entryRow.child(entry.enabledBox.sizing(Sizing.fixed((int)16)));
            entry.commandField = new TextBox(Sizing.fill((int)50), (class_2561)class_2561.method_43470((String)"Command"));
            entry.commandField.method_1852(entry.shortcut.command);
            entry.commandField.method_1880(500);
            entryRow.child((Component)entry.commandField);
            entry.keybindButton = new KeybindButton(entry, () -> {
                this.saveFormState();
                if (!(index != this.entries.size() - 1 || entry.shortcut.command.trim().isEmpty() && entry.shortcut.keyCode == -1)) {
                    this.entries.add(new ShortcutEntry(new Shortcut()));
                    this.rebuildEntries();
                }
            });
            entryRow.child(entry.keybindButton.horizontalSizing(Sizing.fill((int)20)));
            Button removeButton = (Button)new Button((class_2561)class_2561.method_43470((String)"Remove"), ThemeManager.getCurrentTheme().getSecondaryBackground(), ThemeManager.getCurrentTheme().text, button -> {
                this.saveFormState();
                this.entries.remove(index);
                this.rebuildEntries();
            }).textShadow(false).horizontalSizing(Sizing.fill((int)20));
            entryRow.child((Component)removeButton);
            if (entry.shortcut.keyCode != -1 && this.listeningEntry != entry && (hasConflict = this.entries.stream().anyMatch(other -> other != entry && other.shortcut.keyCode != -1 && other.shortcut.keyCode == entry.shortcut.keyCode && other.shortcut.modifiers.equals(entry.shortcut.modifiers)))) {
                entryRow.child((Component)new Label((class_2561)class_2561.method_43470((String)"X")).color(io.wispforest.owo.ui.core.Color.RED));
            }
            Theme theme = ThemeManager.getCurrentTheme();
            FlowLayout entryContainer = (FlowLayout)new RoundedContainer(Sizing.content(), Sizing.content(), theme.getRounding(), theme.getBackground(), FlowLayout.Algorithm.HORIZONTAL).child((Component)entryRow).padding(Insets.both((int)8, (int)5));
            this.entriesContainer.child((Component)entryContainer);
        }
        Label countLabel = new Label((class_2561)class_2561.method_43470((String)String.format("Total entries: %d", this.entries.size()))).color(io.wispforest.owo.ui.core.Color.ofArgb((int)ColorUtil.getIntFromColor(ThemeManager.getCurrentTheme().text)));
        this.entriesContainer.child((Component)countLabel);
    }

    private void saveFormState() {
        for (ShortcutEntry entry : this.entries) {
            if (entry.commandField != null) {
                entry.shortcut.command = entry.commandField.method_1882();
            }
            if (entry.enabledBox == null) continue;
            entry.shortcut.enabled = entry.enabledBox.method_20372();
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.listeningEntry != null) {
            if (keyCode == 256) {
                this.listeningEntry.shortcut.keyCode = -1;
                this.listeningEntry.shortcut.modifiers = new HashSet<Modifier>();
            } else {
                if (this.isModifierKey(keyCode)) {
                    return true;
                }
                this.listeningEntry.shortcut.keyCode = keyCode;
                this.listeningEntry.shortcut.modifiers = new HashSet<Modifier>();
                if ((modifiers & 2) != 0) {
                    this.listeningEntry.shortcut.modifiers.add(Modifier.CTRL);
                }
                if ((modifiers & 4) != 0) {
                    this.listeningEntry.shortcut.modifiers.add(Modifier.ALT);
                }
                if ((modifiers & 1) != 0) {
                    this.listeningEntry.shortcut.modifiers.add(Modifier.SHIFT);
                }
            }
            this.listeningEntry.keybindButton.notifyKeybindSet();
            this.listeningEntry = null;
            this.rebuildEntries();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.listeningEntry != null) {
            this.listeningEntry.shortcut.keyCode = button + 1000;
            this.listeningEntry.shortcut.modifiers = new HashSet<Modifier>();
            long window = class_310.method_1551().method_22683().method_4490();
            if (GLFW.glfwGetKey((long)window, (int)341) == 1 || GLFW.glfwGetKey((long)window, (int)345) == 1) {
                this.listeningEntry.shortcut.modifiers.add(Modifier.CTRL);
            }
            if (GLFW.glfwGetKey((long)window, (int)342) == 1 || GLFW.glfwGetKey((long)window, (int)346) == 1) {
                this.listeningEntry.shortcut.modifiers.add(Modifier.ALT);
            }
            if (GLFW.glfwGetKey((long)window, (int)340) == 1 || GLFW.glfwGetKey((long)window, (int)344) == 1) {
                this.listeningEntry.shortcut.modifiers.add(Modifier.SHIFT);
            }
            this.listeningEntry = null;
            this.rebuildEntries();
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private boolean isModifierKey(int keyCode) {
        return keyCode == 341 || keyCode == 345 || keyCode == 342 || keyCode == 346 || keyCode == 340 || keyCode == 344 || keyCode == 343 || keyCode == 347;
    }

    private void saveAndClose() {
        this.saveFormState();
        PersistentData.get().shortcuts.clear();
        for (ShortcutEntry entry : this.entries) {
            if (entry.commandField != null) {
                entry.shortcut.command = entry.commandField.method_1882();
            }
            if (entry.enabledBox != null) {
                entry.shortcut.enabled = entry.enabledBox.method_20372();
            }
            if (entry.shortcut.command.trim().isEmpty() || entry.shortcut.keyCode == -1) continue;
            PersistentData.get().shortcuts.add(entry.shortcut);
        }
        PersistentData.save();
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    public void method_25419() {
        this.animation.backwards();
        TickSchedulerHelper.runAfter(this::saveAndClose, 10L);
    }

    private static class ShortcutEntry {
        public Shortcut shortcut;
        public TextBox commandField;
        public Checkbox enabledBox;
        public KeybindButton keybindButton;

        public ShortcutEntry(Shortcut shortcut) {
            this.shortcut = shortcut;
        }

        public boolean isEmpty() {
            return this.shortcut.command.trim().isEmpty() && this.shortcut.keyCode == 0;
        }
    }

    private class KeybindButton
    extends Button {
        private ShortcutEntry entry;
        private Runnable onKeybindSet;

        public KeybindButton(ShortcutEntry entry, Runnable onKeybindSet) {
            super(KeybindButton.getButtonText(entry), ThemeManager.getCurrentTheme().getSecondaryBackground(), ThemeManager.getCurrentTheme().text, button -> {
                com$skyblock21$features$keyshortcuts$KeyShortcutsScreen$this.listeningEntry = entry;
                KeyShortcutsScreen.this.rebuildEntries();
            });
            this.entry = entry;
            this.onKeybindSet = onKeybindSet;
            this.textShadow(false);
        }

        private static class_2561 getButtonText(ShortcutEntry entry) {
            if (entry.shortcut.keyCode == -1) {
                return class_2561.method_43470((String)"Click to set");
            }
            return class_2561.method_43470((String)entry.shortcut.getDisplayString());
        }

        @Override
        protected class_2561 getText() {
            if (KeyShortcutsScreen.this.listeningEntry == this.entry) {
                return class_2561.method_43470((String)"Press a key...").method_27692(class_124.field_1054);
            }
            return KeybindButton.getButtonText(this.entry);
        }

        @Override
        protected Color getBgColor() {
            return KeyShortcutsScreen.this.listeningEntry == this.entry ? ThemeManager.getCurrentTheme().getPrimaryActive() : ThemeManager.getCurrentTheme().getSecondary();
        }

        @Override
        protected Color getTextColor() {
            if (this.entry.shortcut.keyCode == -1) {
                return ThemeManager.getCurrentTheme().getTextSecondary();
            }
            return ThemeManager.getCurrentTheme().text;
        }

        public void notifyKeybindSet() {
            if (this.onKeybindSet != null) {
                this.onKeybindSet.run();
            }
        }
    }
}

