/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.features.keyshortcuts;

import com.skyblock21.features.keyshortcuts.Modifier;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_3675;

public class Shortcut {
    @SerialEntry
    public String command;
    @SerialEntry
    public int keyCode = -1;
    @SerialEntry
    public Set<Modifier> modifiers;
    @SerialEntry
    public boolean enabled;

    public Shortcut() {
        this.command = "";
        this.modifiers = Set.of();
        this.enabled = true;
    }

    public Shortcut(String command, int keyCode, Set<Modifier> modifiers) {
        this.command = command;
        this.keyCode = keyCode;
        this.modifiers = modifiers;
    }

    public boolean hasModifier(Modifier modifier) {
        return this.modifiers.contains((Object)modifier);
    }

    private String getMouseButtonName(int mouseButton) {
        return switch (mouseButton) {
            case 0 -> "Left Click";
            case 1 -> "Right Click";
            case 2 -> "Middle Click";
            case 3 -> "Mouse 4";
            case 4 -> "Mouse 5";
            case 5 -> "Mouse 6";
            case 6 -> "Mouse 7";
            case 7 -> "Mouse 8";
            default -> "Mouse " + (mouseButton + 1);
        };
    }

    public String getDisplayString() {
        StringBuilder display = new StringBuilder();
        if (this.hasModifier(Modifier.CTRL)) {
            display.append("Ctrl + ");
        }
        if (this.hasModifier(Modifier.ALT)) {
            display.append("Alt + ");
        }
        if (this.hasModifier(Modifier.SHIFT)) {
            display.append("Shift + ");
        }
        if (this.keyCode != -1) {
            display.append(this.keyCode >= 1000 ? this.getMouseButtonName(this.keyCode - 1000) : this.getKeyName(this.keyCode));
        } else {
            display.append("None");
        }
        return display.toString();
    }

    private String getKeyName(int keyCode) {
        return class_3675.method_15985((int)keyCode, (int)0).method_27445().getString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Shortcut that = (Shortcut)o;
        return this.keyCode == that.keyCode && Objects.equals(this.command, that.command) && Objects.equals(this.modifiers, that.modifiers);
    }

    public int hashCode() {
        return Objects.hash(this.command, this.keyCode, this.modifiers);
    }
}

