/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.features.waypoints;

import com.skyblock21.features.waypoints.Waypoint;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2338;

public class WaypointManager {
    private static final Map<UUID, Waypoint> waypoints = new ConcurrentHashMap<UUID, Waypoint>();
    public static final int DEFAULT_COLOR = 7050991;

    public static Waypoint addWaypoint(UUID uuid, String name, class_2338 pos) {
        Waypoint waypoint = new Waypoint(uuid, name, pos, false, 7050991);
        waypoints.put(waypoint.getUuid(), waypoint);
        return waypoint;
    }

    public static Waypoint addWaypoint(UUID uuid, String name, class_2338 pos, int color) {
        Waypoint waypoint = new Waypoint(uuid, name, pos, false, color);
        waypoints.put(waypoint.getUuid(), waypoint);
        return waypoint;
    }

    public static Waypoint addWaypoint(class_2338 pos, boolean beaconBeam) {
        Waypoint waypoint = new Waypoint("", pos, beaconBeam, 7050991);
        waypoints.put(waypoint.getUuid(), waypoint);
        return waypoint;
    }

    public static Waypoint addWaypoint(String name, class_2338 pos, boolean beaconBeam) {
        Waypoint waypoint = new Waypoint(name, pos, beaconBeam, 7050991);
        waypoints.put(waypoint.getUuid(), waypoint);
        return waypoint;
    }

    public static List<Waypoint> getVisibleWaypoints() {
        ArrayList<Waypoint> visibleWaypoints = new ArrayList<Waypoint>();
        for (Waypoint waypoint : waypoints.values()) {
            if (!waypoint.isVisible()) continue;
            visibleWaypoints.add(waypoint);
        }
        return visibleWaypoints;
    }

    public static Waypoint getWaypoint(UUID uuid) {
        return waypoints.get(uuid);
    }

    public static void updateWaypointPosition(UUID uuid, class_2338 newPos) {
        Waypoint waypoint = WaypointManager.getWaypoint(uuid);
        if (waypoint != null) {
            waypoint.setPosition(newPos);
        }
    }

    public static void removeWaypointsIfMatch(String name) {
        waypoints.values().removeIf(waypoint -> waypoint.getName().contains(name));
    }

    public static void removeWaypointsIfMatch(UUID uuid) {
        waypoints.values().removeIf(waypoint -> waypoint.getUuid().equals(uuid));
    }

    public static void removeAllWaypoints() {
        waypoints.clear();
    }
}

