/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.gui;

import com.skyblock21.gui.FontManager;
import com.skyblock21.util.ColorUtil;
import java.awt.Color;
import lombok.Generated;
import net.minecraft.class_310;
import net.minecraft.class_327;

public enum Theme {
    LIGHT(new Color(20, 83, 188, 255), new Color(91, 167, 248, 255), new Color(255, 255, 255, 255), new Color(213, 206, 208, 255), new Color(241, 245, 249, 255), new Color(29, 32, 38, 255), "roboto", 12.0f),
    DARK(new Color(91, 167, 248, 255), new Color(20, 83, 188, 255), new Color(29, 32, 38, 255), new Color(23, 25, 30, 255), new Color(100, 116, 139, 255), new Color(255, 255, 255, 255), "roboto", 12.0f),
    CANDY(new Color(255, 20, 147, 255), new Color(255, 105, 180, 255), new Color(255, 248, 220, 255), new Color(255, 228, 225, 255), new Color(255, 182, 193, 255), new Color(139, 69, 19, 255), "roboto", 12.0f);

    public final Color primary;
    public final Color secondary;
    public final Color background;
    private final Color secondaryBackground;
    private final Color border;
    public final Color text;
    private final String font;
    private final float rounding;
    private class_327 textRenderer;

    private Theme(Color primary, Color secondary, Color background, Color secondaryBackground, Color border, Color text, String themeFont, float rounding) {
        this.primary = primary;
        this.secondary = secondary;
        this.background = background;
        this.secondaryBackground = secondaryBackground;
        this.border = border;
        this.text = text;
        this.font = themeFont;
        this.textRenderer = FontManager.getFont(themeFont, 9);
        this.rounding = rounding;
    }

    public Color getPrimaryHover() {
        return ColorUtil.lighten(this.primary, 0.1f);
    }

    public Color getPrimaryActive() {
        return ColorUtil.darken(this.primary, 0.1f);
    }

    public Color getSecondaryHover() {
        return ColorUtil.lighten(this.secondary, 0.1f);
    }

    public Color getSecondaryActive() {
        return ColorUtil.darken(this.secondary, 0.1f);
    }

    public Color getButtonHover() {
        return ColorUtil.darken(this.secondaryBackground, 0.1f);
    }

    public Color getButtonActive() {
        return ColorUtil.lighten(this.secondaryBackground, 0.1f);
    }

    public Color getTextSecondary() {
        return ColorUtil.applyAlpha(this.text, 0.7f);
    }

    public Color getBorderHover() {
        return ColorUtil.lighten(this.getBorder(), 0.2f);
    }

    public class_327 getTextRenderer() {
        if (this.textRenderer == null || this.textRenderer == class_310.method_1551().field_1772) {
            this.textRenderer = FontManager.getFont(this.font, 9);
        }
        return this.textRenderer;
    }

    @Generated
    public Color getPrimary() {
        return this.primary;
    }

    @Generated
    public Color getSecondary() {
        return this.secondary;
    }

    @Generated
    public Color getBackground() {
        return this.background;
    }

    @Generated
    public Color getSecondaryBackground() {
        return this.secondaryBackground;
    }

    @Generated
    public Color getBorder() {
        return this.border;
    }

    @Generated
    public Color getText() {
        return this.text;
    }

    @Generated
    public String getFont() {
        return this.font;
    }

    @Generated
    public float getRounding() {
        return this.rounding;
    }
}

