/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.gui.components;

import com.skyblock21.gui.Theme;
import com.skyblock21.gui.ThemeManager;
import com.skyblock21.util.ColorUtil;
import com.skyblock21.util.Render2DUtil;
import com.skyblock21.util.TextUtils;
import io.wispforest.owo.ui.component.TextBoxComponent;
import io.wispforest.owo.ui.core.Sizing;
import java.util.Objects;
import java.util.function.BiFunction;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class TextBox
extends TextBoxComponent {
    private BiFunction<String, Integer, class_5481> colorPreviewProvider;
    private class_2561 label;
    private boolean previewColors = false;

    public TextBox(Sizing horizontalSizing, class_2561 label) {
        super(horizontalSizing);
        this.label = label;
        this.colorPreviewProvider = (text, startIndex) -> {
            String fullText = this.method_1882();
            String preservedFormatting = this.getActiveFormatting(fullText, (int)startIndex);
            String textWithFormatting = this.applyPreservedFormatting((String)text, preservedFormatting);
            String dualPreviewText = this.createDualPreviewText(textWithFormatting);
            class_5250 formattedText = TextUtils.fromLegacy(dualPreviewText);
            return formattedText.method_30937();
        };
    }

    private String createDualPreviewText(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        if (!this.previewColors) {
            return text;
        }
        StringBuilder result = new StringBuilder();
        String currentColor = null;
        for (int i = 0; i < text.length(); ++i) {
            char nextChar;
            char currentChar = text.charAt(i);
            if (currentChar == '&' && i + 1 < text.length() && TextUtils.FORMAT_CODES.contains(nextChar = Character.toLowerCase(text.charAt(i + 1)))) {
                result.append("\u00a77&").append(text.charAt(i + 1));
                if (this.isColorCode(nextChar)) {
                    currentColor = String.valueOf(nextChar);
                    result.append("\u00a7").append(nextChar);
                } else if (this.isFormattingCode(nextChar)) {
                    if (currentColor != null) {
                        result.append("\u00a7").append(currentColor);
                    }
                    result.append("\u00a7").append(nextChar);
                } else {
                    result.append("\u00a7").append(nextChar);
                    if (nextChar == 'r') {
                        currentColor = null;
                    }
                }
                ++i;
                continue;
            }
            result.append(currentChar);
        }
        return result.toString();
    }

    private boolean isColorCode(char code) {
        return "0123456789abcdef".indexOf(code) != -1;
    }

    private boolean isFormattingCode(char code) {
        return "klmno".indexOf(code) != -1;
    }

    private String getActiveFormatting(String text, int position) {
        Object activeColor = "";
        StringBuilder activeFormatting = new StringBuilder();
        for (int i = 0; i < position && i < text.length() - 1; ++i) {
            if (text.charAt(i) != '\u00a7' && text.charAt(i) != '&') continue;
            char code = Character.toLowerCase(text.charAt(i + 1));
            if (this.isColorCode(code)) {
                activeColor = "\u00a7" + code;
                activeFormatting.setLength(0);
            } else if (this.isFormattingCode(code)) {
                activeFormatting.append("\u00a7").append(code);
            } else if (code == 'r') {
                activeColor = "";
                activeFormatting.setLength(0);
            }
            ++i;
        }
        return (String)activeColor + activeFormatting.toString();
    }

    private String applyPreservedFormatting(String visibleText, String preservedFormatting) {
        if (preservedFormatting.isEmpty()) {
            return visibleText;
        }
        if (visibleText.length() >= 2 && (visibleText.charAt(0) == '\u00a7' || visibleText.charAt(0) == '&')) {
            return visibleText;
        }
        return preservedFormatting + visibleText;
    }

    public TextBox setPreviewColors(boolean previewColors) {
        this.previewColors = previewColors;
        return this;
    }

    private int getAvailableTextWidth() {
        Theme theme = ThemeManager.getCurrentTheme();
        int labelWidth = theme.getTextRenderer().method_27525((class_5348)this.label);
        int padding = 8;
        return this.width() - labelWidth - padding;
    }

    private void updateFirstCharacterIndex() {
        Theme theme = ThemeManager.getCurrentTheme();
        String fullText = this.method_1882();
        int availableWidth = this.getAvailableTextWidth();
        if (fullText.isEmpty()) {
            this.field_2103 = 0;
            return;
        }
        if (fullText.length() > this.method_1861()) {
            return;
        }
        if (theme.getTextRenderer().method_1727(fullText) <= availableWidth) {
            this.field_2103 = 0;
            return;
        }
        int cursorPos = this.field_2102;
        if (this.field_2103 <= cursorPos) {
            String currentView = fullText.substring(this.field_2103, Math.min(fullText.length(), cursorPos + 1));
            if (theme.getTextRenderer().method_1727(currentView) <= availableWidth) {
                return;
            }
        }
        int bestStartIndex = cursorPos;
        for (int startIdx = Math.max(0, cursorPos - 20); startIdx <= cursorPos; ++startIdx) {
            String testText = fullText.substring(startIdx, Math.min(fullText.length(), cursorPos + 1));
            if (theme.getTextRenderer().method_1727(testText) > availableWidth) continue;
            bestStartIndex = startIdx;
            break;
        }
        this.field_2103 = bestStartIndex;
    }

    public void method_48579(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        Theme theme = ThemeManager.getCurrentTheme();
        if (this.method_1885()) {
            this.updateFirstCharacterIndex();
            Render2DUtil.drawBox(context, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), theme.getSecondaryBackground());
            Render2DUtil.drawLine(context, this.method_46426(), this.method_46427() + this.method_25364(), this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364(), theme.primary);
            class_327 class_3272 = theme.getTextRenderer();
            int n = this.method_46426() + this.width() - theme.getTextRenderer().method_27525((class_5348)this.label) - 4;
            int n2 = this.method_46427();
            Objects.requireNonNull(theme.getTextRenderer());
            context.method_51439(class_3272, this.label, n, n2 + 9 / 2 + 2, ColorUtil.getIntFromColor(theme.primary), false);
            int j = this.field_2102 - this.field_2103;
            int availableWidth = this.getAvailableTextWidth();
            String workingText = this.method_1882();
            if (workingText.length() > this.method_1861() && this.field_2103 > (workingText = workingText.substring(0, this.method_1861())).length()) {
                this.field_2103 = Math.max(0, workingText.length() - 1);
            }
            String string = theme.getTextRenderer().method_27523(workingText.substring(this.field_2103), availableWidth);
            boolean bl = j >= 0 && j <= string.length();
            boolean bl2 = this.method_25370() && (class_156.method_658() - this.field_45352) / 300L % 2L == 0L && bl;
            int k = this.method_46426() + 4;
            int l = this.method_46427() + (this.field_22759 - 8) / 2;
            int m = k;
            int n3 = class_3532.method_15340((int)(this.field_2101 - this.field_2103), (int)0, (int)string.length());
            if (!string.isEmpty()) {
                String string2 = bl ? string.substring(0, j) : string;
                m = context.method_51430(theme.getTextRenderer(), this.colorPreviewProvider.apply(string2, this.field_2103), k, l, ColorUtil.getIntFromColor(theme.text), false);
            }
            boolean bl3 = this.field_2102 < this.method_1882().length() || this.method_1882().length() >= this.method_1861();
            int o = m;
            if (!bl) {
                o = j > 0 ? k + this.field_22758 : k;
            } else if (bl3) {
                o = m - 1;
                --m;
            }
            if (!string.isEmpty() && bl && j < string.length()) {
                int remainingTextStartIndex = this.field_2103 + j;
                context.method_51430(theme.getTextRenderer(), this.colorPreviewProvider.apply(string.substring(j), remainingTextStartIndex), m, l, ColorUtil.getIntFromColor(theme.text), false);
            }
            if (this.field_41100 != null && string.isEmpty() && !this.method_25370()) {
                context.method_51439(theme.getTextRenderer(), this.field_41100, m, l, ColorUtil.getIntFromColor(theme.getTextSecondary()), false);
            }
            if (bl2) {
                if (bl3) {
                    class_1921 var10001 = class_1921.method_51785();
                    int var10003 = l - 1;
                    int var10004 = o + 1;
                    int var10005 = l + 1;
                    context.method_51739(var10001, o, var10003, var10004, var10005 + 9, -3092272);
                } else {
                    context.method_25303(theme.getTextRenderer(), "_", o, l, ColorUtil.getIntFromColor(theme.secondary));
                }
            }
            if (n3 != j) {
                int p = k + theme.getTextRenderer().method_1727(string.substring(0, n3));
                int var19 = l - 1;
                int var20 = p - 1;
                int var21 = l + 1;
                this.method_1886(context, o, var19, var20, var21 + 9);
            }
        }
    }

    public boolean method_25400(char chr, int modifiers) {
        if (this.method_1882().length() >= this.method_1861() && this.field_2102 == this.field_2101) {
            return false;
        }
        boolean result = super.method_25400(chr, modifiers);
        if (result) {
            this.updateFirstCharacterIndex();
        }
        return result;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        boolean result = super.method_25404(keyCode, scanCode, modifiers);
        this.updateFirstCharacterIndex();
        return result;
    }
}

