/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.gui.screens;

import com.skyblock21.gui.Theme;
import com.skyblock21.gui.ThemeManager;
import com.skyblock21.gui.components.Button;
import com.skyblock21.gui.components.Label;
import com.skyblock21.gui.components.RoundedContainer;
import com.skyblock21.util.ColorUtil;
import com.skyblock21.util.TickSchedulerHelper;
import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Animatable;
import io.wispforest.owo.ui.core.Animation;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Easing;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.awt.Color;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;

public class ConfirmLinkScreen
extends BaseOwoScreen<FlowLayout> {
    private static Animation animation;
    private final Consumer<Boolean> callback;
    private final String url;
    private final boolean trusted;

    public ConfirmLinkScreen(Consumer<Boolean> callback, String url, boolean trusted) {
        this.callback = callback;
        this.url = url;
        this.trusted = trusted;
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::verticalFlow);
    }

    public void method_25426() {
        super.method_25426();
        if (animation != null) {
            animation.forwards();
        }
    }

    protected void build(FlowLayout rootComponent) {
        Theme theme = ThemeManager.getCurrentTheme();
        rootComponent.surface(Surface.blur((float)3.0f, (float)10.0f)).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER);
        FlowLayout mainContainer = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER);
        rootComponent.child((Component)mainContainer);
        RoundedContainer contentContainer = new RoundedContainer(Sizing.content(), Sizing.fixed((int)20), theme.getRounding(), theme.getBackground(), FlowLayout.Algorithm.VERTICAL);
        animation = contentContainer.verticalSizing().animate(500, Easing.CUBIC, (Animatable)Sizing.content());
        contentContainer.surface(Surface.VANILLA_TRANSLUCENT).padding(Insets.of((int)25)).horizontalAlignment(HorizontalAlignment.CENTER);
        contentContainer.gap(12);
        String titleText = this.trusted ? "Open Link?" : "Open Untrusted Link?";
        Label title = (Label)new Label((class_2561)class_2561.method_43470((String)titleText)).color(io.wispforest.owo.ui.core.Color.ofArgb((int)ColorUtil.getIntFromColor(theme.getSecondary()))).shadow(true);
        title.horizontalTextAlignment(HorizontalAlignment.CENTER);
        mainContainer.child((Component)title);
        mainContainer.gap(15);
        String warningText = this.trusted ? "This will open the following link in your default browser:" : "This will open an untrusted link in your default browser:";
        Label warningLabel = (Label)new Label((class_2561)class_2561.method_43470((String)warningText)).color(io.wispforest.owo.ui.core.Color.ofArgb((int)ColorUtil.getIntFromColor(theme.getTextSecondary()))).shadow(false);
        warningLabel.horizontalTextAlignment(HorizontalAlignment.CENTER);
        contentContainer.child((Component)warningLabel);
        String displayUrl = this.url.length() > 50 ? this.url.substring(0, 47) + "..." : this.url;
        Label urlLabel = (Label)new Label((class_2561)class_2561.method_43470((String)displayUrl)).color(io.wispforest.owo.ui.core.Color.ofArgb((int)ColorUtil.getIntFromColor(theme.getPrimary()))).shadow(false);
        urlLabel.horizontalTextAlignment(HorizontalAlignment.CENTER);
        contentContainer.child((Component)urlLabel);
        if (!this.trusted) {
            Label untrustedWarning = (Label)new Label((class_2561)class_2561.method_43470((String)"\u00a7c\u00a7lWarning: This link may not be safe!")).color(io.wispforest.owo.ui.core.Color.ofArgb((int)ColorUtil.getIntFromColor(Color.RED))).shadow(false);
            untrustedWarning.horizontalTextAlignment(HorizontalAlignment.CENTER);
            contentContainer.child((Component)untrustedWarning);
        }
        contentContainer.child(Components.spacer().sizing(Sizing.fixed((int)8)));
        FlowLayout buttonsContainer = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        buttonsContainer.gap(10);
        Button openButton = (Button)new Button((class_2561)class_2561.method_43470((String)(this.trusted ? "Open Link" : "Open Anyway")), this.trusted ? theme.getPrimary() : Color.ORANGE, theme.getBackground(), button -> this.confirmLink(true)).textShadow(false).horizontalSizing(Sizing.fixed((int)100));
        Button cancelButton = (Button)new Button((class_2561)class_2561.method_43470((String)"Cancel"), theme.getSecondaryBackground(), theme.text, button -> this.confirmLink(false)).textShadow(false).horizontalSizing(Sizing.fixed((int)100));
        Button copyButton = (Button)new Button((class_2561)class_2561.method_43470((String)"Copy URL"), theme.getSecondaryBackground(), theme.getTextSecondary(), button -> this.copyUrlToClipboard()).textShadow(false).horizontalSizing(Sizing.fixed((int)90));
        buttonsContainer.child((Component)openButton).child((Component)cancelButton).child((Component)copyButton);
        contentContainer.child((Component)buttonsContainer);
        mainContainer.child((Component)contentContainer);
    }

    private void confirmLink(boolean confirmed) {
        if (animation != null) {
            animation.backwards();
            TickSchedulerHelper.runAfter(() -> {
                if (this.callback != null) {
                    this.callback.accept(confirmed);
                }
            }, 10L);
        } else if (this.callback != null) {
            this.callback.accept(confirmed);
        }
    }

    private void copyUrlToClipboard() {
        if (this.field_22787 != null) {
            this.field_22787.field_1774.method_1455(this.url);
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.confirmLink(false);
            return true;
        }
        if (keyCode == 32) {
            this.confirmLink(true);
            return true;
        }
        if (keyCode == 257) {
            this.confirmLink(true);
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25419() {
        this.confirmLink(false);
    }

    public boolean method_25421() {
        return true;
    }
}

