/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.hud;

import com.skyblock21.gui.Theme;
import com.skyblock21.gui.ThemeManager;
import com.skyblock21.gui.components.Label;
import com.skyblock21.hud.EditHudElementScreen;
import com.skyblock21.hud.HudElement;
import com.skyblock21.hud.HudManager;
import com.skyblock21.hud.MultiLineHudElement;
import com.skyblock21.util.ColorUtil;
import com.skyblock21.util.Render2DUtil;
import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;

public class EditGuiScreen
extends BaseOwoScreen<FlowLayout> {
    private static final int GEAR_ICON_SIZE = 24;
    private static final class_2960 GEAR_ICON = class_2960.method_60655((String)"skyblock21", (String)"gui/gear.png");
    public static HudElement selectedElement = null;
    protected final class_437 parent;

    public EditGuiScreen(class_437 parent) {
        this.parent = parent;
        for (HudElement element : HudManager.getElements()) {
            if (!(element instanceof MultiLineHudElement)) continue;
            MultiLineHudElement multiLineHudElement = (MultiLineHudElement)element;
            multiLineHudElement.recalculateDimensions();
        }
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::verticalFlow);
    }

    protected void build(FlowLayout rootComponent) {
        Theme theme = ThemeManager.getCurrentTheme();
        rootComponent.surface(Surface.VANILLA_TRANSLUCENT).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER);
        FlowLayout instructionsContainer = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        instructionsContainer.gap(4).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER).margins(Insets.of((int)0, (int)(this.field_22790 / 2 + 50), (int)0, (int)0));
        instructionsContainer.child((Component)new Label((class_2561)class_2561.method_43470((String)"\u00a7bSkyBlock\u00a7f21\u00a7r HUD Editor")).shadow(true).color(io.wispforest.owo.ui.core.Color.ofArgb((int)ColorUtil.getIntFromColor(theme.getPrimary()))).horizontalTextAlignment(HorizontalAlignment.CENTER));
        instructionsContainer.child((Component)new Label((class_2561)class_2561.method_43470((String)"Left Click to Select Element")).color(io.wispforest.owo.ui.core.Color.WHITE).horizontalTextAlignment(HorizontalAlignment.CENTER)).child((Component)new Label((class_2561)class_2561.method_43470((String)"Right Click to Reset Position")).color(io.wispforest.owo.ui.core.Color.WHITE).horizontalTextAlignment(HorizontalAlignment.CENTER)).child((Component)new Label((class_2561)class_2561.method_43470((String)"Scroll or \"-\"/\"+\" to increase size")).color(io.wispforest.owo.ui.core.Color.WHITE).horizontalTextAlignment(HorizontalAlignment.CENTER)).child((Component)new Label((class_2561)class_2561.method_43470((String)"Move selected element with arrows")).color(io.wispforest.owo.ui.core.Color.WHITE).horizontalTextAlignment(HorizontalAlignment.CENTER));
        rootComponent.child((Component)instructionsContainer);
        rootComponent.surface(Surface.blur((float)3.0f, (float)10.0f));
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.renderHudElements(context, mouseX, mouseY);
    }

    private void renderHudElements(class_332 context, int mouseX, int mouseY) {
        class_4587 matrices = context.method_51448();
        float combinedScale = HudManager.getCombinedScale();
        class_327 textRenderer = ThemeManager.getCurrentTheme().getTextRenderer();
        for (HudElement element : HudManager.getElements()) {
            if (!element.isEnabled()) continue;
            matrices.method_22903();
            float effectiveX = element.getEffectiveX();
            float effectiveY = element.getEffectiveY();
            float effectiveScale = element.getEffectiveScale();
            matrices.method_46416(effectiveX, effectiveY, 0.0f);
            matrices.method_22905(effectiveScale, effectiveScale, 1.0f);
            element.render(context, mouseX, mouseY);
            matrices.method_22909();
            if (selectedElement == element) {
                this.renderSelectionIndicators(context, element, mouseX, mouseY, effectiveX, effectiveY, effectiveScale);
            }
            if (selectedElement != element || !element.isEnabled()) continue;
            String text = element.getName() + " (" + (int)(element.getScale() * 100.0f) + "%)";
            int n = (int)element.getEffectiveX();
            int n2 = (int)element.getEffectiveY();
            Objects.requireNonNull(textRenderer);
            context.method_25303(textRenderer, text, n, n2 - 9, ColorUtil.getIntFromColor(new Color(255, 255, 255, 150)));
        }
    }

    private void renderSelectionIndicators(class_332 context, HudElement element, int mouseX, int mouseY, float effectiveX, float effectiveY, float effectiveScale) {
        int scaledWidth = (int)((float)element.getWidth() * effectiveScale);
        int scaledHeight = (int)((float)element.getHeight() * effectiveScale);
        int gearIconSize = Math.min(24, (int)((float)scaledHeight * 0.4f));
        int gearX = (int)(effectiveX + (float)scaledWidth - (float)gearIconSize - 4.0f);
        int gearY = (int)(effectiveY + 4.0f);
        boolean isOverGearIcon = mouseX >= gearX && mouseX <= gearX + gearIconSize && mouseY >= gearY && mouseY <= gearY + gearIconSize;
        context.method_25291(class_1921::method_62277, GEAR_ICON, gearX, gearY, 0.0f, 0.0f, gearIconSize, gearIconSize, gearIconSize, gearIconSize, ColorUtil.getIntFromColor(new Color(255, 255, 255, isOverGearIcon ? 100 : 255)));
        Render2DUtil.drawRoundedBoxOutline(context, effectiveX, effectiveY, scaledWidth, scaledHeight, 2.0f, new Color(255, 255, 255, 150));
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (selectedElement != null) {
            selectedElement.dragTo(mouseX, mouseY);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        super.method_25402(mouseX, mouseY, button);
        for (HudElement element : HudManager.getElements()) {
            boolean isOverGearIcon;
            if (!element.isMouseOver(mouseX, mouseY) || !element.isEnabled()) continue;
            if (button == 1) {
                element.resetPosition();
                return true;
            }
            if (button != 0) continue;
            float effectiveX = element.getEffectiveX();
            float effectiveY = element.getEffectiveY();
            float effectiveScale = element.getEffectiveScale();
            int scaledWidth = (int)((float)element.getWidth() * effectiveScale);
            int scaledHeight = (int)((float)element.getHeight() * effectiveScale);
            int gearIconSize = Math.min(24, (int)((float)scaledHeight * 0.4f));
            int gearX = (int)(effectiveX + (float)scaledWidth - (float)gearIconSize - 4.0f);
            int gearY = (int)(effectiveY + 4.0f);
            boolean bl = isOverGearIcon = mouseX >= (double)gearX && mouseX <= (double)(gearX + gearIconSize) && mouseY >= (double)gearY && mouseY <= (double)(gearY + gearIconSize);
            if (isOverGearIcon && selectedElement == element) {
                this.field_22787.method_1507((class_437)new EditHudElementScreen((class_437)this, element));
                return true;
            }
            selectedElement = element;
            element.startDragging(mouseX, mouseY);
            return true;
        }
        selectedElement = null;
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (selectedElement != null) {
            selectedElement.stopDragging();
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount)) {
            return true;
        }
        for (HudElement element : HudManager.getElements()) {
            if (!element.isMouseOver(mouseX, mouseY) || !element.isEnabled()) continue;
            element.adjustScale((float)verticalAmount * 0.1f);
            return true;
        }
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (selectedElement == null) {
            return super.method_25404(keyCode, scanCode, modifiers);
        }
        boolean shift = EditGuiScreen.method_25442();
        int increment = shift ? 10 : 1;
        switch (keyCode) {
            case 265: {
                selectedElement.setY(selectedElement.getY() - increment);
                return true;
            }
            case 264: {
                selectedElement.setY(selectedElement.getY() + increment);
                return true;
            }
            case 263: {
                selectedElement.setX(selectedElement.getX() - increment);
                return true;
            }
            case 262: {
                selectedElement.setX(selectedElement.getX() + increment);
                return true;
            }
            case 61: 
            case 336: {
                selectedElement.adjustScale(shift ? 0.1f : 0.05f);
                return true;
            }
            case 45: 
            case 333: {
                selectedElement.adjustScale(shift ? -0.1f : -0.05f);
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25419() {
        HudManager.saveConfig();
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }
}

