/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.hud;

import com.skyblock21.gui.Theme;
import com.skyblock21.gui.ThemeManager;
import com.skyblock21.gui.components.Button;
import com.skyblock21.gui.components.Checkbox;
import com.skyblock21.gui.components.Label;
import com.skyblock21.gui.components.RoundedContainer;
import com.skyblock21.gui.components.Slider;
import com.skyblock21.hud.HudElement;
import com.skyblock21.hud.HudManager;
import com.skyblock21.util.ColorUtil;
import com.skyblock21.util.Render2DUtil;
import com.skyblock21.util.TickSchedulerHelper;
import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Animatable;
import io.wispforest.owo.ui.core.Animation;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Easing;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.awt.Color;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;

public class EditHudElementScreen
extends BaseOwoScreen<FlowLayout> {
    public static HudElement element = null;
    private final class_437 parent;
    Animation animation;
    private Slider scaleSlider;
    private Checkbox backgroundCheckbox;
    private Slider backgroundOpacitySlider;
    private boolean isDragging = false;
    private double dragOffsetX = 0.0;
    private double dragOffsetY = 0.0;
    private boolean rightLastTime = false;

    protected EditHudElementScreen(class_437 parent, HudElement _element) {
        this.parent = parent;
        element = _element;
        HudManager.saveConfig();
    }

    public void method_25426() {
        super.method_25426();
        this.animation.forwards();
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::verticalFlow);
    }

    protected void build(FlowLayout rootComponent) {
        boolean elementOnRight;
        Theme theme = ThemeManager.getCurrentTheme();
        rootComponent.surface(Surface.VANILLA_TRANSLUCENT).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER);
        this.rightLastTime = elementOnRight = element.getEffectiveX() > (float)(this.field_22789 / 2);
        RoundedContainer settingsContainer = new RoundedContainer(Sizing.fixed((int)240), Sizing.fixed((int)0), theme.getRounding(), theme.getBackground(), FlowLayout.Algorithm.VERTICAL);
        this.animation = settingsContainer.verticalSizing().animate(500, Easing.CUBIC, (Animatable)Sizing.content());
        settingsContainer.surface(Surface.VANILLA_TRANSLUCENT).padding(Insets.of((int)20));
        settingsContainer.gap(10);
        if (elementOnRight) {
            settingsContainer.positioning(Positioning.absolute((int)20, (int)(this.field_22790 / 2 - 150)));
        } else {
            settingsContainer.positioning(Positioning.absolute((int)(this.field_22789 - 260), (int)(this.field_22790 / 2 - 150)));
        }
        settingsContainer.child((Component)new Label((class_2561)class_2561.method_43470((String)(element.getName() + " Settings"))).color(io.wispforest.owo.ui.core.Color.ofArgb((int)ColorUtil.getIntFromColor(theme.primary))).horizontalTextAlignment(HorizontalAlignment.LEFT));
        settingsContainer.child((Component)new Label((class_2561)class_2561.method_43470((String)"Appearance:")).color(io.wispforest.owo.ui.core.Color.ofArgb((int)ColorUtil.getIntFromColor(theme.text))));
        this.backgroundCheckbox = new Checkbox((class_2561)class_2561.method_43470((String)"Background"), (checkbox, checked) -> element.setBackgroundEnabled((boolean)checked)).checked(element.isBackgroundEnabled());
        settingsContainer.child((Component)this.backgroundCheckbox);
        this.backgroundOpacitySlider = (Slider)new Slider(Sizing.fill((int)100), 0.0, 100.0).value(element.getBackgroundOpacity()).message(s -> class_2561.method_43470((String)("Background Opacity: " + element.getBackgroundOpacity() + "%")));
        this.backgroundOpacitySlider.onChanged().subscribe(value -> {
            element.setBackgroundOpacity((int)value);
            this.backgroundOpacitySlider.method_25355((class_2561)class_2561.method_43470((String)("Background Opacity: " + value + "%")));
        });
        settingsContainer.child((Component)this.backgroundOpacitySlider);
        double scaleValue = ((double)element.getScale() - 0.5) / 3.5 * 100.0;
        this.scaleSlider = (Slider)new Slider(Sizing.fill((int)100), 0.0, 100.0).value(scaleValue).message(s -> class_2561.method_43470((String)("Scale: " + s + "%")));
        this.scaleSlider.onChanged().subscribe(value -> {
            double scale = 0.5 + value / 100.0 * 3.5;
            element.setScale((float)scale);
            this.scaleSlider.method_25355((class_2561)class_2561.method_43470((String)("Scale: " + (int)value + "%")));
        });
        settingsContainer.child((Component)this.scaleSlider);
        Button resetButton = (Button)new Button((class_2561)class_2561.method_43470((String)"Reset to default"), theme.getSecondaryBackground(), theme.getPrimary(), button -> this.resetToDefaults()).textShadow(false).horizontalSizing(Sizing.fill((int)100));
        settingsContainer.child((Component)resetButton);
        FlowLayout buttonsContainer = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).horizontalAlignment(HorizontalAlignment.CENTER);
        buttonsContainer.gap(10);
        buttonsContainer.child(new Button((class_2561)class_2561.method_43470((String)"Done"), theme.getPrimary(), theme.getBackground(), button -> {
            HudManager.saveConfig();
            this.method_25419();
        }).horizontalSizing(Sizing.fill((int)47))).child(new Button((class_2561)class_2561.method_43470((String)"Cancel"), theme.getSecondaryBackground(), theme.getPrimary(), button -> {
            HudManager.loadConfig();
            this.method_25419();
        }).textShadow(false).horizontalSizing(Sizing.fill((int)47)));
        settingsContainer.child((Component)buttonsContainer);
        FlowLayout instructionsContainer = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        instructionsContainer.gap(4).horizontalAlignment(HorizontalAlignment.CENTER).positioning(Positioning.absolute((int)(this.field_22789 / 2 - 150), (int)(this.field_22790 - 80)));
        rootComponent.child((Component)settingsContainer);
        rootComponent.child((Component)instructionsContainer);
        rootComponent.surface(Surface.blur((float)3.0f, (float)10.0f));
        this.updateBackgroundOpacityState();
    }

    private void updateBackgroundOpacityState() {
        if (this.backgroundOpacitySlider != null) {
            // empty if block
        }
    }

    private void resetToDefaults() {
        boolean elementOnRight;
        element.resetDefaults();
        if (this.backgroundCheckbox != null) {
            this.backgroundCheckbox.checked(element.isBackgroundEnabled());
        }
        if (this.backgroundOpacitySlider != null) {
            this.backgroundOpacitySlider.value(element.getBackgroundOpacity());
            this.backgroundOpacitySlider.method_25355((class_2561)class_2561.method_43470((String)("Background Opacity: " + element.getBackgroundOpacity() + "%")));
        }
        if (this.scaleSlider != null) {
            double scaleValue = ((double)element.getScale() - 0.5) / 3.5 * 100.0;
            this.scaleSlider.value((int)scaleValue);
            this.scaleSlider.method_25355((class_2561)class_2561.method_43470((String)("Scale: " + (int)scaleValue + "%")));
        }
        this.updateBackgroundOpacityState();
        boolean bl = elementOnRight = element.getEffectiveX() > (float)(this.field_22789 / 2);
        if (elementOnRight != this.rightLastTime) {
            this.rightLastTime = elementOnRight;
            this.animation.backwards();
            TickSchedulerHelper.runAfter(() -> {
                ((FlowLayout)this.uiAdapter.rootComponent).clearChildren();
                this.build((FlowLayout)this.uiAdapter.rootComponent);
                this.animation.forwards();
            }, 5L);
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        float effectiveX = element.getEffectiveX();
        float effectiveY = element.getEffectiveY();
        float effectiveScale = element.getEffectiveScale();
        matrices.method_46416(effectiveX, effectiveY, 0.0f);
        matrices.method_22905(effectiveScale, effectiveScale, 1.0f);
        element.render(context, mouseX, mouseY);
        matrices.method_22909();
        int elementWidth = (int)((float)element.getWidth() * effectiveScale);
        int elementHeight = (int)((float)element.getHeight() * effectiveScale);
        Render2DUtil.drawRoundedBoxOutline(context, effectiveX - 1.0f, effectiveY - 1.0f, elementWidth + 2, elementHeight + 2, 2.0f, new Color(255, 255, 255, 150));
        super.method_25394(context, mouseX, mouseY, delta);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        super.method_25402(mouseX, mouseY, button);
        if (button == 1) {
            element.resetPosition();
            ((FlowLayout)this.uiAdapter.rootComponent).clearChildren();
            this.build((FlowLayout)this.uiAdapter.rootComponent);
            return true;
        }
        if (button == 0) {
            float effectiveX = element.getEffectiveX();
            float effectiveY = element.getEffectiveY();
            int elementWidth = (int)((float)element.getWidth() * element.getEffectiveScale());
            int elementHeight = (int)((float)element.getHeight() * element.getEffectiveScale());
            if (mouseX >= (double)effectiveX && mouseX <= (double)(effectiveX + (float)elementWidth) && mouseY >= (double)effectiveY && mouseY <= (double)(effectiveY + (float)elementHeight)) {
                this.isDragging = true;
                float combinedScale = HudManager.getCombinedScale();
                this.dragOffsetX = mouseX / (double)combinedScale - (double)element.getX();
                this.dragOffsetY = mouseY / (double)combinedScale - (double)element.getY();
                return true;
            }
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount)) {
            return true;
        }
        if (element.isMouseOver(mouseX, mouseY)) {
            element.adjustScale((float)verticalAmount * 0.1f);
            if (this.scaleSlider != null) {
                double scaleValue = ((double)element.getScale() - 0.5) / 3.5 * 100.0;
                this.scaleSlider.value((int)scaleValue);
                this.scaleSlider.method_25355((class_2561)class_2561.method_43470((String)("Scale: " + (int)(element.getScale() * 100.0f) + "%")));
            }
            return true;
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (super.method_25406(mouseX, mouseY, button)) {
            return true;
        }
        if (button == 0 && this.isDragging) {
            boolean elementOnRight;
            this.isDragging = false;
            boolean bl = elementOnRight = element.getEffectiveX() > (float)(this.field_22789 / 2);
            if (elementOnRight != this.rightLastTime) {
                this.rightLastTime = elementOnRight;
                this.animation.backwards();
                TickSchedulerHelper.runAfter(() -> {
                    ((FlowLayout)this.uiAdapter.rootComponent).clearChildren();
                    this.build((FlowLayout)this.uiAdapter.rootComponent);
                    this.animation.forwards();
                }, 5L);
            }
            return true;
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (super.method_25403(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (button == 0 && this.isDragging) {
            float combinedScale = HudManager.getCombinedScale();
            int newX = (int)(mouseX / (double)combinedScale - this.dragOffsetX);
            int newY = (int)(mouseY / (double)combinedScale - this.dragOffsetY);
            int maxX = (int)((float)this.field_22789 / combinedScale - (float)element.getWidth() * element.getScale());
            int maxY = (int)((float)this.field_22790 / combinedScale - (float)element.getHeight() * element.getScale());
            newX = Math.max(0, Math.min(newX, maxX));
            newY = Math.max(0, Math.min(newY, maxY));
            element.setX(newX);
            element.setY(newY);
            return true;
        }
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        boolean shift = EditHudElementScreen.method_25442();
        int increment = shift ? 10 : 1;
        switch (keyCode) {
            case 265: {
                element.setY(element.getY() - increment);
                return true;
            }
            case 264: {
                element.setY(element.getY() + increment);
                return true;
            }
            case 263: {
                element.setX(element.getX() - increment);
                return true;
            }
            case 262: {
                element.setX(element.getX() + increment);
                return true;
            }
            case 61: 
            case 336: {
                element.adjustScale(shift ? 0.1f : 0.05f);
                if (this.scaleSlider != null) {
                    double scaleValue = ((double)element.getScale() - 0.5) / 3.5 * 100.0;
                    this.scaleSlider.value((int)scaleValue);
                    this.scaleSlider.method_25355((class_2561)class_2561.method_43470((String)("Scale: " + (int)(element.getScale() * 100.0f) + "%")));
                }
                return true;
            }
            case 45: 
            case 333: {
                element.adjustScale(shift ? -0.1f : -0.05f);
                if (this.scaleSlider != null) {
                    double scaleValue = ((double)element.getScale() - 0.5) / 3.5 * 100.0;
                    this.scaleSlider.value((int)scaleValue);
                    this.scaleSlider.method_25355((class_2561)class_2561.method_43470((String)("Scale: " + (int)(element.getScale() * 100.0f) + "%")));
                }
                return true;
            }
            case 256: {
                this.method_25419();
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }
}

