/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.hud;

import com.skyblock21.hud.HudLine;
import com.skyblock21.hud.SortType;
import java.text.DecimalFormat;
import lombok.Generated;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class HudAmountLine
extends HudLine {
    private String itemName;
    private long amount;
    private int customValue;
    private static final DecimalFormat NUMBER_FORMAT = new DecimalFormat("#,###");

    public HudAmountLine(String id, String itemName, long amount) {
        super(id, (class_2561)class_2561.method_43470((String)(itemName + " \u00a7fx" + HudAmountLine.formatAmount(amount))));
        this.itemName = itemName;
        this.amount = amount;
        this.customValue = 0;
    }

    public HudAmountLine(String id, String itemName, long amount, String groupId) {
        super(id, (class_2561)class_2561.method_43470((String)(itemName + " \u00a7fx" + HudAmountLine.formatAmount(amount))), groupId);
        this.itemName = itemName;
        this.amount = amount;
        this.customValue = 0;
    }

    public HudAmountLine(String id, String itemName, long amount, String groupId, int order) {
        super(id, (class_2561)class_2561.method_43470((String)(itemName + " \u00a7fx" + HudAmountLine.formatAmount(amount))), groupId, order);
        this.itemName = itemName;
        this.amount = amount;
        this.customValue = 0;
    }

    public static HudAmountLine createDummy(String id, String itemName, long amount) {
        HudAmountLine line = new HudAmountLine(id, itemName, amount);
        line.setDummy(true);
        return line;
    }

    public static HudAmountLine createDummy(String id, String itemName, long amount, String groupId) {
        HudAmountLine line = new HudAmountLine(id, itemName, amount, groupId);
        line.setDummy(true);
        return line;
    }

    public static HudAmountLine createDummy(String id, String itemName, long amount, String groupId, int order) {
        HudAmountLine line = new HudAmountLine(id, itemName, amount, groupId, order);
        line.setDummy(true);
        return line;
    }

    public void updateAmount(long newAmount) {
        this.amount = newAmount;
        this.updateContent();
    }

    public void updateItemName(String newName) {
        this.itemName = newName;
        this.updateContent();
    }

    public void updateCustomValue(int value) {
        this.customValue = value;
    }

    private void updateContent() {
        this.setContent((class_2561)class_2561.method_43470((String)(this.itemName + " x" + HudAmountLine.formatAmount(this.amount))));
    }

    public static String formatAmount(long amount) {
        return NUMBER_FORMAT.format(amount);
    }

    @Override
    public int getSortValue() {
        return switch (this.getCurrentSortType()) {
            case SortType.AMOUNT -> (int)Math.min(this.amount, Integer.MAX_VALUE);
            case SortType.NAME_LENGTH -> this.itemName.length();
            case SortType.CUSTOM -> this.customValue;
            default -> this.getOrder();
        };
    }

    @Override
    public int getDisplayWidth() {
        return class_310.method_1551().field_1772.method_1727(this.itemName);
    }

    private SortType getCurrentSortType() {
        return SortType.ORDER;
    }

    @Generated
    public String getItemName() {
        return this.itemName;
    }

    @Generated
    public long getAmount() {
        return this.amount;
    }

    @Generated
    public int getCustomValue() {
        return this.customValue;
    }
}

