/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.hud;

import com.skyblock21.hud.EditGuiScreen;
import com.skyblock21.hud.EditHudElementScreen;
import com.skyblock21.hud.HudManager;
import com.skyblock21.util.Location;
import com.skyblock21.util.Render2DUtil;
import com.skyblock21.util.Utils;
import java.awt.Color;
import java.util.EnumSet;
import java.util.Set;
import lombok.Generated;
import net.minecraft.class_310;
import net.minecraft.class_332;

public abstract class HudElement {
    protected int HORIZONTAL_SPACING = 4;
    protected int VERTICAL_SPACING = 4;
    private final String name;
    public boolean alwaysRenderDummy = false;
    protected Set<Location> locationsShown = EnumSet.allOf(Location.class);
    private int x;
    private int y;
    private int defaultX = 0;
    private int defaultY = 0;
    private float scale = 1.0f;
    private boolean dragging = false;
    private int dragOffsetX = 0;
    private int dragOffsetY = 0;
    private boolean enabled = true;
    private boolean backgroundEnabled = false;
    private int backgroundOpacity = 40;

    public HudElement(int x, int y) {
        this.name = this.getClass().getSimpleName().replace("Element", "");
        this.x = x;
        this.y = y;
        this.defaultX = x;
        this.defaultY = y;
    }

    public HudElement(int x, int y, Location location) {
        this(x, y);
        this.locationsShown = EnumSet.of(location);
    }

    public HudElement(int x, int y, Location location, boolean alwaysDummy) {
        this(x, y);
        this.locationsShown = EnumSet.of(location);
        this.alwaysRenderDummy = alwaysDummy;
    }

    public void setX(int x) {
        class_310 client = class_310.method_1551();
        if (client == null || client.method_22683() == null) {
            this.x = x;
            return;
        }
        float combinedScale = HudManager.getCombinedScale();
        int maxX = (int)((float)client.method_22683().method_4480() / combinedScale - (float)this.getWidth() * this.scale - 1.0f);
        this.x = Math.max(1, Math.min(x, maxX));
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        class_310 client = class_310.method_1551();
        if (client == null || client.method_22683() == null) {
            this.y = y;
            return;
        }
        float combinedScale = HudManager.getCombinedScale();
        int maxY = (int)((float)client.method_22683().method_4507() / combinedScale - (float)this.getHeight() * this.scale - 1.0f);
        this.y = Math.max(1, Math.min(y, maxY));
    }

    public float getEffectiveX() {
        return (float)this.x * HudManager.getCombinedScale();
    }

    public float getEffectiveY() {
        return (float)this.y * HudManager.getCombinedScale();
    }

    public float getEffectiveScale() {
        return this.scale * HudManager.getCombinedScale();
    }

    public void setScale(float scale) {
        this.scale = scale;
        this.setX(this.x);
        this.setY(this.y);
    }

    public void setBackgroundOpacity(int opacity) {
        this.backgroundOpacity = Math.max(0, Math.min(opacity, 100));
    }

    public void render(class_332 context, int mouseX, int mouseY) {
        class_310 client = class_310.method_1551();
        if (client.field_1755 instanceof EditGuiScreen || client.field_1755 instanceof EditHudElementScreen) {
            this.renderBackground(context);
            this.renderElement(context);
        } else if (this.isAllowedInLocation(Utils.getLocation()) && this.isEnabled()) {
            this.renderBackground(context);
            this.renderElement(context);
        }
    }

    public void renderBackground(class_332 context) {
        if (this.isBackgroundEnabled() && this.isEnabled()) {
            Render2DUtil.drawRoundedBox(context, 0.0f, 0.0f, this.getWidth(), this.getHeight(), 2.0f, new Color(0, 0, 0, 255 * this.backgroundOpacity / 100));
        }
    }

    protected abstract void renderElement(class_332 var1);

    protected void renderDummy(class_332 context) {
    }

    protected void onTick(class_310 client) {
    }

    public void toggle() {
        this.enabled = !this.enabled;
    }

    public boolean isAllowedInLocation(Location location) {
        return this.locationsShown.contains((Object)location);
    }

    public void showInAllLocations() {
        this.locationsShown = EnumSet.allOf(Location.class);
    }

    public void showInLocation(Location location) {
        this.locationsShown = EnumSet.of(location);
    }

    public boolean shouldRenderDummy() {
        return this.alwaysRenderDummy || !this.isAllowedInLocation(Utils.getLocation()) || !this.isEnabled();
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        float effectiveX = this.getEffectiveX();
        float effectiveY = this.getEffectiveY();
        float effectiveScale = this.getEffectiveScale();
        int width = this.getWidth();
        int height = this.getHeight();
        return mouseX >= (double)effectiveX && mouseX <= (double)(effectiveX + (float)width * effectiveScale) && mouseY >= (double)effectiveY && mouseY <= (double)(effectiveY + (float)height * effectiveScale);
    }

    public void startDragging(double mouseX, double mouseY) {
        this.dragging = true;
        float combinedScale = HudManager.getCombinedScale();
        this.dragOffsetX = (int)(mouseX / (double)combinedScale - (double)this.x);
        this.dragOffsetY = (int)(mouseY / (double)combinedScale - (double)this.y);
    }

    public void stopDragging() {
        this.dragging = false;
    }

    public void dragTo(double mouseX, double mouseY) {
        if (this.dragging) {
            float combinedScale = HudManager.getCombinedScale();
            this.setX((int)(mouseX / (double)combinedScale - (double)this.dragOffsetX));
            this.setY((int)(mouseY / (double)combinedScale - (double)this.dragOffsetY));
        }
    }

    public void adjustScale(float delta) {
        this.scale += delta;
        this.scale = Math.max(0.5f, Math.min(4.0f, this.scale));
        this.setX(this.x);
        this.setY(this.y);
    }

    public void resetPosition() {
        this.setX(this.defaultX);
        this.setY(this.defaultY);
    }

    public void resetDefaults() {
        this.setBackgroundEnabled(false);
        this.setScale(1.0f);
        this.resetPosition();
    }

    public abstract int getWidth();

    public abstract int getHeight();

    public boolean shouldRender() {
        return true;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public int getX() {
        return this.x;
    }

    @Generated
    public float getScale() {
        return this.scale;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public boolean isBackgroundEnabled() {
        return this.backgroundEnabled;
    }

    @Generated
    public void setBackgroundEnabled(boolean backgroundEnabled) {
        this.backgroundEnabled = backgroundEnabled;
    }

    @Generated
    public int getBackgroundOpacity() {
        return this.backgroundOpacity;
    }
}

