/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.hud;

import com.google.gson.JsonObject;
import com.skyblock21.hud.HudAmountLine;
import com.skyblock21.hud.HudLine;
import com.skyblock21.hud.SortType;
import java.util.Comparator;
import java.util.List;

public class HudGroup {
    private final String id;
    private String displayName;
    private boolean enabled;
    private int order;
    private SortType sortType;
    private boolean ascending;
    private boolean alignAmounts;

    public HudGroup(String id, String displayName) {
        this.id = id;
        this.displayName = displayName;
        this.enabled = true;
        this.order = 0;
        this.sortType = SortType.ORDER;
        this.ascending = true;
        this.alignAmounts = false;
    }

    public HudGroup(String id, String displayName, int order) {
        this(id, displayName);
        this.order = order;
    }

    public HudGroup(String id, String displayName, int order, boolean alignAmounts) {
        this(id, displayName, order);
        this.alignAmounts = alignAmounts;
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public SortType getSortType() {
        return this.sortType;
    }

    public void setSortType(SortType sortType) {
        this.sortType = sortType;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }

    public boolean isAlignAmounts() {
        return this.alignAmounts;
    }

    public void setAlignAmounts(boolean alignAmounts) {
        this.alignAmounts = alignAmounts;
    }

    public Comparator<HudLine> getComparator() {
        Comparator<HudLine> comparator = switch (this.sortType) {
            default -> throw new MatchException(null, null);
            case SortType.ORDER -> Comparator.comparingInt(HudLine::getOrder);
            case SortType.NAME_LENGTH -> Comparator.comparingInt(line -> {
                if (line instanceof HudAmountLine) {
                    HudAmountLine amountLine = (HudAmountLine)line;
                    return amountLine.getItemName().length();
                }
                return line.getContent().getString().length();
            });
            case SortType.AMOUNT -> Comparator.comparingLong(line -> {
                if (line instanceof HudAmountLine) {
                    HudAmountLine amountLine = (HudAmountLine)line;
                    return amountLine.getAmount();
                }
                return 0L;
            });
            case SortType.CUSTOM -> Comparator.comparingInt(line -> {
                if (line instanceof HudAmountLine) {
                    HudAmountLine amountLine = (HudAmountLine)line;
                    return amountLine.getCustomValue();
                }
                return line.getSortValue();
            });
        };
        return this.ascending ? comparator : comparator.reversed();
    }

    public int getMaxItemNameWidth(List<HudLine> lines) {
        if (!this.alignAmounts) {
            return 0;
        }
        return lines.stream().filter(line -> line instanceof HudAmountLine).mapToInt(HudLine::getDisplayWidth).max().orElse(0);
    }

    public JsonObject saveToJson() {
        JsonObject obj = new JsonObject();
        obj.addProperty("id", this.id);
        obj.addProperty("enabled", Boolean.valueOf(this.enabled));
        obj.addProperty("order", (Number)this.order);
        obj.addProperty("sortType", this.sortType.name());
        obj.addProperty("ascending", Boolean.valueOf(this.ascending));
        obj.addProperty("alignAmounts", Boolean.valueOf(this.alignAmounts));
        return obj;
    }

    public void loadFromJson(JsonObject obj) {
        if (obj.has("enabled")) {
            this.enabled = obj.get("enabled").getAsBoolean();
        }
        if (obj.has("order")) {
            this.order = obj.get("order").getAsInt();
        }
        if (obj.has("sortType")) {
            try {
                this.sortType = SortType.valueOf(obj.get("sortType").getAsString());
            }
            catch (IllegalArgumentException e) {
                this.sortType = SortType.ORDER;
            }
        }
        if (obj.has("ascending")) {
            this.ascending = obj.get("ascending").getAsBoolean();
        }
        if (obj.has("alignAmounts")) {
            this.alignAmounts = obj.get("alignAmounts").getAsBoolean();
        }
    }
}

