/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.hud;

import lombok.Generated;
import net.minecraft.class_2561;

public class HudLine {
    private final String id;
    private class_2561 content;
    private String groupId;
    private int order = 0;
    private boolean enabled = true;
    private boolean isDummy = false;
    private boolean clickable = false;
    private boolean hoverable = false;
    private Runnable clickAction;
    private class_2561 hoverText;
    private class_2561[] multilineHoverText;
    private ConditionalVisibilityProvider visibilityProvider;

    public HudLine(String id, class_2561 content) {
        this.id = id;
        this.content = content;
    }

    public HudLine(String id, class_2561 content, String groupId) {
        this.id = id;
        this.content = content;
        this.groupId = groupId;
    }

    public HudLine(String id, class_2561 content, String groupId, int order) {
        this.id = id;
        this.content = content;
        this.groupId = groupId;
        this.order = order;
    }

    public boolean hasGroup() {
        return this.groupId != null && !this.groupId.isEmpty();
    }

    public void setClickAction(Runnable action) {
        this.clickAction = action;
        this.clickable = action != null;
    }

    public void setHoverText(class_2561 hoverText) {
        this.hoverText = hoverText;
        this.hoverable = hoverText != null;
    }

    public void setMultilineHoverText(String ... lines) {
        if (lines.length == 0) {
            this.hoverText = null;
            this.hoverable = false;
            return;
        }
        StringBuilder combined = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            combined.append(lines[i]);
            if (i >= lines.length - 1) continue;
            combined.append("\n");
        }
        this.setHoverText((class_2561)class_2561.method_43470((String)combined.toString()));
    }

    public void onClick() {
        if (this.clickable && this.clickAction != null) {
            this.clickAction.run();
        }
    }

    public boolean shouldShow() {
        return this.enabled && (this.visibilityProvider == null || this.visibilityProvider.shouldShow());
    }

    public boolean isSpacer() {
        return false;
    }

    public int getSortValue() {
        return this.order;
    }

    public int getDisplayWidth() {
        return this.content != null ? this.content.getString().length() : 0;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public class_2561 getContent() {
        return this.content;
    }

    @Generated
    public void setContent(class_2561 content) {
        this.content = content;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public boolean isDummy() {
        return this.isDummy;
    }

    @Generated
    public void setDummy(boolean isDummy) {
        this.isDummy = isDummy;
    }

    @Generated
    public boolean isClickable() {
        return this.clickable;
    }

    @Generated
    public boolean isHoverable() {
        return this.hoverable;
    }

    @Generated
    public class_2561 getHoverText() {
        return this.hoverText;
    }

    @Generated
    public ConditionalVisibilityProvider getVisibilityProvider() {
        return this.visibilityProvider;
    }

    @Generated
    public void setVisibilityProvider(ConditionalVisibilityProvider visibilityProvider) {
        this.visibilityProvider = visibilityProvider;
    }

    @FunctionalInterface
    public static interface ConditionalVisibilityProvider {
        public boolean shouldShow();
    }
}

