/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.hud.elements;

import com.skyblock21.config.Skyblock21ConfigManager;
import com.skyblock21.hud.SortType;
import com.skyblock21.tracking.TrackableValue;
import com.skyblock21.tracking.TrackerHudElement;
import com.skyblock21.tracking.impl.BonusGiftsTracker;
import com.skyblock21.util.Location;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2561;

public class BonusGiftsTrackerElement
extends TrackerHudElement {
    public static BonusGiftsTrackerElement INSTANCE;
    private Set<String> trackedGifts = new HashSet<String>();

    public BonusGiftsTrackerElement(int x, int y) {
        super(x, y, Location.GALATEA, new BonusGiftsTracker());
        if (INSTANCE == null) {
            INSTANCE = this;
        }
    }

    @Override
    protected void setupHud() {
        this.setTitle("\u00a7d\u00a7lBonus Gifts", 0xFF55FF, 1.2f, true);
        this.createGroup("gifts", "Bonus Gifts", 0, true);
        this.setGroupSorting("gifts", SortType.AMOUNT, false);
        this.createGroup("stats", "Stats", 2, false);
        this.addLine("active_time", (class_2561)class_2561.method_43470((String)"\u00a7dActive Time: \u00a7f0s"), "stats");
        this.addModeDisplayLine();
        this.addConditionalLine("status", (class_2561)class_2561.method_43470((String)"\u00a77(Paused)"), () -> this.tracker.isPaused() || this.tracker.isAfk());
        this.setupDummyData();
        this.addDisplayModeToggle();
        this.addResetButtons();
    }

    protected void setupDummyData() {
        this.addDummyAmountLine("dummy_first_impression", "\u00a7dFirst Impression I", 3L, "gifts");
        this.addDummyAmountLine("dummy_stretching_sticks", "\u00a7aStretching Sticks", 6L, "gifts");
        this.addDummyAmountLine("dummy_chameleon", "\u00a76Chameleon", 1L, "gifts");
        this.recalculateDimensions();
    }

    @Override
    protected void updateHudLines() {
        this.updateLine("active_time", this.createActiveTimeLine());
        this.updateLine("status", this.createStatusLine());
        if (this.tracker.getSettings().persistData) {
            this.updateLine("display_mode", this.createDisplayModeLine());
        }
        this.updateRealGiftLines();
    }

    private void updateRealGiftLines() {
        Map<String, TrackableValue<?>> allValues = this.tracker.getAllValues();
        this.lines.removeIf(line -> line.getGroupId() != null && line.getGroupId().equals("gifts") && line.getId().startsWith("real_gift_") && !allValues.containsKey(line.getId().replace("real_gift_", "")));
        for (Map.Entry<String, TrackableValue<?>> entry : allValues.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith("gift_")) continue;
            String shardName = key.substring(5);
            String lineId = "real_gift_" + key;
            int shardValue = entry.getValue().asInt();
            if (this.getLine(lineId) == null) {
                this.addAmountLine(lineId, shardName, shardValue, "gifts");
                continue;
            }
            this.updateAmountLine(lineId, shardName, shardValue);
        }
        this.recalculateDimensions();
    }

    @Override
    public boolean shouldRenderDummy() {
        return super.shouldRenderDummy();
    }

    @Override
    public boolean isEnabled() {
        return Skyblock21ConfigManager.get().foraging.bonusGiftsTracker;
    }
}

