/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.hud.elements;

import com.skyblock21.config.Skyblock21ConfigManager;
import com.skyblock21.tracking.TrackableValue;
import com.skyblock21.tracking.TrackerHudElement;
import com.skyblock21.tracking.impl.GalateaTracker;
import com.skyblock21.util.Location;
import net.minecraft.class_2561;

public class GalateaTrackerElement
extends TrackerHudElement {
    public GalateaTrackerElement(int x, int y) {
        super(x, y, Location.GALATEA, new GalateaTracker());
    }

    @Override
    protected void setupHud() {
        this.setTitle("\u00a72\u00a7lGalatea Tracker", 0x55FF55, 1.2f, true);
        this.createGroup("stats", "Stats", 0, false);
        this.addLine("forest_essence", (class_2561)class_2561.method_43470((String)"\u00a78Forest Essence: \u00a7f0 \u00a78(0/hr)"), "stats");
        this.addLine("foraging_exp", (class_2561)class_2561.method_43470((String)"\u00a73Foraging Exp: \u00a7f0 \u00a78(0/hr)"), "stats");
        this.addLine("hotf_exp", (class_2561)class_2561.method_43470((String)"\u00a7aHOTF Exp: \u00a7f0 \u00a78(0/hr)"), "stats");
        this.addLine("whispers", (class_2561)class_2561.method_43470((String)"\u00a72Whispers: \u00a7f0 \u00a78(0/hr)"), "stats");
        this.addLine("active_time", (class_2561)class_2561.method_43470((String)"\u00a7dActive Time: \u00a7f0s"), "stats");
        this.addModeDisplayLine();
        this.addConditionalLine("status", (class_2561)class_2561.method_43470((String)"\u00a77(Paused)"), () -> this.tracker.isPaused() || this.tracker.isAfk());
        this.setupDummyData();
        this.addDisplayModeToggle();
        this.addResetButtons();
    }

    protected void setupDummyData() {
        TrackableValue<Integer> dummyForestEssence = this.createDummyValue(900, 1.25);
        TrackableValue<Integer> dummyForagingExp = this.createDummyValue(25000, 1.25);
        TrackableValue<Integer> dummyHOTFExp = this.createDummyValue(2500, 1.25);
        TrackableValue<Integer> dummyWhispers = this.createDummyValue(500, 1.25);
        this.addDummyLine("dummy_forest_essence", this.createForestEssenceLine(dummyForestEssence), "stats");
        this.addDummyLine("dummy_foraging_exp", this.createValueLine("Foraging Exp", "\u00a73", dummyForagingExp), "stats");
        this.addDummyLine("dummy_hotf_exp", this.createValueLine("HOTF Exp", "\u00a7a", dummyHOTFExp), "stats");
        this.addDummyLine("dummy_whispers", this.createValueLine("Whispers", "\u00a72", dummyWhispers), "stats");
        this.addDummyLine("dummy_active_time", (class_2561)class_2561.method_43470((String)"\u00a7dActive Time: \u00a7f1h 23m 45s"), "stats");
        this.addDummyLine("dummy_status", (class_2561)class_2561.method_43470((String)"\u00a7c(AFK)"), "stats");
        if (this.tracker.getSettings().persistData) {
            this.addDummyLine("dummy_display_mode", (class_2561)class_2561.method_43470((String)"\u00a77Mode: \u00a7eCurrent Session"), "stats");
        }
        this.recalculateDimensions();
    }

    @Override
    protected void updateHudLines() {
        TrackableValue<Integer> forestEssence = this.tracker.getValue("forest_essence");
        TrackableValue foragingExp = this.tracker.getValue("foraging_exp");
        TrackableValue hotfExp = this.tracker.getValue("hotf_exp");
        TrackableValue whispers = this.tracker.getValue("whispers");
        this.updateLine("forest_essence", this.createForestEssenceLine(forestEssence));
        this.updateLine("foraging_exp", this.createValueLine("Foraging Exp", "\u00a73", foragingExp));
        this.updateLine("hotf_exp", this.createValueLine("HOTF Exp", "\u00a7a", hotfExp));
        this.updateLine("whispers", this.createValueLine("Whispers", "\u00a72", whispers));
        this.updateLine("active_time", this.createActiveTimeLine());
        this.updateLine("status", this.createStatusLine());
        if (this.tracker.getSettings().persistData) {
            this.updateLine("display_mode", this.createDisplayModeLine());
        }
    }

    private class_2561 createForestEssenceLine(TrackableValue<Integer> value) {
        if (value == null) {
            return class_2561.method_43470((String)"\u00a78Forest Essence: \u00a7f0");
        }
        return this.createValueLine("Forest Essence", "\u00a78", value);
    }

    @Override
    public boolean isEnabled() {
        return Skyblock21ConfigManager.get().foraging.galateaTracker;
    }
}

