/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.hud.elements;

import com.skyblock21.config.Skyblock21ConfigManager;
import com.skyblock21.hud.SortType;
import com.skyblock21.tracking.TrackableValue;
import com.skyblock21.tracking.TrackerHudElement;
import com.skyblock21.tracking.impl.HuntingTracker;
import java.util.Map;
import net.minecraft.class_2561;

public class HuntingTrackerElement
extends TrackerHudElement {
    public HuntingTrackerElement(int x, int y) {
        super(x, y, new HuntingTracker());
    }

    @Override
    protected void setupHud() {
        this.setTitle("\u00a79\u00a7lHunting", 0xFFFFFF, 1.2f, true);
        this.createGroup("stats", "Stats", 3, false);
        this.addLine("hunting_exp", (class_2561)class_2561.method_43470((String)"\u00a79Hunting XP: \u00a7f0 \u00a78(0/hr)"), "stats");
        this.addLine("active_time", (class_2561)class_2561.method_43470((String)"\u00a7dActive Time: \u00a7f0s"), "stats");
        this.addModeDisplayLine();
        this.addConditionalLine("status", (class_2561)class_2561.method_43470((String)"\u00a77(Paused)"), () -> this.tracker.isPaused() || this.tracker.isAfk());
        this.addSpacer("shard_spacer", 1);
        this.createGroup("shards", "Shards", 2, true);
        this.setGroupSorting("shards", SortType.AMOUNT, false);
        this.addDummyAmountLine("dummy_salt", "\u00a7dSalt", 5L, "shards");
        this.addDummyAmountLine("dummy_charm", "\u00a75Charm", 3L, "shards");
        this.addDummyAmountLine("dummy_naga", "\u00a76Naga", 1L, "shards");
        this.addDummyAmountLine("dummy_naga", "\u00a79Glacite Walker", 3L, "shards");
        this.addDummySpacer("dummy_spacer", 1);
        this.addDummyLine("dummy_hunting_exp", (class_2561)class_2561.method_43470((String)"\u00a79Hunting XP: \u00a7f0 \u00a78(0/hr)"), "stats");
        this.addDummyLine("dummy_active_time", (class_2561)class_2561.method_43470((String)"\u00a7dActive Time: \u00a7f0s"), "stats");
        this.addDisplayModeToggle();
        this.addResetButtons();
        this.recalculateDimensions();
    }

    @Override
    protected void updateHudLines() {
        TrackableValue huntingExp = this.tracker.getValue("hunting_exp");
        this.updateLine("hunting_exp", this.createValueLine("Hunting XP", "\u00a79", huntingExp));
        this.updateLine("active_time", this.createActiveTimeLine());
        this.updateLine("status", this.createStatusLine());
        if (this.tracker.getSettings().persistData) {
            this.updateLine("display_mode", this.createDisplayModeLine());
        }
        this.updateRealShardLines();
    }

    private void updateRealShardLines() {
        Map<String, TrackableValue<?>> allValues = this.tracker.getAllValues();
        this.lines.removeIf(line -> line.getGroupId() != null && line.getGroupId().equals("shards") && line.getId().startsWith("real_shard_") && !allValues.containsKey(line.getId().replace("real_shard_", "")));
        for (Map.Entry<String, TrackableValue<?>> entry : allValues.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith("shard_")) continue;
            String shardName = key.substring(6);
            String lineId = "real_shard_" + key;
            int shardValue = entry.getValue().asInt();
            if (this.getLine(lineId) == null) {
                this.addAmountLine(lineId, "\u00a7f" + shardName, shardValue, "shards");
                continue;
            }
            this.updateAmountLine(lineId, "\u00a7f" + shardName, shardValue);
        }
        this.recalculateDimensions();
    }

    @Override
    public boolean isEnabled() {
        return Skyblock21ConfigManager.get().hunting.huntingTracker;
    }
}

