/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.mixin;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import com.skyblock21.config.persistent.PersistentData;
import com.skyblock21.features.commandaliases.Alias;
import java.util.Collection;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CommandDispatcher.class})
public class CommandDispatcherMixin<S> {
    @Shadow(remap=false)
    @Final
    private RootCommandNode<S> root;

    @Inject(method={"getCompletionSuggestions*"}, at={@At(value="RETURN")}, remap=false)
    private void sb21$refreshAliases(CallbackInfoReturnable<?> cir) {
        this.refreshAllAliases();
    }

    @Unique
    private void registerAliasCommand(String aliasName, LiteralCommandNode<S> originalCommand) {
        CommandNode existingAlias = this.root.getChild(aliasName);
        if (existingAlias != null) {
            return;
        }
        LiteralArgumentBuilder aliasBuilder = LiteralArgumentBuilder.literal((String)aliasName);
        if (originalCommand.getCommand() != null) {
            aliasBuilder.executes(originalCommand.getCommand());
        }
        aliasBuilder.redirect(originalCommand);
        LiteralCommandNode aliasCommand = aliasBuilder.build();
        this.root.addChild((CommandNode)aliasCommand);
    }

    @Unique
    public void refreshAllAliases() {
        Collection children = this.root.getChildren();
        children.removeIf(node -> {
            if (node instanceof LiteralCommandNode) {
                LiteralCommandNode literalNode = (LiteralCommandNode)node;
                String nodeName = literalNode.getLiteral();
                return PersistentData.get().aliases.stream().anyMatch(alias -> alias.aliasCommand.equals(nodeName) && !alias.enabled);
            }
            return false;
        });
        for (Alias alias : PersistentData.get().aliases) {
            CommandNode targetCommand;
            if (!alias.enabled || !((targetCommand = this.root.getChild(alias.targetCommand)) instanceof LiteralCommandNode)) continue;
            LiteralCommandNode literalTarget = (LiteralCommandNode)targetCommand;
            CommandNode existingAlias = this.root.getChild(alias.aliasCommand);
            if (existingAlias != null) continue;
            this.registerAliasCommand(alias.aliasCommand, literalTarget);
        }
    }
}

