/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.tracking;

import com.skyblock21.config.persistent.PersistentData;
import com.skyblock21.tracking.TrackableValue;
import com.skyblock21.tracking.TrackerConditions;
import com.skyblock21.tracking.TrackerData;
import com.skyblock21.tracking.TrackerDisplayMode;
import com.skyblock21.tracking.TrackerManager;
import com.skyblock21.tracking.TrackerSettings;
import com.skyblock21.util.Location;
import com.skyblock21.util.Utils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import net.minecraft.class_243;
import net.minecraft.class_310;

public abstract class BaseTracker {
    protected final Map<String, TrackableValue<?>> trackedValues = new ConcurrentHashMap();
    protected final TrackerConditions conditions;
    protected final TrackerSettings settings;
    protected final String trackerId;
    protected TrackerDisplayMode displayMode = TrackerDisplayMode.CURRENT_SESSION;
    protected long sessionStartTime = -1L;
    protected long lastActionTime = -1L;
    protected long totalActiveTime = 0L;
    protected long lastTotalActiveTime = 0L;
    protected long lastActiveTime = -1L;
    protected boolean isPaused = true;
    protected boolean isAfk = false;
    protected class_243 lastPlayerPos = null;
    protected float lastPlayerYaw = 0.0f;
    protected float lastPlayerPitch = 0.0f;
    protected long lastMovementTime = -1L;
    protected Location lastLocation = Location.UNKNOWN;

    public BaseTracker(String trackerId, TrackerConditions conditions, TrackerSettings settings) {
        this.trackerId = trackerId;
        this.conditions = conditions;
        this.settings = settings;
        TrackerManager.register(this);
        if (settings.persistData) {
            this.loadPersistentData();
        }
        this.lastTotalActiveTime = this.getTotalActiveTime();
    }

    public final void tick(class_310 client) {
        if (!this.conditions.shouldTrack(this)) {
            if (!this.isPaused) {
                this.pauseTracker();
            }
            return;
        }
        Location currentLocation = Utils.getLocation();
        if (!currentLocation.equals((Object)this.lastLocation)) {
            this.onLocationChange(this.lastLocation, currentLocation);
            this.lastLocation = currentLocation;
        }
        this.updateAFKStatus(client);
        this.onTick(client);
    }

    public <T extends Number> void trackValue(String key, T increment) {
        if (!this.conditions.shouldTrack(this)) {
            return;
        }
        TrackableValue<T> value = this.getOrCreateValue(key, increment);
        value.add(increment);
        if (this.settings.persistData) {
            this.updatePersistentValue(key, increment);
        }
        if (this.sessionStartTime == -1L) {
            this.startSession();
        }
        this.lastActionTime = System.currentTimeMillis();
        if (this.isAfk) {
            this.exitAfk();
        }
        if (this.isPaused) {
            this.resumeTracker();
        }
        this.updateRates();
        this.onValueTracked(key, increment, value);
    }

    public <T extends Number> TrackableValue<T> getValue(String key) {
        if (this.displayMode == TrackerDisplayMode.ALL_TIME && this.settings.persistData) {
            return this.getPersistentValue(key);
        }
        return this.trackedValues.get(key);
    }

    public <T extends Number> TrackableValue<T> getSessionValue(String key) {
        return this.trackedValues.get(key);
    }

    public <T extends Number> TrackableValue<T> getPersistentValue(String key) {
        if (!this.settings.persistData) {
            return null;
        }
        TrackerData persistentData = PersistentData.get().getTrackerData(this.trackerId);
        if (persistentData == null) {
            return null;
        }
        return persistentData.values.get(key);
    }

    public Map<String, TrackableValue<?>> getAllValues() {
        if (this.displayMode == TrackerDisplayMode.ALL_TIME && this.settings.persistData) {
            TrackerData persistentData = PersistentData.get().getTrackerData(this.trackerId);
            return persistentData != null ? new HashMap(persistentData.values) : new HashMap();
        }
        return new HashMap(this.trackedValues);
    }

    public void toggleDisplayMode() {
        this.displayMode = this.displayMode.toggle();
        this.updateRates();
    }

    public void resetSession() {
        long currentSessionActiveTime;
        if (this.settings.persistData && this.sessionStartTime != -1L && (currentSessionActiveTime = this.getCurrentActiveTime()) > 0L) {
            TrackerData persistentData = PersistentData.get().getOrCreateTrackerData(this.trackerId);
            persistentData.addTotalActiveTime(this.getTotalActiveTime() - this.lastTotalActiveTime);
            PersistentData.save();
            this.lastTotalActiveTime = this.getTotalActiveTime();
        }
        this.trackedValues.clear();
        this.sessionStartTime = -1L;
        this.lastActionTime = -1L;
        this.totalActiveTime = 0L;
        this.lastActiveTime = -1L;
        this.isPaused = true;
        this.isAfk = false;
        this.lastMovementTime = -1L;
        this.onSessionReset();
    }

    public void resetAll() {
        this.resetSession();
        if (this.settings.persistData) {
            PersistentData.get().clearTrackerData(this.trackerId);
            PersistentData.save();
            this.lastTotalActiveTime = 0L;
        }
        this.onAllDataReset();
    }

    public long getCurrentActiveTime() {
        if (this.sessionStartTime == -1L) {
            return 0L;
        }
        long currentActive = this.totalActiveTime;
        if (!this.isPaused) {
            currentActive += System.currentTimeMillis() - this.lastActiveTime;
        }
        return currentActive;
    }

    public long getTotalActiveTime() {
        TrackerData persistentData;
        long currentActive = this.getCurrentActiveTime();
        if (this.settings.persistData && (persistentData = PersistentData.get().getTrackerData(this.trackerId)) != null) {
            currentActive += persistentData.totalActiveTime;
        }
        return currentActive;
    }

    public long getSessionDuration() {
        if (this.sessionStartTime == -1L) {
            return 0L;
        }
        return System.currentTimeMillis() - this.sessionStartTime;
    }

    protected <T extends Number> TrackableValue<T> getOrCreateValue(String key, T sample) {
        return this.trackedValues.computeIfAbsent(key, k -> new TrackableValue<Number>(sample));
    }

    protected <T extends Number> void updatePersistentValue(String key, T increment) {
        TrackerData persistentData = PersistentData.get().getOrCreateTrackerData(this.trackerId);
        TrackableValue persistentValue = persistentData.values.computeIfAbsent(key, k -> new TrackableValue<Number>(increment));
        persistentValue.add(increment);
        PersistentData.save();
    }

    protected void loadPersistentData() {
        double hoursActive;
        TrackerData persistentData = PersistentData.get().getTrackerData(this.trackerId);
        if (persistentData != null && (hoursActive = (double)persistentData.totalActiveTime / 3600000.0) > 0.0) {
            for (TrackableValue<?> value : persistentData.values.values()) {
                value.updateRate(hoursActive);
            }
        }
    }

    protected void startSession() {
        long currentTime;
        this.sessionStartTime = currentTime = System.currentTimeMillis();
        this.lastActiveTime = currentTime;
        this.lastMovementTime = currentTime;
        this.totalActiveTime = 0L;
        this.isPaused = false;
        this.isAfk = false;
    }

    public void pauseTracker() {
        if (!this.isPaused && this.sessionStartTime != -1L) {
            this.totalActiveTime += System.currentTimeMillis() - this.lastActiveTime;
            this.isPaused = true;
        }
    }

    public void resumeTracker() {
        if (this.isPaused && this.conditions.shouldTrack(this)) {
            this.lastActiveTime = System.currentTimeMillis();
            this.isPaused = false;
        }
    }

    protected void updateAFKStatus(class_310 client) {
        boolean hasMovedLook;
        if (client.field_1724 == null) {
            return;
        }
        class_243 currentPos = client.field_1724.method_19538();
        float currentYaw = client.field_1724.method_36454();
        float currentPitch = client.field_1724.method_36455();
        boolean hasMovedPosition = this.lastPlayerPos == null || !currentPos.equals((Object)this.lastPlayerPos);
        boolean bl = hasMovedLook = Math.abs(currentYaw - this.lastPlayerYaw) > this.settings.lookSensitivity || Math.abs(currentPitch - this.lastPlayerPitch) > this.settings.lookSensitivity;
        if (hasMovedPosition || hasMovedLook) {
            if (this.isAfk) {
                this.exitAfk();
            }
            this.lastMovementTime = System.currentTimeMillis();
            this.lastPlayerPos = currentPos;
            this.lastPlayerYaw = currentYaw;
            this.lastPlayerPitch = currentPitch;
        } else {
            long timeSinceMovement = System.currentTimeMillis() - this.lastMovementTime;
            if (timeSinceMovement >= this.settings.afkThreshold && !this.isAfk) {
                this.enterAfk();
            }
        }
    }

    protected void enterAfk() {
        this.isAfk = true;
        this.pauseTracker();
        this.onAfkEnter();
    }

    protected void exitAfk() {
        this.isAfk = false;
        this.resumeTracker();
        this.onAfkExit();
    }

    protected void updateRates() {
        Map<String, TrackableValue<?>> values;
        long activeTime;
        if (this.displayMode == TrackerDisplayMode.ALL_TIME) {
            activeTime = this.getTotalActiveTime();
            values = this.getAllValues();
        } else {
            activeTime = this.getCurrentActiveTime();
            values = this.trackedValues;
        }
        if (activeTime <= 0L) {
            return;
        }
        double hoursActive = (double)activeTime / 3600000.0;
        for (TrackableValue<?> value : values.values()) {
            value.updateRate(hoursActive);
        }
    }

    public void saveAndClose() {
        long currentSessionActiveTime;
        if (this.settings.persistData && this.sessionStartTime != -1L && (currentSessionActiveTime = this.getCurrentActiveTime()) > 0L) {
            TrackerData persistentData = PersistentData.get().getOrCreateTrackerData(this.trackerId);
            persistentData.addTotalActiveTime(this.getTotalActiveTime() - this.lastTotalActiveTime);
            PersistentData.save();
            this.lastTotalActiveTime = this.getTotalActiveTime();
        }
    }

    protected void onLocationChange(Location from, Location to) {
        if (this.settings.pauseOnLocationChange && this.settings.allowedLocations.length > 0 && !Arrays.asList(this.settings.allowedLocations).contains((Object)to)) {
            this.pauseTracker();
        } else if (Arrays.asList(this.settings.allowedLocations).contains((Object)to)) {
            this.resumeTracker();
        }
    }

    protected abstract void onTick(class_310 var1);

    protected abstract void onValueTracked(String var1, Number var2, TrackableValue<?> var3);

    protected void onSessionReset() {
    }

    protected void onAllDataReset() {
    }

    protected void onAfkEnter() {
    }

    protected void onAfkExit() {
    }

    public boolean hasData() {
        if (this.trackedValues.isEmpty()) {
            return false;
        }
        return this.trackedValues.values().stream().anyMatch(value -> ((Number)value.getTotal()).doubleValue() > 0.0 || value.getTimesReceived() > 0L);
    }

    public boolean hasDataInCurrentMode() {
        Map<String, TrackableValue<?>> values = this.getAllValues();
        if (values.isEmpty()) {
            return false;
        }
        return values.values().stream().anyMatch(value -> ((Number)value.getTotal()).doubleValue() > 0.0 || value.getTimesReceived() > 0L);
    }

    @Generated
    public TrackerConditions getConditions() {
        return this.conditions;
    }

    @Generated
    public TrackerSettings getSettings() {
        return this.settings;
    }

    @Generated
    public String getTrackerId() {
        return this.trackerId;
    }

    @Generated
    public TrackerDisplayMode getDisplayMode() {
        return this.displayMode;
    }

    @Generated
    public boolean isPaused() {
        return this.isPaused;
    }

    @Generated
    public boolean isAfk() {
        return this.isAfk;
    }
}

