/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.tracking;

import lombok.Generated;

public class TrackableValue<T extends Number> {
    private T total;
    private double ratePerHour = 0.0;
    private long lastReceivedTime = -1L;
    private long timesReceived = 0L;
    private double pricePerItem = 0.0;
    private boolean hasPricing = false;

    public TrackableValue(T initialValue) {
        this.total = initialValue instanceof Integer ? (Number)0 : (Number)(initialValue instanceof Long ? (Number)0L : (Number)(initialValue instanceof Double ? (Number)0.0 : (Number)(initialValue instanceof Float ? Float.valueOf(0.0f) : initialValue)));
    }

    public void add(T increment) {
        if (this.total instanceof Integer && increment instanceof Integer) {
            this.total = ((Number)this.total).intValue() + ((Number)increment).intValue();
        } else if (this.total instanceof Long && increment instanceof Long) {
            this.total = ((Number)this.total).longValue() + ((Number)increment).longValue();
        } else if (this.total instanceof Double && increment instanceof Double) {
            this.total = ((Number)this.total).doubleValue() + ((Number)increment).doubleValue();
        } else if (this.total instanceof Float && increment instanceof Float) {
            this.total = Float.valueOf(((Number)this.total).floatValue() + ((Number)increment).floatValue());
        } else {
            double currentValue = ((Number)this.total).doubleValue();
            double incrementValue = ((Number)increment).doubleValue();
            double newValue = currentValue + incrementValue;
            this.total = this.total instanceof Integer ? (Number)((int)newValue) : (Number)(this.total instanceof Long ? (Number)((long)newValue) : (Number)(this.total instanceof Float ? (Number)Float.valueOf((float)newValue) : (Number)newValue));
        }
        this.lastReceivedTime = System.currentTimeMillis();
        ++this.timesReceived;
    }

    public void updateRate(double hoursActive) {
        if (hoursActive > 0.0) {
            this.ratePerHour = ((Number)this.total).doubleValue() / hoursActive;
        }
    }

    public long getTimeSinceLastReceived() {
        if (this.lastReceivedTime == -1L) {
            return -1L;
        }
        return System.currentTimeMillis() - this.lastReceivedTime;
    }

    public double getRatePerHour() {
        return this.ratePerHour;
    }

    public void setPricePerItem(double price) {
        this.pricePerItem = price;
        this.hasPricing = price > 0.0;
    }

    public double getTotalValue() {
        return ((Number)this.total).doubleValue() * this.pricePerItem;
    }

    public double getValuePerHour() {
        return this.ratePerHour * this.pricePerItem;
    }

    public int asInt() {
        return ((Number)this.total).intValue();
    }

    public long asLong() {
        return ((Number)this.total).longValue();
    }

    public double asDouble() {
        return ((Number)this.total).doubleValue();
    }

    public float asFloat() {
        return ((Number)this.total).floatValue();
    }

    public boolean isType(Class<? extends Number> type) {
        return type.isInstance(this.total);
    }

    public <U extends Number> U getAs(Class<U> type, U defaultValue) {
        try {
            if (type == Integer.class) {
                return (U)Integer.valueOf(((Number)this.total).intValue());
            }
            if (type == Long.class) {
                return (U)Long.valueOf(((Number)this.total).longValue());
            }
            if (type == Double.class) {
                return (U)Double.valueOf(((Number)this.total).doubleValue());
            }
            if (type == Float.class) {
                return (U)Float.valueOf(((Number)this.total).floatValue());
            }
            return defaultValue;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Generated
    public T getTotal() {
        return this.total;
    }

    @Generated
    public long getLastReceivedTime() {
        return this.lastReceivedTime;
    }

    @Generated
    public long getTimesReceived() {
        return this.timesReceived;
    }

    @Generated
    public double getPricePerItem() {
        return this.pricePerItem;
    }

    @Generated
    public boolean isHasPricing() {
        return this.hasPricing;
    }
}

