/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.tracking;

import com.skyblock21.hud.EditGuiScreen;
import com.skyblock21.hud.EditHudElementScreen;
import com.skyblock21.hud.MultiLineHudElement;
import com.skyblock21.tracking.BaseTracker;
import com.skyblock21.tracking.TrackableValue;
import com.skyblock21.tracking.TrackerDisplayMode;
import com.skyblock21.util.Location;
import com.skyblock21.util.Utils;
import java.text.NumberFormat;
import java.util.Locale;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public abstract class TrackerHudElement
extends MultiLineHudElement {
    protected final BaseTracker tracker;
    protected final NumberFormat formatter = NumberFormat.getNumberInstance(Locale.US);

    public TrackerHudElement(int x, int y, BaseTracker tracker) {
        super(x, y);
        this.tracker = tracker;
        this.setupHud();
    }

    public TrackerHudElement(int x, int y, Location location, BaseTracker tracker) {
        super(x, y, location);
        this.tracker = tracker;
        this.setupHud();
    }

    protected abstract void setupHud();

    @Override
    protected void onTick(class_310 client) {
        this.tracker.tick(client);
        this.updateHudLines();
    }

    protected abstract void updateHudLines();

    protected <T extends Number> TrackableValue<T> createDummyValue(T total, double hoursActive) {
        TrackableValue<T> dummyValue = new TrackableValue<T>(total);
        if (hoursActive > 0.0) {
            dummyValue.updateRate(total.doubleValue() / hoursActive);
        }
        return dummyValue;
    }

    protected String formatValue(Number value) {
        if (value instanceof Integer || value instanceof Long) {
            return this.formatter.format(value.longValue());
        }
        return String.format("%.1f", value.doubleValue());
    }

    protected String formatRate(double rate) {
        return this.formatter.format(Math.round(rate));
    }

    protected String formatTime(long millis) {
        return Utils.formatTime(millis);
    }

    protected class_2561 createValueLine(String label, String color, TrackableValue<?> value) {
        if (value == null) {
            return class_2561.method_43470((String)String.format("%s%s: \u00a7f0 \u00a78(0/hr)", color, label));
        }
        return class_2561.method_43470((String)String.format("%s%s: \u00a7f%s \u00a78(%s/hr)", color, label, this.formatValue((Number)value.getTotal()), this.formatRate(value.getRatePerHour())));
    }

    protected class_2561 createTimeSinceLine(String label, TrackableValue<?> value) {
        if (value == null) {
            return class_2561.method_43470((String)String.format("\u00a77Last %s: \u00a7fNever", label));
        }
        long timeSince = value.getTimeSinceLastReceived();
        String timeStr = timeSince == -1L ? "Never" : this.formatTime(timeSince) + " ago";
        return class_2561.method_43470((String)String.format("\u00a77Last %s: \u00a7f%s", label, timeStr));
    }

    protected class_2561 createActiveTimeLine() {
        long activeTime = this.tracker.getDisplayMode() == TrackerDisplayMode.ALL_TIME ? this.tracker.getTotalActiveTime() : this.tracker.getCurrentActiveTime();
        return class_2561.method_43470((String)String.format("\u00a7dActive Time: \u00a7f%s", this.formatTime(activeTime)));
    }

    protected class_2561 createStatusLine() {
        if (this.tracker.isAfk()) {
            return class_2561.method_43470((String)"\u00a7c(AFK)");
        }
        if (this.tracker.isPaused()) {
            return class_2561.method_43470((String)"\u00a77(Paused)");
        }
        return class_2561.method_43473();
    }

    protected class_2561 createDisplayModeLine() {
        TrackerDisplayMode mode = this.tracker.getDisplayMode();
        String color = mode == TrackerDisplayMode.CURRENT_SESSION ? "\u00a7e" : "\u00a7b";
        return class_2561.method_43470((String)String.format("\u00a77Mode: %s%s", color, mode.getDisplayName()));
    }

    protected void addDisplayModeToggle() {
        if (!this.tracker.getSettings().persistData) {
            return;
        }
        this.addContainerClickableLine("toggle_mode", (class_2561)class_2561.method_43470((String)"\u00a76[Toggle Mode]"), () -> {
            this.tracker.toggleDisplayMode();
            this.updateHudLines();
        }).setHoverText((class_2561)class_2561.method_43470((String)"\u00a7eSwitch between Current Session and All Time data"));
    }

    protected void addResetButtons() {
        this.addContainerClickableLine("reset_session", (class_2561)class_2561.method_43470((String)"\u00a7e[Reset Session]"), () -> {
            this.tracker.resetSession();
            this.updateHudLines();
        }).setHoverText((class_2561)class_2561.method_43470((String)"\u00a7eReset current session data"));
        if (this.tracker.getSettings().persistData) {
            this.addContainerClickableLine("reset_all", (class_2561)class_2561.method_43470((String)"\u00a7c[Reset All Data]"), () -> {
                this.tracker.resetAll();
                this.updateHudLines();
            }).setHoverText((class_2561)class_2561.method_43470((String)"\u00a7cReset both session and persistent data"));
        }
    }

    protected void addModeDisplayLine() {
        if (!this.tracker.getSettings().persistData) {
            return;
        }
        this.addLine("display_mode", this.createDisplayModeLine(), "stats");
    }

    @Override
    public boolean shouldRenderDummy() {
        class_310 client = class_310.method_1551();
        boolean inEditMode = client.field_1755 instanceof EditGuiScreen || client.field_1755 instanceof EditHudElementScreen;
        return inEditMode && !this.tracker.hasDataInCurrentMode();
    }

    @Override
    public boolean shouldRender() {
        return this.tracker.getConditions().shouldRender(this.tracker);
    }
}

