/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.tracking;

import com.skyblock21.tracking.BaseTracker;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class TrackerManager {
    private static final Set<BaseTracker> trackers = new HashSet<BaseTracker>();

    public static void register(BaseTracker tracker) {
        trackers.add(tracker);
    }

    public static void unregister(BaseTracker tracker) {
        trackers.remove(tracker);
    }

    public static Set<BaseTracker> getAllTrackers() {
        return new HashSet<BaseTracker>(trackers);
    }

    public static Optional<BaseTracker> getTrackerById(String id) {
        return trackers.stream().filter(tracker -> tracker.getTrackerId().equals(id)).findFirst();
    }

    public static void saveAllTrackers() {
        trackers.forEach(BaseTracker::saveAndClose);
    }

    public static void shutdown() {
        TrackerManager.saveAllTrackers();
    }
}

