/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.tracking.impl;

import com.skyblock21.config.Skyblock21ConfigManager;
import com.skyblock21.events.ChatEvents;
import com.skyblock21.events.SkyblockEvents;
import com.skyblock21.tracking.BaseTracker;
import com.skyblock21.tracking.TrackableValue;
import com.skyblock21.tracking.TrackerConditions;
import com.skyblock21.tracking.TrackerSettings;
import com.skyblock21.util.Location;
import com.skyblock21.util.TextUtils;
import com.skyblock21.util.Utils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class BonusGiftsTracker
extends BaseTracker {
    private Map<String, Integer> gifts = new HashMap<String, Integer>();

    public BonusGiftsTracker() {
        super("bonus_gifts_tracker", new BonusGiftsTrackerConditions(), TrackerSettings.withPersistence(Location.GALATEA));
        ChatEvents.RECEIVE_TEXT.register(this::onChat);
        SkyblockEvents.LOCATION_CHANGE.register(this::onLocationChange);
    }

    @Override
    protected void onTick(class_310 client) {
    }

    @Override
    protected void onValueTracked(String key, Number increment, TrackableValue<?> value) {
        if (key.startsWith("gift_")) {
            String giftName = key.substring(5);
            this.gifts.put(giftName, ((Number)value.getTotal()).intValue());
        }
    }

    @Override
    protected void onSessionReset() {
        this.gifts.clear();
        TextUtils.addMessage("\u00a7aBonus gifts session reset!", true, false);
    }

    @Override
    protected void onAllDataReset() {
        this.gifts.clear();
        TextUtils.addMessage("\u00a7aAll bonus gifts data reset!", true, false);
    }

    @Override
    protected void loadPersistentData() {
        super.loadPersistentData();
    }

    private void onChat(class_2561 text) {
        if (!Utils.isOnSkyblock() || !Utils.isInGalatea()) {
            return;
        }
        if (!this.conditions.shouldTrack(this)) {
            return;
        }
    }

    private void onLocationChange(Location location) {
        if (!Utils.isOnSkyblock() || !Utils.isInGalatea()) {
            this.pauseTracker();
        }
    }

    private static class BonusGiftsTrackerConditions
    implements TrackerConditions {
        private BonusGiftsTrackerConditions() {
        }

        @Override
        public boolean shouldTrack(BaseTracker tracker) {
            return Utils.isOnSkyblock() && Utils.isInGalatea();
        }

        @Override
        public boolean shouldRender(BaseTracker tracker) {
            return Skyblock21ConfigManager.get().foraging.bonusGiftsTracker;
        }
    }
}

