/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.tracking.impl;

import com.skyblock21.Skyblock21;
import com.skyblock21.config.Skyblock21ConfigManager;
import com.skyblock21.events.ChatEvents;
import com.skyblock21.events.SkyblockEvents;
import com.skyblock21.tracking.BaseTracker;
import com.skyblock21.tracking.TrackableValue;
import com.skyblock21.tracking.TrackerConditions;
import com.skyblock21.tracking.TrackerManager;
import com.skyblock21.tracking.TrackerSettings;
import com.skyblock21.util.Location;
import com.skyblock21.util.TextUtils;
import com.skyblock21.util.Utils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_310;

public class GalateaTracker
extends BaseTracker {
    private boolean insideTreeGiftMessage = false;
    private boolean pastBonusGiftsMessage = false;

    public GalateaTracker() {
        super("galatea_tracker", new GalateaTrackerConditions(), TrackerSettings.withPersistence(Location.GALATEA));
        ChatEvents.RECEIVE_TEXT.register(this::onChat);
        SkyblockEvents.SKILL_GAINED.register(this::onSkillGained);
        SkyblockEvents.LOCATION_CHANGE.register(this::onLocationChange);
    }

    @Override
    protected void onTick(class_310 client) {
    }

    @Override
    protected void onValueTracked(String key, Number increment, TrackableValue<?> value) {
    }

    @Override
    protected void onSessionReset() {
        TextUtils.addMessage("\u00a7aGalatea session reset!", true, false);
    }

    @Override
    protected void onAllDataReset() {
        TextUtils.addMessage("\u00a7aAll Galatea data reset!", true, false);
    }

    private void onChat(class_2561 text) {
        if (!Utils.isOnSkyblock() || !Utils.isInGalatea()) {
            return;
        }
        if (!this.conditions.shouldTrack(this)) {
            return;
        }
        String message = text.getString();
        if (message.equals("\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac")) {
            if (!this.insideTreeGiftMessage) {
                this.insideTreeGiftMessage = true;
            } else {
                this.insideTreeGiftMessage = false;
                this.pastBonusGiftsMessage = false;
            }
        }
        if (!(message.contains("rewards gained") || this.insideTreeGiftMessage || message.contains("BONUS GIFT"))) {
            return;
        }
        if (message.contains("rewards gained")) {
            this.parseExp(text);
        } else {
            this.parseBonusGifts(text);
        }
    }

    private void onSkillGained(SkyblockEvents.Skill skill, double amount) {
        if (skill != SkyblockEvents.Skill.FORAGING || !this.conditions.shouldTrack(this)) {
            return;
        }
        this.trackValue("foraging_exp", (int)amount);
    }

    private void onLocationChange(Location location) {
        if (!Utils.isOnSkyblock() || !Utils.isInGalatea()) {
            this.pauseTracker();
        }
    }

    private void parseBonusGifts(class_2561 text) {
        String message = text.getString();
        if (message.contains("BONUS GIFT") && !this.pastBonusGiftsMessage) {
            this.pastBonusGiftsMessage = true;
        }
        if (!message.endsWith("%)") || !this.pastBonusGiftsMessage) {
            return;
        }
        String itemName = TextUtils.toLegacy(text).replaceAll("\\s\u00a78\\(\u00a7a([\\d.]+%)\u00a78\\)", "").replaceAll("^\u00a7f\\s+", "");
        if (itemName.startsWith("Enchanted Book")) {
            Matcher matcher = Pattern.compile("\u00a7aEnchanted Book \\((.*?)\u00a7a\\)").matcher(itemName);
            if (matcher.find()) {
                itemName = matcher.group(1).trim();
            }
            if (itemName.isEmpty()) {
                Skyblock21.LOGGER.error("GalateaTracker - Error parsing Enchanted Book name from message: " + message);
                return;
            }
        }
        BaseTracker bonusGiftsTracker = TrackerManager.getTrackerById("bonus_gifts_tracker").get();
        bonusGiftsTracker.trackValue("gift_" + itemName, 1);
    }

    private void parseExp(class_2561 text) {
        String nextLine;
        class_2583 style = text.method_10866();
        for (class_2561 sibling : text.method_10855()) {
            class_2583 siblingStyle;
            if (sibling.method_10866() == null || (siblingStyle = sibling.method_10866()).method_10969() == null) continue;
            style = siblingStyle;
            break;
        }
        if (style == null || style.method_10969() == null) {
            return;
        }
        class_2568 hover = style.method_10969();
        if (hover.method_10892() != class_2568.class_5247.field_24342) {
            return;
        }
        class_2561 hoverText = ((class_2568.class_10613)hover).comp_3510();
        if (hoverText == null || hoverText.method_10855().isEmpty()) {
            return;
        }
        if (hoverText.toString().trim().contains("Forest Essence") && !(nextLine = ((class_2561)hoverText.method_10855().getFirst()).getString().trim()).isEmpty()) {
            this.trackValue("forest_essence", this.parseNumber(nextLine));
        }
        for (class_2561 child : hoverText.method_10855()) {
            String line = child.getString().trim();
            int index = hoverText.method_10855().indexOf(child);
            if (index == -1 || index == hoverText.method_10855().size() - 1) continue;
            String nextChild = ((class_2561)hoverText.method_10855().get(index + 1)).getString();
            if (line.contains("Foraging Experience")) {
                this.trackValue("foraging_exp", this.parseNumber(nextChild));
                continue;
            }
            if (line.contains("HOTF Experience")) {
                this.trackValue("hotf_exp", this.parseNumber(nextChild));
                continue;
            }
            if (!line.contains("Forest Whispers")) continue;
            this.trackValue("whispers", this.parseNumber(nextChild));
        }
    }

    private int parseNumber(String str) {
        str = str.replace(",", "").replace("x", "").trim();
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            Skyblock21.LOGGER.error("GalateaTracker - Error parsing number: " + str);
            return 0;
        }
    }

    private static class GalateaTrackerConditions
    implements TrackerConditions {
        private GalateaTrackerConditions() {
        }

        @Override
        public boolean shouldTrack(BaseTracker tracker) {
            return Utils.isOnSkyblock() && Utils.isInGalatea();
        }

        @Override
        public boolean shouldRender(BaseTracker tracker) {
            return Skyblock21ConfigManager.get().foraging.galateaTracker;
        }
    }
}

