/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.util;

import java.util.Arrays;
import net.minecraft.class_3542;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.NotNull;

public enum Location implements class_3542
{
    PRIVATE_ISLAND("dynamic"),
    GARDEN("garden"),
    HUB("hub"),
    THE_FARMING_ISLAND("farming_1"),
    THE_PARK("foraging_1"),
    SPIDERS_DEN("combat_1", "Spider's Den"),
    BLAZING_FORTRESS("combat_2"),
    THE_END("combat_3"),
    CRIMSON_ISLE("crimson_isle"),
    GOLD_MINE("mining_1"),
    DEEP_CAVERNS("mining_2"),
    DWARVEN_MINES("mining_3"),
    BACKWATER_BAYOU("fishing_1"),
    DUNGEON_HUB("dungeon_hub"),
    WINTER_ISLAND("winter", "Jerry's Workshop"),
    THE_RIFT("rift"),
    DARK_AUCTION("dark_auction"),
    CRYSTAL_HOLLOWS("crystal_hollows"),
    DUNGEON("dungeon", "Dungeons"),
    KUUDRAS_HOLLOW("kuudra", "Kuudra's Hollow"),
    GLACITE_MINESHAFT("mineshaft"),
    GALATEA("foraging_2"),
    UNKNOWN("unknown");

    @NotNull
    private final String id;
    @NotNull
    private final String friendlyName;

    private Location(String id, String friendlyName) {
        this.id = id;
        this.friendlyName = friendlyName;
    }

    private Location(String id) {
        this.id = id;
        this.friendlyName = WordUtils.capitalizeFully((String)this.name().replace('_', ' '));
    }

    @NotNull
    public String id() {
        return this.id;
    }

    public String method_15434() {
        return this.id();
    }

    @NotNull
    public static Location from(String id) {
        return Arrays.stream(Location.values()).filter(loc -> loc.id.equals(id)).findFirst().orElse(UNKNOWN);
    }

    @NotNull
    public static Location fromFriendlyName(String friendlyName) {
        return Arrays.stream(Location.values()).filter(loc -> loc.friendlyName.equals(friendlyName)).findFirst().orElse(UNKNOWN);
    }

    public String toString() {
        return this.friendlyName;
    }
}

