/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.util;

import com.skyblock21.gui.Theme;
import com.skyblock21.gui.ThemeManager;
import com.skyblock21.util.ColorUtil;
import com.skyblock21.util.render.RenderLayers;
import java.awt.Color;
import java.awt.Rectangle;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public class Render2DUtil {
    public static void drawTexturedQuad(class_332 drawContext, class_2960 texture, Rectangle size, Color color) {
        Render2DUtil.drawTexturedQuad(drawContext, texture, (float)size.getX(), (float)size.getY(), (float)size.getWidth(), (float)size.getHeight(), color);
    }

    public static void drawTexturedQuad(class_332 drawContext, class_2960 texture, float x1, float y1, float width, float height, Color color) {
        class_4587 matrixStack = drawContext.method_51448();
        Matrix4f matrix4f = matrixStack.method_23760().method_23761();
        int colorInt = ColorUtil.getIntFromColor(color);
        float x2 = x1 + width;
        float y2 = y1 + height;
        drawContext.method_64039(vertexConsumerProvider -> {
            class_4588 bufferBuilder = vertexConsumerProvider.getBuffer(RenderLayers.TEXTURES_QUADS_GUI.apply(texture));
            bufferBuilder.method_22918(matrix4f, x1, y1, 0.0f).method_39415(colorInt).method_22913(0.0f, 0.0f);
            bufferBuilder.method_22918(matrix4f, x1, y2, 0.0f).method_39415(colorInt).method_22913(0.0f, 1.0f);
            bufferBuilder.method_22918(matrix4f, x2, y2, 0.0f).method_39415(colorInt).method_22913(1.0f, 1.0f);
            bufferBuilder.method_22918(matrix4f, x2, y1, 0.0f).method_39415(colorInt).method_22913(1.0f, 0.0f);
        });
    }

    public static void drawBox(class_332 drawContext, Rectangle size, Color color) {
        Render2DUtil.drawBox(drawContext, (float)size.getX(), (float)size.getY(), (float)size.getWidth(), (float)size.getHeight(), color);
    }

    public static void drawBox(class_332 drawContext, float x, float y, float width, float height, Color color) {
        int colorInt = ColorUtil.getIntFromColor(color);
        class_4587 matrixStack = drawContext.method_51448();
        Matrix4f matrix4f = matrixStack.method_23760().method_23761();
        drawContext.method_64039(vertexConsumerProvider -> {
            class_4588 bufferBuilder = vertexConsumerProvider.getBuffer((class_1921)RenderLayers.QUADS_GUI);
            bufferBuilder.method_22918(matrix4f, x, y, 0.0f).method_39415(colorInt);
            bufferBuilder.method_22918(matrix4f, x + width, y, 0.0f).method_39415(colorInt);
            bufferBuilder.method_22918(matrix4f, x + width, y + height, 0.0f).method_39415(colorInt);
            bufferBuilder.method_22918(matrix4f, x, y + height, 0.0f).method_39415(colorInt);
        });
    }

    public static void drawRoundedBox(class_332 drawContext, Rectangle size, float radius, Color color) {
        Render2DUtil.drawRoundedBox(drawContext, (float)size.getX(), (float)size.getY(), (float)size.getWidth(), (float)size.getHeight(), radius, color);
    }

    public static void drawRoundedBox(class_332 drawContext, float x, float y, float width, float height, float radius, Color color) {
        int colorInt = ColorUtil.getIntFromColor(color);
        class_4587 matrixStack = drawContext.method_51448();
        Matrix4f matrix4f = matrixStack.method_23760().method_23761();
        drawContext.method_64039(vertexConsumerProvider -> {
            class_4588 bufferBuilder = vertexConsumerProvider.getBuffer((class_1921)RenderLayers.TRIS_GUI);
            Render2DUtil.buildFilledArc(bufferBuilder, matrix4f, x + radius, y + radius, radius, 180.0f, 90.0f, color);
            Render2DUtil.buildFilledArc(bufferBuilder, matrix4f, x + width - radius, y + radius, radius, 270.0f, 90.0f, color);
            Render2DUtil.buildFilledArc(bufferBuilder, matrix4f, x + width - radius, y + height - radius, radius, 0.0f, 90.0f, color);
            Render2DUtil.buildFilledArc(bufferBuilder, matrix4f, x + radius, y + height - radius, radius, 90.0f, 90.0f, color);
            bufferBuilder.method_22918(matrix4f, x + radius, y, 0.0f).method_39415(colorInt);
            bufferBuilder.method_22918(matrix4f, x + width - radius, y, 0.0f).method_39415(colorInt);
            bufferBuilder.method_22918(matrix4f, x + radius, y + radius, 0.0f).method_39415(colorInt);
            bufferBuilder.method_22918(matrix4f, x + radius, y + radius, 0.0f).method_39415(colorInt);
            bufferBuilder.method_22918(matrix4f, x + width - radius, y, 0.0f).method_39415(colorInt);
            bufferBuilder.method_22918(matrix4f, x + width - radius, y + radius, 0.0f).method_39415(colorInt);
            bufferBuilder.method_22918(matrix4f, x + width - radius, y + radius, 0.0f).method_39415(colorInt);
            bufferBuilder.method_22918(matrix4f, x + width, y + radius, 0.0f).method_39415(colorInt);
            bufferBuilder.method_22918(matrix4f, x + width - radius, y + height - radius, 0.0f).method_39415(colorInt);
            bufferBuilder.method_22918(matrix4f, x + width, y + radius, 0.0f).method_39415(colorInt);
            bufferBuilder.method_22918(matrix4f, x + width, y + height - radius, 0.0f).method_39415(colorInt);
            bufferBuilder.method_22918(matrix4f, x + width - radius, y + height - radius, 0.0f).method_39415(colorInt);
            bufferBuilder.method_22918(matrix4f, x + width - radius, y + height - radius, 0.0f).method_39415(colorInt);
            bufferBuilder.method_22918(matrix4f, x + width - radius, y + height, 0.0f).method_39415(colorInt);
            bufferBuilder.method_22918(matrix4f, x + radius, y + height - radius, 0.0f).method_39415(colorInt);
            bufferBuilder.method_22918(matrix4f, x + radius, y + height - radius, 0.0f).method_39415(colorInt);
            bufferBuilder.method_22918(matrix4f, x + radius, y + height, 0.0f).method_39415(colorInt);
            bufferBuilder.method_22918(matrix4f, x + width - radius, y + height, 0.0f).method_39415(colorInt);
            bufferBuilder.method_22918(matrix4f, x + radius, y + height - radius, 0.0f).method_39415(colorInt);
            bufferBuilder.method_22918(matrix4f, x, y + height - radius, 0.0f).method_39415(colorInt);
            bufferBuilder.method_22918(matrix4f, x, y + radius, 0.0f).method_39415(colorInt);
            bufferBuilder.method_22918(matrix4f, x, y + radius, 0.0f).method_39415(colorInt);
            bufferBuilder.method_22918(matrix4f, x + radius, y + radius, 0.0f).method_39415(colorInt);
            bufferBuilder.method_22918(matrix4f, x + radius, y + height - radius, 0.0f).method_39415(colorInt);
            bufferBuilder.method_22918(matrix4f, x + radius, y + radius, 0.0f).method_39415(colorInt);
            bufferBuilder.method_22918(matrix4f, x + width - radius, y + radius, 0.0f).method_39415(colorInt);
            bufferBuilder.method_22918(matrix4f, x + radius, y + height - radius, 0.0f).method_39415(colorInt);
            bufferBuilder.method_22918(matrix4f, x + radius, y + height - radius, 0.0f).method_39415(colorInt);
            bufferBuilder.method_22918(matrix4f, x + width - radius, y + height - radius, 0.0f).method_39415(colorInt);
            bufferBuilder.method_22918(matrix4f, x + width - radius, y + radius, 0.0f).method_39415(colorInt);
        });
    }

    public static void drawCircle(class_332 drawContext, float x, float y, float radius, Color color) {
        int colorInt = ColorUtil.getIntFromColor(color);
        class_4587 matrixStack = drawContext.method_51448();
        Matrix4f matrix4f = matrixStack.method_23760().method_23761();
        drawContext.method_64039(vertexConsumerProvider -> {
            class_4588 bufferBuilder = vertexConsumerProvider.getBuffer((class_1921)RenderLayers.TRIS_GUI);
            double roundedInterval = 12.0;
            for (int i = 0; i < 30; ++i) {
                double angle = Math.toRadians(0.0 + (double)i * roundedInterval);
                double angle2 = Math.toRadians(0.0 + (double)(i + 1) * roundedInterval);
                float radiusX1 = (float)(Math.cos(angle) * (double)radius);
                float radiusY1 = (float)Math.sin(angle) * radius;
                float radiusX2 = (float)Math.cos(angle2) * radius;
                float radiusY2 = (float)Math.sin(angle2) * radius;
                bufferBuilder.method_22918(matrix4f, x, y, 0.0f).method_39415(colorInt);
                bufferBuilder.method_22918(matrix4f, x + radiusX1, y + radiusY1, 0.0f).method_39415(colorInt);
                bufferBuilder.method_22918(matrix4f, x + radiusX2, y + radiusY2, 0.0f).method_39415(colorInt);
            }
        });
    }

    public static void drawTranslucentBlurredRoundedBox(class_332 drawContext, float x, float y, float width, float height, float radius, Color color) {
        for (int i = 0; i < 5; ++i) {
            float r = color.getRed();
            float g = color.getGreen();
            float b = color.getBlue();
            float alpha = (float)color.getAlpha() * (1.0f / (float)(i + 1));
            Color newColor = new Color(r, g, b, alpha);
            Render2DUtil.drawRoundedBox(drawContext, x - (float)i, y - (float)i, width + (float)(2 * i), height + (float)(2 * i), radius + (float)i, newColor);
        }
        Render2DUtil.drawRoundedBox(drawContext, x, y, width, height, radius, color);
    }

    public static void drawOutlinedBox(class_332 drawContext, Rectangle size, Color outlineColor, Color backgroundColor) {
        Render2DUtil.drawOutlinedBox(drawContext, (float)size.getX(), (float)size.getY(), (float)size.getWidth(), (float)size.getHeight(), outlineColor, backgroundColor);
    }

    public static void drawOutlinedBox(class_332 drawContext, float x, float y, float width, float height, Color outlineColor, Color backgroundColor) {
        class_4587 matrixStack = drawContext.method_51448();
        Matrix4f matrix4f = matrixStack.method_23760().method_23761();
        int backgroundColorInt = ColorUtil.getIntFromColor(backgroundColor);
        int outlineColorInt = ColorUtil.getIntFromColor(outlineColor);
        drawContext.method_64039(vertexConsumerProvider -> {
            class_4588 bufferBuilder = vertexConsumerProvider.getBuffer((class_1921)RenderLayers.QUADS_GUI);
            bufferBuilder.method_22918(matrix4f, x, y, 0.0f).method_39415(backgroundColorInt);
            bufferBuilder.method_22918(matrix4f, x + width, y, 0.0f).method_39415(backgroundColorInt);
            bufferBuilder.method_22918(matrix4f, x + width, y + height, 0.0f).method_39415(backgroundColorInt);
            bufferBuilder.method_22918(matrix4f, x, y + height, 0.0f).method_39415(backgroundColorInt);
        });
        GL11.glEnable((int)2848);
        drawContext.method_64039(vertexConsumerProvider -> {
            class_4588 bufferBuilder = vertexConsumerProvider.getBuffer((class_1921)RenderLayers.LINES_GUI);
            bufferBuilder.method_22918(matrix4f, x, y, 0.0f).method_39415(outlineColorInt);
            bufferBuilder.method_22918(matrix4f, x + width, y, 0.0f).method_39415(outlineColorInt);
            bufferBuilder.method_22918(matrix4f, x + width, y + height, 0.0f).method_39415(outlineColorInt);
            bufferBuilder.method_22918(matrix4f, x, y + height, 0.0f).method_39415(outlineColorInt);
            bufferBuilder.method_22918(matrix4f, x, y, 0.0f).method_39415(outlineColorInt);
        });
        GL11.glDisable((int)2848);
    }

    public static void drawBoxOutline(class_332 drawContext, Rectangle size, Color color) {
        Render2DUtil.drawBoxOutline(drawContext, (float)size.getX(), (float)size.getY(), (float)size.getWidth(), (float)size.getHeight(), color);
    }

    public static void drawBoxOutline(class_332 drawContext, float x, float y, float width, float height, Color color) {
        int colorInt = ColorUtil.getIntFromColor(color);
        class_4587 matrixStack = drawContext.method_51448();
        Matrix4f matrix4f = matrixStack.method_23760().method_23761();
        GL11.glEnable((int)2848);
        drawContext.method_64039(vertexConsumerProvider -> {
            class_4588 bufferBuilder = vertexConsumerProvider.getBuffer((class_1921)RenderLayers.LINES_GUI);
            bufferBuilder.method_22918(matrix4f, x, y, 0.0f).method_39415(colorInt);
            bufferBuilder.method_22918(matrix4f, x + width, y, 0.0f).method_39415(colorInt);
            bufferBuilder.method_22918(matrix4f, x + width, y + height, 0.0f).method_39415(colorInt);
            bufferBuilder.method_22918(matrix4f, x, y + height, 0.0f).method_39415(colorInt);
            bufferBuilder.method_22918(matrix4f, x, y, 0.0f).method_39415(colorInt);
        });
        GL11.glDisable((int)2848);
    }

    public static void drawRoundedBoxOutline(class_332 drawContext, Rectangle size, float radius, Color color) {
        Render2DUtil.drawRoundedBoxOutline(drawContext, (float)size.getX(), (float)size.getY(), (float)size.getWidth(), (float)size.getHeight(), radius, color);
    }

    public static void drawOutlinedRoundedBox(class_332 drawContext, float x, float y, float width, float height, float radius, Color outlineColor, Color backgroundColor) {
        class_4587 matrixStack = drawContext.method_51448();
        Matrix4f matrix4f = matrixStack.method_23760().method_23761();
        int backgroundColorInt = ColorUtil.getIntFromColor(backgroundColor);
        int outlineColorInt = ColorUtil.getIntFromColor(outlineColor);
        GL11.glEnable((int)2848);
        drawContext.method_64039(vertexConsumerProvider -> {
            class_4588 bufferBuilder = vertexConsumerProvider.getBuffer((class_1921)RenderLayers.TRIS_GUI);
            Render2DUtil.buildFilledArc(bufferBuilder, matrix4f, x + width - radius, y + radius, radius, 270.0f, 90.0f, backgroundColor);
            Render2DUtil.buildFilledArc(bufferBuilder, matrix4f, x + width - radius, y + height - radius, radius, 0.0f, 90.0f, backgroundColor);
            Render2DUtil.buildFilledArc(bufferBuilder, matrix4f, x + radius, y + height - radius, radius, 90.0f, 90.0f, backgroundColor);
            Render2DUtil.buildFilledArc(bufferBuilder, matrix4f, x + radius, y + radius, radius, 180.0f, 90.0f, backgroundColor);
            bufferBuilder.method_22918(matrix4f, x + radius, y, 0.0f).method_39415(backgroundColorInt);
            bufferBuilder.method_22918(matrix4f, x + width - radius, y, 0.0f).method_39415(backgroundColorInt);
            bufferBuilder.method_22918(matrix4f, x + radius, y + radius, 0.0f).method_39415(backgroundColorInt);
            bufferBuilder.method_22918(matrix4f, x + radius, y + radius, 0.0f).method_39415(backgroundColorInt);
            bufferBuilder.method_22918(matrix4f, x + width - radius, y, 0.0f).method_39415(backgroundColorInt);
            bufferBuilder.method_22918(matrix4f, x + width - radius, y + radius, 0.0f).method_39415(backgroundColorInt);
            bufferBuilder.method_22918(matrix4f, x + width - radius, y + radius, 0.0f).method_39415(backgroundColorInt);
            bufferBuilder.method_22918(matrix4f, x + width, y + radius, 0.0f).method_39415(backgroundColorInt);
            bufferBuilder.method_22918(matrix4f, x + width - radius, y + height - radius, 0.0f).method_39415(backgroundColorInt);
            bufferBuilder.method_22918(matrix4f, x + width, y + radius, 0.0f).method_39415(backgroundColorInt);
            bufferBuilder.method_22918(matrix4f, x + width, y + height - radius, 0.0f).method_39415(backgroundColorInt);
            bufferBuilder.method_22918(matrix4f, x + width - radius, y + height - radius, 0.0f).method_39415(backgroundColorInt);
            bufferBuilder.method_22918(matrix4f, x + width - radius, y + height - radius, 0.0f).method_39415(backgroundColorInt);
            bufferBuilder.method_22918(matrix4f, x + width - radius, y + height, 0.0f).method_39415(backgroundColorInt);
            bufferBuilder.method_22918(matrix4f, x + radius, y + height - radius, 0.0f).method_39415(backgroundColorInt);
            bufferBuilder.method_22918(matrix4f, x + radius, y + height - radius, 0.0f).method_39415(backgroundColorInt);
            bufferBuilder.method_22918(matrix4f, x + radius, y + height, 0.0f).method_39415(backgroundColorInt);
            bufferBuilder.method_22918(matrix4f, x + width - radius, y + height, 0.0f).method_39415(backgroundColorInt);
            bufferBuilder.method_22918(matrix4f, x + radius, y + height - radius, 0.0f).method_39415(backgroundColorInt);
            bufferBuilder.method_22918(matrix4f, x, y + height - radius, 0.0f).method_39415(backgroundColorInt);
            bufferBuilder.method_22918(matrix4f, x, y + radius, 0.0f).method_39415(backgroundColorInt);
            bufferBuilder.method_22918(matrix4f, x, y + radius, 0.0f).method_39415(backgroundColorInt);
            bufferBuilder.method_22918(matrix4f, x + radius, y + radius, 0.0f).method_39415(backgroundColorInt);
            bufferBuilder.method_22918(matrix4f, x + radius, y + height - radius, 0.0f).method_39415(backgroundColorInt);
            bufferBuilder.method_22918(matrix4f, x + radius, y + radius, 0.0f).method_39415(backgroundColorInt);
            bufferBuilder.method_22918(matrix4f, x + width - radius, y + radius, 0.0f).method_39415(backgroundColorInt);
            bufferBuilder.method_22918(matrix4f, x + radius, y + height - radius, 0.0f).method_39415(backgroundColorInt);
            bufferBuilder.method_22918(matrix4f, x + radius, y + height - radius, 0.0f).method_39415(backgroundColorInt);
            bufferBuilder.method_22918(matrix4f, x + width - radius, y + height - radius, 0.0f).method_39415(backgroundColorInt);
            bufferBuilder.method_22918(matrix4f, x + width - radius, y + radius, 0.0f).method_39415(backgroundColorInt);
            bufferBuilder = vertexConsumerProvider.getBuffer((class_1921)RenderLayers.LINES_GUI);
            Render2DUtil.buildArc(bufferBuilder, matrix4f, x + radius, y + radius, radius, 180.0f, 90.0f, outlineColor);
            bufferBuilder.method_22918(matrix4f, x + radius, y, 0.0f).method_39415(outlineColorInt);
            bufferBuilder.method_22918(matrix4f, x + width - radius, y, 0.0f).method_39415(outlineColorInt);
            Render2DUtil.buildArc(bufferBuilder, matrix4f, x + width - radius, y + radius, radius, 270.0f, 90.0f, outlineColor);
            bufferBuilder.method_22918(matrix4f, x + width, y + radius, 0.0f).method_39415(outlineColorInt);
            bufferBuilder.method_22918(matrix4f, x + width, y + height - radius, 0.0f).method_39415(outlineColorInt);
            Render2DUtil.buildArc(bufferBuilder, matrix4f, x + width - radius, y + height - radius, radius, 0.0f, 90.0f, outlineColor);
            bufferBuilder.method_22918(matrix4f, x + width - radius, y + height, 0.0f).method_39415(outlineColorInt);
            bufferBuilder.method_22918(matrix4f, x + radius, y + height, 0.0f).method_39415(outlineColorInt);
            Render2DUtil.buildArc(bufferBuilder, matrix4f, x + radius, y + height - radius, radius, 90.0f, 90.0f, outlineColor);
            bufferBuilder.method_22918(matrix4f, x, y + height - radius, 0.0f).method_39415(outlineColorInt);
            bufferBuilder.method_22918(matrix4f, x, y + radius, 0.0f).method_39415(outlineColorInt);
        });
        GL11.glDisable((int)2848);
    }

    public static void drawRoundedBoxOutline(class_332 drawContext, float x, float y, float width, float height, float radius, Color color) {
        class_4587 matrixStack = drawContext.method_51448();
        Matrix4f matrix4f = matrixStack.method_23760().method_23761();
        int colorInt = ColorUtil.getIntFromColor(color);
        GL11.glEnable((int)2848);
        drawContext.method_64039(vertexConsumerProvider -> {
            class_4588 bufferBuilder = vertexConsumerProvider.getBuffer((class_1921)RenderLayers.LINES_GUI);
            Render2DUtil.buildArc(bufferBuilder, matrix4f, x + radius, y + radius, radius, 180.0f, 90.0f, color);
            bufferBuilder.method_22918(matrix4f, x + radius, y, 0.0f).method_39415(colorInt);
            bufferBuilder.method_22918(matrix4f, x + width - radius, y, 0.0f).method_39415(colorInt);
            Render2DUtil.buildArc(bufferBuilder, matrix4f, x + width - radius, y + radius, radius, 270.0f, 90.0f, color);
            bufferBuilder.method_22918(matrix4f, x + width, y + radius, 0.0f).method_39415(colorInt);
            bufferBuilder.method_22918(matrix4f, x + width, y + height - radius, 0.0f).method_39415(colorInt);
            Render2DUtil.buildArc(bufferBuilder, matrix4f, x + width - radius, y + height - radius, radius, 0.0f, 90.0f, color);
            bufferBuilder.method_22918(matrix4f, x + width - radius, y + height, 0.0f).method_39415(colorInt);
            bufferBuilder.method_22918(matrix4f, x + radius, y + height, 0.0f).method_39415(colorInt);
            Render2DUtil.buildArc(bufferBuilder, matrix4f, x + radius, y + height - radius, radius, 90.0f, 90.0f, color);
            bufferBuilder.method_22918(matrix4f, x, y + height - radius, 0.0f).method_39415(colorInt);
            bufferBuilder.method_22918(matrix4f, x, y + radius, 0.0f).method_39415(colorInt);
        });
        GL11.glDisable((int)2848);
    }

    public static void drawLine(class_332 drawContext, float x1, float y1, float x2, float y2, Color color) {
        int colorInt = ColorUtil.getIntFromColor(color);
        class_4587 matrixStack = drawContext.method_51448();
        Matrix4f matrix4f = matrixStack.method_23760().method_23761();
        GL11.glEnable((int)2848);
        drawContext.method_64039(vertexConsumerProvider -> {
            class_4588 bufferBuilder = vertexConsumerProvider.getBuffer((class_1921)RenderLayers.LINES_GUI);
            bufferBuilder.method_22918(matrix4f, x1, y1, 0.0f).method_39415(colorInt);
            bufferBuilder.method_22918(matrix4f, x2, y2, 0.0f).method_39415(colorInt);
        });
        GL11.glDisable((int)2848);
    }

    public static void drawHorizontalGradient(class_332 drawContext, Rectangle size, Color startColor, Color endColor) {
        Render2DUtil.drawHorizontalGradient(drawContext, (float)size.getX(), (float)size.getY(), (float)size.getWidth(), (float)size.getHeight(), startColor, endColor);
    }

    public static void drawHorizontalGradient(class_332 drawContext, float x, float y, float width, float height, Color startColor, Color endColor) {
        int startColorInt = ColorUtil.getIntFromColor(startColor);
        int endColorInt = ColorUtil.getIntFromColor(endColor);
        class_4587 matrixStack = drawContext.method_51448();
        Matrix4f matrix4f = matrixStack.method_23760().method_23761();
        drawContext.method_64039(vertexConsumerProvider -> {
            class_4588 bufferBuilder = vertexConsumerProvider.getBuffer((class_1921)RenderLayers.QUADS_GUI);
            bufferBuilder.method_22918(matrix4f, x, y, 0.0f).method_39415(startColorInt);
            bufferBuilder.method_22918(matrix4f, x + width, y, 0.0f).method_39415(endColorInt);
            bufferBuilder.method_22918(matrix4f, x + width, y + height, 0.0f).method_39415(endColorInt);
            bufferBuilder.method_22918(matrix4f, x, y + height, 0.0f).method_39415(startColorInt);
        });
    }

    public static void drawVerticalGradient(class_332 drawContext, Rectangle size, Color startColor, Color endColor) {
        Render2DUtil.drawVerticalGradient(drawContext, (float)size.getX(), (float)size.getY(), (float)size.getWidth(), (float)size.getHeight(), startColor, endColor);
    }

    public static void drawVerticalGradient(class_332 drawContext, float x, float y, float width, float height, Color startColor, Color endColor) {
        class_4587 matrixStack = drawContext.method_51448();
        Matrix4f matrix4f = matrixStack.method_23760().method_23761();
        int startColorInt = ColorUtil.getIntFromColor(startColor);
        int endColorInt = ColorUtil.getIntFromColor(endColor);
        drawContext.method_64039(vertexConsumerProvider -> {
            class_4588 bufferBuilder = vertexConsumerProvider.getBuffer((class_1921)RenderLayers.QUADS_GUI);
            bufferBuilder.method_22918(matrix4f, x, y, 0.0f).method_39415(startColorInt);
            bufferBuilder.method_22918(matrix4f, x + width, y, 0.0f).method_39415(startColorInt);
            bufferBuilder.method_22918(matrix4f, x + width, y + height, 0.0f).method_39415(endColorInt);
            bufferBuilder.method_22918(matrix4f, x, y + height, 0.0f).method_39415(endColorInt);
        });
    }

    public static void drawString(class_332 drawContext, String text, float x, float y, Color color) {
        Theme theme = ThemeManager.getCurrentTheme();
        class_4587 matrixStack = drawContext.method_51448();
        matrixStack.method_22903();
        matrixStack.method_22905(2.0f, 2.0f, 1.0f);
        matrixStack.method_46416(-x / 2.0f, -y / 2.0f, 0.0f);
        drawContext.method_51433(theme.getTextRenderer(), text, (int)x, (int)y, ColorUtil.getIntFromColor(color), false);
        matrixStack.method_22909();
    }

    public static void drawString(class_332 drawContext, String text, float x, float y, int color) {
        Theme theme = ThemeManager.getCurrentTheme();
        class_4587 matrixStack = drawContext.method_51448();
        matrixStack.method_22903();
        matrixStack.method_22905(2.0f, 2.0f, 1.0f);
        matrixStack.method_46416(-x / 2.0f, -y / 2.0f, 0.0f);
        drawContext.method_51433(theme.getTextRenderer(), text, (int)x, (int)y, color, false);
        matrixStack.method_22909();
    }

    public static void drawStringWithScale(class_332 drawContext, String text, float x, float y, Color color, float scale) {
        Theme theme = ThemeManager.getCurrentTheme();
        class_4587 matrixStack = drawContext.method_51448();
        matrixStack.method_22903();
        matrixStack.method_22905(scale, scale, 1.0f);
        if (scale > 1.0f) {
            matrixStack.method_46416(-x / scale, -y / scale, 0.0f);
        } else {
            matrixStack.method_46416(x / scale - x, y * scale - y, 0.0f);
        }
        drawContext.method_51433(theme.getTextRenderer(), text, (int)x, (int)y, ColorUtil.getIntFromColor(color), false);
        matrixStack.method_22909();
    }

    public static void drawStringWithScale(class_332 drawContext, String text, float x, float y, int color, float scale) {
        Theme theme = ThemeManager.getCurrentTheme();
        class_4587 matrixStack = drawContext.method_51448();
        matrixStack.method_22903();
        matrixStack.method_22905(scale, scale, 1.0f);
        if (scale > 1.0f) {
            matrixStack.method_46416(-x / scale, -y / scale, 0.0f);
        } else {
            matrixStack.method_46416(x / scale - x, y * scale - y, 0.0f);
        }
        drawContext.method_51433(theme.getTextRenderer(), text, (int)x, (int)y, color, false);
        matrixStack.method_22909();
    }

    private static void buildFilledArc(class_4588 bufferBuilder, Matrix4f matrix, float x, float y, float radius, float startAngle, float sweepAngle, Color color) {
        double roundedInterval = sweepAngle / radius;
        int colorInt = ColorUtil.getIntFromColor(color);
        int i = 0;
        while ((float)i < radius) {
            double angle = Math.toRadians((double)startAngle + (double)i * roundedInterval);
            double angle2 = Math.toRadians((double)startAngle + (double)(i + 1) * roundedInterval);
            float radiusX1 = (float)(Math.cos(angle) * (double)radius);
            float radiusY1 = (float)(Math.sin(angle) * (double)radius);
            float radiusX2 = (float)(Math.cos(angle2) * (double)radius);
            float radiusY2 = (float)(Math.sin(angle2) * (double)radius);
            bufferBuilder.method_22918(matrix, x, y, 0.0f).method_39415(colorInt);
            bufferBuilder.method_22918(matrix, x + radiusX1, y + radiusY1, 0.0f).method_39415(colorInt);
            bufferBuilder.method_22918(matrix, x + radiusX2, y + radiusY2, 0.0f).method_39415(colorInt);
            ++i;
        }
    }

    private static void buildArc(class_4588 bufferBuilder, Matrix4f matrix, float x, float y, float radius, float startAngle, float sweepAngle, Color color) {
        float roundedInterval = sweepAngle / radius;
        int colorInt = ColorUtil.getIntFromColor(color);
        int i = 0;
        while ((float)i < radius) {
            double angle = Math.toRadians(startAngle + (float)i * roundedInterval);
            float radiusX1 = (float)(Math.cos(angle) * (double)radius);
            float radiusY1 = (float)Math.sin(angle) * radius;
            bufferBuilder.method_22918(matrix, x + radiusX1, y + radiusY1, 0.0f).method_39415(colorInt);
            ++i;
        }
    }
}

