/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.util;

import com.skyblock21.util.TickScheduler;

public class TickSchedulerHelper {
    private static String lastDebounceTaskId = null;

    public static TickScheduler getScheduler() {
        return TickScheduler.getInstance();
    }

    public static String delay(Runnable action, long ticks) {
        return TickSchedulerHelper.getScheduler().scheduleTask(action, ticks);
    }

    public static String repeat(Runnable action, long intervalTicks) {
        return TickSchedulerHelper.getScheduler().scheduleRepeatingTask(action, 0L, intervalTicks);
    }

    public static String repeatWithDelay(Runnable action, long delayTicks, long intervalTicks) {
        return TickSchedulerHelper.getScheduler().scheduleRepeatingTask(action, delayTicks, intervalTicks);
    }

    public static String runNTimes(Runnable action, int times, long intervalTicks) {
        return TickSchedulerHelper.getScheduler().scheduleLimitedTask("limited_" + System.nanoTime(), action, intervalTicks, times);
    }

    public static String delaySeconds(Runnable action, double seconds) {
        return TickSchedulerHelper.getScheduler().scheduleTaskInSeconds(action, seconds);
    }

    public static String everySecond(Runnable action) {
        return TickSchedulerHelper.getScheduler().scheduleRepeatingTask(action, 0L, 20L);
    }

    public static String everySeconds(Runnable action, double seconds) {
        return TickSchedulerHelper.getScheduler().scheduleRepeatingTaskInSeconds(action, 0.0, seconds);
    }

    public static String everySecondsWithDelay(Runnable action, double delaySeconds, double intervalSeconds) {
        return TickSchedulerHelper.getScheduler().scheduleRepeatingTaskInSeconds(action, delaySeconds, intervalSeconds);
    }

    public static String runNTimesSeconds(Runnable action, int times, double intervalSeconds) {
        return TickSchedulerHelper.getScheduler().scheduleLimitedTaskInSeconds("limited_" + System.nanoTime(), action, intervalSeconds, times);
    }

    public static boolean cancel(String taskId) {
        return TickSchedulerHelper.getScheduler().cancelTask(taskId);
    }

    public static void runAfter(Runnable action, long ticks) {
        TickSchedulerHelper.getScheduler().scheduleTask(action, ticks);
    }

    public static void runAfterSeconds(Runnable action, double seconds) {
        TickSchedulerHelper.getScheduler().scheduleTaskInSeconds(action, seconds);
    }

    public static void debounce(Runnable action, long delayTicks) {
        if (lastDebounceTaskId != null) {
            TickSchedulerHelper.getScheduler().cancelTask(lastDebounceTaskId);
        }
        lastDebounceTaskId = TickSchedulerHelper.getScheduler().scheduleTask(action, delayTicks);
    }

    public static void debounceSeconds(Runnable action, double delaySeconds) {
        if (lastDebounceTaskId != null) {
            TickSchedulerHelper.getScheduler().cancelTask(lastDebounceTaskId);
        }
        lastDebounceTaskId = TickSchedulerHelper.getScheduler().scheduleTaskInSeconds(action, delaySeconds);
    }

    public static long getCurrentTick() {
        return TickSchedulerHelper.getScheduler().getCurrentTick();
    }

    public static int getActiveTaskCount() {
        return TickSchedulerHelper.getScheduler().getActiveTaskCount();
    }

    public static void cancelAllTasks() {
        TickSchedulerHelper.getScheduler().cancelAllTasks();
    }
}

