/*
 * Decompiled with CFR 0.152.
 */
package com.skyblock21.util.tab;

import com.skyblock21.Skyblock21;
import com.skyblock21.mixin.accessors.PlayerListHudAccessor;
import com.skyblock21.util.Utils;
import com.skyblock21.util.tab.Widget;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_640;

public class TabUtils {
    private static final Comparator<class_640> ORDER = PlayerListHudAccessor.getEntryOrdering();
    public static Set<Widget> activeWidgets;
    public static Map<Widget, List<String>> widgetLines;

    public static void init() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (!Utils.isOnSkyblock()) {
                return;
            }
            TabUtils.parseTabList();
        });
    }

    public static void parseTabList() {
        try {
            activeWidgets = null;
            widgetLines.clear();
            boolean inInfoColumn = false;
            Widget currentWidget = null;
            class_634 network = class_310.method_1551().method_1562();
            if (network == null) {
                return;
            }
            for (class_640 entry : network.method_2880().stream().sorted(ORDER).toList()) {
                class_2561 displayName = entry.method_2971();
                if (displayName == null) continue;
                String content = displayName.getString();
                String profileName = entry.method_2966().getName();
                if (profileName.endsWith("a") && content.trim().equals("Info")) {
                    inInfoColumn = true;
                    continue;
                }
                if (!inInfoColumn || content.isBlank()) continue;
                if (content.startsWith(" ")) {
                    if (currentWidget == null) continue;
                    widgetLines.get((Object)currentWidget).add(content);
                    continue;
                }
                Widget widget = Widget.byPrefix(content.split(":")[0]);
                if (widget != null) {
                    currentWidget = widget;
                    widgetLines.putIfAbsent(currentWidget, new ArrayList());
                    widgetLines.get((Object)currentWidget).add(content);
                    continue;
                }
                currentWidget = null;
            }
            activeWidgets = widgetLines.keySet();
        }
        catch (Exception e) {
            Skyblock21.LOGGER.warn("Failed to parse tab list", (Throwable)e);
        }
    }

    static {
        widgetLines = new EnumMap<Widget, List<String>>(Widget.class);
    }
}

