/*
 * Decompiled with CFR 0.152.
 */
package cn.mangofanfan.gamehelper.config;

import cn.mangofanfan.tools.file.FFile;
import java.io.IOException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u00182\u00020\u0001:\u0002\u0019\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0003R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\tR\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\fR\u0019\u0010\u000f\u001a\u00070\r\u00a2\u0006\u0002\b\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\"\u0010\u0012\u001a\u00020\u00118\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001a"}, d2={"Lcn/mangofanfan/gamehelper/config/ConfigManager;", "", "<init>", "()V", "", "loadConfig", "saveConfig", "Lorg/slf4j/Logger;", "logger", "Lorg/slf4j/Logger;", "Ljava/nio/file/Path;", "configPath", "Ljava/nio/file/Path;", "Lcn/mangofanfan/tools/file/FFile;", "Lorg/jetbrains/annotations/NotNull;", "configFile", "Lcn/mangofanfan/tools/file/FFile;", "Lcn/mangofanfan/gamehelper/config/ConfigManager$Config;", "config", "Lcn/mangofanfan/gamehelper/config/ConfigManager$Config;", "getConfig", "()Lcn/mangofanfan/gamehelper/config/ConfigManager$Config;", "setConfig", "(Lcn/mangofanfan/gamehelper/config/ConfigManager$Config;)V", "Companion", "Config", "gamehelper"})
public final class ConfigManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    private final Path configPath;
    @NotNull
    private final FFile configFile;
    @NotNull
    private Config config;
    @Nullable
    private static ConfigManager instance;

    public ConfigManager() {
        Logger logger = LoggerFactory.getLogger((String)"GameHelper ConfigManager");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        Path path = FabricLoader.getInstance().getConfigDir().resolve("gamehelper.json");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        this.configPath = path;
        FFile fFile = FFile.of((Path)this.configPath);
        Intrinsics.checkNotNullExpressionValue((Object)fFile, (String)"of(...)");
        this.configFile = fFile;
        this.config = new Config();
    }

    @NotNull
    public final Config getConfig() {
        return this.config;
    }

    public final void setConfig(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"<set-?>");
        this.config = config;
    }

    public final void loadConfig() {
        try {
            Object object = this.configFile.readJson(Config.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readJson(...)");
            this.config = (Config)object;
        }
        catch (Exception exception) {
            this.config = new Config();
            this.saveConfig();
        }
    }

    public final void saveConfig() {
        try {
            this.configFile.writeJson((Object)this.config);
        }
        catch (IOException e) {
            this.logger.error("Exception occurred when saving config !{}", (Object)e.toString());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001e\u0010\u0007\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u0012\u0004\b\t\u0010\u0003\u00a8\u0006\n"}, d2={"Lcn/mangofanfan/gamehelper/config/ConfigManager$Companion;", "", "<init>", "()V", "Lcn/mangofanfan/gamehelper/config/ConfigManager;", "getInstance", "()Lcn/mangofanfan/gamehelper/config/ConfigManager;", "instance", "Lcn/mangofanfan/gamehelper/config/ConfigManager;", "getInstance$annotations", "gamehelper"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getInstance$annotations() {
        }

        @NotNull
        public final ConfigManager getInstance() {
            if (instance == null) {
                instance = new ConfigManager();
                ConfigManager configManager = instance;
                Intrinsics.checkNotNull((Object)configManager);
                configManager.loadConfig();
            }
            ConfigManager configManager = instance;
            Intrinsics.checkNotNull((Object)configManager);
            return configManager;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0013\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\"\u0010\u000b\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\u0006\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR\"\u0010\u000e\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u0006\u001a\u0004\b\u000f\u0010\b\"\u0004\b\u0010\u0010\nR\"\u0010\u0011\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0006\u001a\u0004\b\u0012\u0010\b\"\u0004\b\u0013\u0010\nR\"\u0010\u0014\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\u0006\u001a\u0004\b\u0015\u0010\b\"\u0004\b\u0016\u0010\n\u00a8\u0006\u0017"}, d2={"Lcn/mangofanfan/gamehelper/config/ConfigManager$Config;", "", "<init>", "()V", "", "showGameruleTranslationInGUI", "Z", "getShowGameruleTranslationInGUI", "()Z", "setShowGameruleTranslationInGUI", "(Z)V", "showMoreInfoInGame", "getShowMoreInfoInGame", "setShowMoreInfoInGame", "recordDeathPosition", "getRecordDeathPosition", "setRecordDeathPosition", "enableGameRulesManager", "getEnableGameRulesManager", "setEnableGameRulesManager", "disableGameRulesForAnyone", "getDisableGameRulesForAnyone", "setDisableGameRulesForAnyone", "gamehelper"})
    public static final class Config {
        private boolean showGameruleTranslationInGUI;
        private boolean showMoreInfoInGame = true;
        private boolean recordDeathPosition = true;
        private boolean enableGameRulesManager = true;
        private boolean disableGameRulesForAnyone = true;

        public final boolean getShowGameruleTranslationInGUI() {
            return this.showGameruleTranslationInGUI;
        }

        public final void setShowGameruleTranslationInGUI(boolean bl) {
            this.showGameruleTranslationInGUI = bl;
        }

        public final boolean getShowMoreInfoInGame() {
            return this.showMoreInfoInGame;
        }

        public final void setShowMoreInfoInGame(boolean bl) {
            this.showMoreInfoInGame = bl;
        }

        public final boolean getRecordDeathPosition() {
            return this.recordDeathPosition;
        }

        public final void setRecordDeathPosition(boolean bl) {
            this.recordDeathPosition = bl;
        }

        public final boolean getEnableGameRulesManager() {
            return this.enableGameRulesManager;
        }

        public final void setEnableGameRulesManager(boolean bl) {
            this.enableGameRulesManager = bl;
        }

        public final boolean getDisableGameRulesForAnyone() {
            return this.disableGameRulesForAnyone;
        }

        public final void setDisableGameRulesForAnyone(boolean bl) {
            this.disableGameRulesForAnyone = bl;
        }
    }
}

