/*
 * Decompiled with CFR 0.152.
 */
package cn.mangofanfan.gamehelper.data;

import cn.mangofanfan.gamehelper.data.DeathPositionData;
import cn.mangofanfan.gamehelper.packet.PlayerDeathSyncS2CPayload;
import cn.mangofanfan.tools.file.FDirectory;
import cn.mangofanfan.tools.file.FFile;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2338;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0001'B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ%\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0011\u0010\nR$\u0010\u0013\u001a\u0004\u0018\u00010\u00128\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R$\u0010\u0019\u001a\u0004\u0018\u00010\u00128\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u0014\u001a\u0004\b\u001a\u0010\u0016\"\u0004\b\u001b\u0010\u0018R\u0014\u0010\u001d\u001a\u00020\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR.\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020 0\u001f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&\u00a8\u0006("}, d2={"Lcn/mangofanfan/gamehelper/data/DeathPositionDataManager;", "", "Lnet/minecraft/server/MinecraftServer;", "server", "<init>", "(Lnet/minecraft/server/MinecraftServer;)V", "Lnet/minecraft/class_3222;", "player", "", "readOrCreatePlayerDeathPositionData", "(Lnet/minecraft/class_3222;)V", "Lnet/minecraft/class_2338;", "pos", "", "world", "addDeathPosition", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_2338;Ljava/lang/String;)V", "sendSyncPacket", "Lcn/mangofanfan/tools/file/FDirectory;", "saveDirectory", "Lcn/mangofanfan/tools/file/FDirectory;", "getSaveDirectory", "()Lcn/mangofanfan/tools/file/FDirectory;", "setSaveDirectory", "(Lcn/mangofanfan/tools/file/FDirectory;)V", "deathPositionDirectory", "getDeathPositionDirectory", "setDeathPositionDirectory", "Lorg/slf4j/Logger;", "logger", "Lorg/slf4j/Logger;", "", "Lcn/mangofanfan/gamehelper/data/DeathPositionData;", "dataMap", "Ljava/util/Map;", "getDataMap", "()Ljava/util/Map;", "setDataMap", "(Ljava/util/Map;)V", "Companion", "gamehelper"})
public final class DeathPositionDataManager {
    @Nullable
    private FDirectory saveDirectory;
    @Nullable
    private FDirectory deathPositionDirectory;
    @NotNull
    private final Logger logger;
    @NotNull
    private Map<String, DeathPositionData> dataMap;

    public DeathPositionDataManager(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Logger logger = LoggerFactory.getLogger((String)"DeathPositionDataManager");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        this.dataMap = new LinkedHashMap();
        FDirectory fDirectory = this.saveDirectory = FDirectory.of((String)((Object)server.method_27050(class_5218.field_24188)).toString());
        Intrinsics.checkNotNull((Object)fDirectory);
        this.deathPositionDirectory = fDirectory.createSubDirectory("fan_mod_data", true).createSubDirectory("death", true);
    }

    @Nullable
    public final FDirectory getSaveDirectory() {
        return this.saveDirectory;
    }

    public final void setSaveDirectory(@Nullable FDirectory fDirectory) {
        this.saveDirectory = fDirectory;
    }

    @Nullable
    public final FDirectory getDeathPositionDirectory() {
        return this.deathPositionDirectory;
    }

    public final void setDeathPositionDirectory(@Nullable FDirectory fDirectory) {
        this.deathPositionDirectory = fDirectory;
    }

    @NotNull
    public final Map<String, DeathPositionData> getDataMap() {
        return this.dataMap;
    }

    public final void setDataMap(@NotNull Map<String, DeathPositionData> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.dataMap = map;
    }

    public final void readOrCreatePlayerDeathPositionData(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        FDirectory fDirectory = this.deathPositionDirectory;
        Intrinsics.checkNotNull((Object)fDirectory);
        FFile file = fDirectory.getSubFile(player.method_5667().toString() + ".json");
        DeathPositionData playerData = null;
        if (file.isExited()) {
            playerData = (DeathPositionData)file.readJson(DeathPositionData.class);
        } else {
            playerData = new DeathPositionData();
            String string = player.method_5667().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            playerData.setUuid(string);
            file.create();
            file.writeJson((Object)playerData);
        }
        this.dataMap.put(player.method_5667().toString(), playerData);
        this.logger.debug("readOrCreatePlayerDeathPositionData: {} ({})", (Object)player.method_5477().toString(), (Object)player.method_5667().toString());
    }

    public final void addDeathPosition(@NotNull class_3222 player, @NotNull class_2338 pos, @NotNull String world) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        DeathPositionData deathPositionData = this.dataMap.get(player.method_5667().toString());
        Intrinsics.checkNotNull((Object)deathPositionData);
        DeathPositionData playerData = deathPositionData;
        playerData.addDeathPosition(pos, world);
        FDirectory fDirectory = this.deathPositionDirectory;
        Intrinsics.checkNotNull((Object)fDirectory);
        FFile file = fDirectory.getSubFile(player.method_5667().toString() + ".json");
        if (!file.isExited()) {
            throw new RuntimeException("Player deathPositionData json file [ " + file + " ] not found.");
        }
        file.writeJson((Object)playerData);
        this.logger.debug("addDeathPosition: {} ({})", (Object)player.method_5477().toString(), (Object)player.method_5667().toString());
    }

    public final void sendSyncPacket(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        DeathPositionData deathPositionData = this.dataMap.get(player.method_5667().toString());
        Intrinsics.checkNotNull((Object)deathPositionData);
        Iterator<DeathPositionData.DeathPosition> iterator = deathPositionData.getPositionList().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<DeathPositionData.DeathPosition> iterator2 = iterator;
        while (iterator2.hasNext()) {
            DeathPositionData.DeathPosition dp;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            Integer n = dp.getX();
            Intrinsics.checkNotNull((Object)n);
            int n2 = n;
            Integer n3 = dp.getY();
            Intrinsics.checkNotNull((Object)n3);
            int n4 = n3;
            Integer n5 = dp.getZ();
            Intrinsics.checkNotNull((Object)n5);
            int n6 = n5;
            String string = dp.getWorld();
            Intrinsics.checkNotNull((Object)string);
            ServerPlayNetworking.send((class_3222)player, (class_8710)new PlayerDeathSyncS2CPayload(n2, n4, n6, string));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u0003R$\u0010\u000b\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcn/mangofanfan/gamehelper/data/DeathPositionDataManager$Companion;", "", "<init>", "()V", "Lnet/minecraft/server/MinecraftServer;", "server", "Lcn/mangofanfan/gamehelper/data/DeathPositionDataManager;", "create", "(Lnet/minecraft/server/MinecraftServer;)Lcn/mangofanfan/gamehelper/data/DeathPositionDataManager;", "", "stop", "instance", "Lcn/mangofanfan/gamehelper/data/DeathPositionDataManager;", "getInstance", "()Lcn/mangofanfan/gamehelper/data/DeathPositionDataManager;", "setInstance", "(Lcn/mangofanfan/gamehelper/data/DeathPositionDataManager;)V", "gamehelper"})
    public static final class Companion {
        @NotNull
        public static final Companion INSTANCE = new Companion();
        @Nullable
        private static DeathPositionDataManager instance;

        private Companion() {
        }

        @Nullable
        public final DeathPositionDataManager getInstance() {
            return instance;
        }

        public final void setInstance(@Nullable DeathPositionDataManager deathPositionDataManager) {
            instance = deathPositionDataManager;
        }

        @NotNull
        public final DeathPositionDataManager create(@NotNull MinecraftServer server) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            if (instance == null) {
                instance = new DeathPositionDataManager(server);
            }
            DeathPositionDataManager deathPositionDataManager = instance;
            Intrinsics.checkNotNull((Object)deathPositionDataManager);
            return deathPositionDataManager;
        }

        public final void stop() {
            instance = null;
        }
    }
}

