/*
 * Decompiled with CFR 0.152.
 */
package cn.mangofanfan.gamehelper;

import cn.mangofanfan.gamehelper.config.ConfigManager;
import cn.mangofanfan.gamehelper.data.DeathPositionDataManager;
import cn.mangofanfan.gamehelper.gamerules.GameRulesManager;
import cn.mangofanfan.gamehelper.packet.PlayerDeathS2CPayload;
import cn.mangofanfan.gamehelper.packet.PlayerDeathSyncS2CPayload;
import cn.mangofanfan.gamehelper.packet.RequestGameruleC2SPayload;
import cn.mangofanfan.gamehelper.packet.RequestResyncDeathPositionsC2SPayload;
import cn.mangofanfan.gamehelper.packet.ResponseGameruleBooleanS2CPayload;
import cn.mangofanfan.gamehelper.packet.ResponseGameruleIntS2CPayload;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1928;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u001f\u0010\n\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\n\u0010\u000bR\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR\u0014\u0010\u0010\u001a\u00020\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcn/mangofanfan/gamehelper/GameHelper;", "Lnet/fabricmc/api/ModInitializer;", "<init>", "()V", "", "onInitialize", "Lnet/minecraft/class_3222;", "entity", "Lnet/minecraft/class_1282;", "damageSource", "handlePlayerDeath", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_1282;)V", "Lorg/slf4j/Logger;", "logger", "Lorg/slf4j/Logger;", "Lcn/mangofanfan/gamehelper/config/ConfigManager;", "configManager", "Lcn/mangofanfan/gamehelper/config/ConfigManager;", "gamehelper"})
public final class GameHelper
implements ModInitializer {
    @NotNull
    private final Logger logger;
    @NotNull
    private final ConfigManager configManager;

    public GameHelper() {
        Logger logger = LoggerFactory.getLogger((String)"GameHelper");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        this.configManager = ConfigManager.Companion.getInstance();
    }

    public void onInitialize() {
        ServerLifecycleEvents.SERVER_STARTED.register(GameHelper::onInitialize$lambda$0);
        ServerLifecycleEvents.SERVER_STOPPING.register(GameHelper::onInitialize$lambda$1);
        ServerPlayerEvents.JOIN.register(GameHelper::onInitialize$lambda$2);
        ServerLivingEntityEvents.AFTER_DEATH.register((arg_0, arg_1) -> GameHelper.onInitialize$lambda$3(this, arg_0, arg_1));
        PayloadTypeRegistry.playS2C().register(PlayerDeathS2CPayload.Companion.INSTANCE.getId(), PlayerDeathS2CPayload.Companion.INSTANCE.getCODEC());
        PayloadTypeRegistry.playS2C().register(PlayerDeathSyncS2CPayload.Companion.INSTANCE.getId(), PlayerDeathSyncS2CPayload.Companion.INSTANCE.getCODEC());
        PayloadTypeRegistry.playC2S().register(RequestResyncDeathPositionsC2SPayload.INSTANCE.getID(), RequestResyncDeathPositionsC2SPayload.INSTANCE.getCODEC());
        PayloadTypeRegistry.playC2S().register(RequestGameruleC2SPayload.Companion.INSTANCE.getId(), RequestGameruleC2SPayload.Companion.INSTANCE.getCODEC());
        PayloadTypeRegistry.playS2C().register(ResponseGameruleBooleanS2CPayload.Companion.INSTANCE.getId(), ResponseGameruleBooleanS2CPayload.Companion.INSTANCE.getCODEC());
        PayloadTypeRegistry.playS2C().register(ResponseGameruleIntS2CPayload.Companion.INSTANCE.getId(), ResponseGameruleIntS2CPayload.Companion.INSTANCE.getCODEC());
        ServerPlayNetworking.registerGlobalReceiver(RequestResyncDeathPositionsC2SPayload.INSTANCE.getID(), (arg_0, arg_1) -> GameHelper.onInitialize$lambda$4(this, arg_0, arg_1));
        ServerPlayNetworking.registerGlobalReceiver(RequestGameruleC2SPayload.Companion.INSTANCE.getId(), (arg_0, arg_1) -> GameHelper.onInitialize$lambda$5(this, arg_0, arg_1));
    }

    private final void handlePlayerDeath(class_3222 entity, class_1282 damageSource) {
        this.logger.info("Player " + entity.method_5477() + " died at " + entity.method_24515() + " because of " + damageSource.method_5525() + ".");
        if (this.configManager.getConfig().getRecordDeathPosition()) {
            class_2338 class_23382 = entity.method_24515();
            Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"getBlockPos(...)");
            String string = entity.method_51469().method_27983().method_29177().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            ServerPlayNetworking.send((class_3222)entity, (class_8710)new PlayerDeathS2CPayload(class_23382, string));
            DeathPositionDataManager deathPositionDataManager = DeathPositionDataManager.Companion.INSTANCE.getInstance();
            Intrinsics.checkNotNull((Object)deathPositionDataManager);
            class_2338 class_23383 = entity.method_24515();
            Intrinsics.checkNotNullExpressionValue((Object)class_23383, (String)"getBlockPos(...)");
            String string2 = entity.method_51469().method_27983().method_29177().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            deathPositionDataManager.addDeathPosition(entity, class_23383, string2);
        } else {
            this.logger.info("According to config, death position is not recorded.");
        }
    }

    private static final void onInitialize$lambda$0(MinecraftServer server) {
        Intrinsics.checkNotNull((Object)server);
        DeathPositionDataManager.Companion.INSTANCE.create(server);
        class_1928 class_19282 = server.method_3767();
        Intrinsics.checkNotNullExpressionValue((Object)class_19282, (String)"getGameRules(...)");
        GameRulesManager.Builder.INSTANCE.build(class_19282);
    }

    private static final void onInitialize$lambda$1(MinecraftServer it) {
        DeathPositionDataManager.Companion.INSTANCE.stop();
        GameRulesManager.Builder.INSTANCE.delete();
    }

    private static final void onInitialize$lambda$2(class_3222 player) {
        DeathPositionDataManager deathPositionDataManager = DeathPositionDataManager.Companion.INSTANCE.getInstance();
        Intrinsics.checkNotNull((Object)deathPositionDataManager);
        Intrinsics.checkNotNull((Object)player);
        deathPositionDataManager.readOrCreatePlayerDeathPositionData(player);
    }

    private static final void onInitialize$lambda$3(GameHelper this$0, class_1309 entity, class_1282 damageSource) {
        if (entity.method_31747()) {
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.server.network.ServerPlayerEntity");
            class_3222 class_32222 = (class_3222)entity;
            Intrinsics.checkNotNull((Object)damageSource);
            this$0.handlePlayerDeath(class_32222, damageSource);
        }
    }

    private static final void onInitialize$lambda$4(GameHelper this$0, RequestResyncDeathPositionsC2SPayload requestResyncDeathPositionsC2SPayload, ServerPlayNetworking.Context context) {
        if (this$0.configManager.getConfig().getRecordDeathPosition()) {
            DeathPositionDataManager deathPositionDataManager = DeathPositionDataManager.Companion.INSTANCE.getInstance();
            Intrinsics.checkNotNull((Object)deathPositionDataManager);
            class_3222 class_32222 = context.player();
            Intrinsics.checkNotNullExpressionValue((Object)class_32222, (String)"player(...)");
            deathPositionDataManager.sendSyncPacket(class_32222);
        }
    }

    private static final void onInitialize$lambda$5(GameHelper this$0, RequestGameruleC2SPayload payload, ServerPlayNetworking.Context context) {
        if (this$0.configManager.getConfig().getEnableGameRulesManager()) {
            if (this$0.configManager.getConfig().getDisableGameRulesForAnyone() && context.player().method_5691() < 2) {
                context.player().method_64398((class_2561)class_2561.method_43471((String)"gamehelper.message.permission_denied").method_54663(-256));
                return;
            }
            GameRulesManager gameRulesManager = GameRulesManager.Builder.INSTANCE.getInstance();
            Intrinsics.checkNotNull((Object)gameRulesManager);
            GameRulesManager manager = gameRulesManager;
            class_3222 class_32222 = context.player();
            Intrinsics.checkNotNullExpressionValue((Object)class_32222, (String)"player(...)");
            String string = payload.getGameruleName();
            Intrinsics.checkNotNull((Object)string);
            manager.respond(class_32222, string);
            this$0.logger.info(context.player().method_5477() + " requested gamerule " + payload.getGameruleName() + ".");
        }
    }
}

