/*
 * Decompiled with CFR 0.152.
 */
package cn.mangofanfan.gamehelper.client;

import cn.mangofanfan.gamehelper.client.handler.GameRulesHandler;
import cn.mangofanfan.gamehelper.client.handler.PlayerDeathHandler;
import cn.mangofanfan.gamehelper.client.screen.config.ClientStatus;
import cn.mangofanfan.gamehelper.client.screen.ingame.HelperDescription;
import cn.mangofanfan.gamehelper.client.screen.ingame.libgui.InGameScreen;
import cn.mangofanfan.gamehelper.packet.PlayerDeathS2CPayload;
import cn.mangofanfan.gamehelper.packet.PlayerDeathSyncS2CPayload;
import cn.mangofanfan.gamehelper.packet.ResponseGameruleBooleanS2CPayload;
import cn.mangofanfan.gamehelper.packet.ResponseGameruleIntS2CPayload;
import io.github.cottonmc.cotton.gui.GuiDescription;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_634;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\bR\u001c\u0010\u000b\u001a\n \n*\u0004\u0018\u00010\t0\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcn/mangofanfan/gamehelper/client/GameHelperClient;", "Lnet/fabricmc/api/ClientModInitializer;", "<init>", "()V", "", "onInitializeClient", "Lorg/slf4j/Logger;", "logger", "Lorg/slf4j/Logger;", "Lnet/minecraft/class_304;", "kotlin.jvm.PlatformType", "keyBinding", "Lnet/minecraft/class_304;", "gamehelper_client"})
@Environment(value=EnvType.CLIENT)
public final class GameHelperClient
implements ClientModInitializer {
    @NotNull
    private final Logger logger;
    private final class_304 keyBinding;

    public GameHelperClient() {
        Logger logger = LoggerFactory.getLogger((String)"GamehelperClient");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        this.keyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.gamehelper.open_screen", class_3675.class_307.field_1668, 72, class_304.class_11900.field_62558));
    }

    public void onInitializeClient() {
        ClientStatus.INSTANCE.setClothConfigLoaded(FabricLoader.getInstance().isModLoaded("cloth-config"));
        if (!ClientStatus.INSTANCE.isClothConfigLoaded()) {
            this.logger.error("Cloth Config is not loaded, please install Cloth Config to use this mod.");
        }
        ClientTickEvents.END_CLIENT_TICK.register(arg_0 -> GameHelperClient.onInitializeClient$lambda$0(this, arg_0));
        ClientPlayConnectionEvents.JOIN.register((arg_0, arg_1, arg_2) -> GameHelperClient.onInitializeClient$lambda$1(this, arg_0, arg_1, arg_2));
        ClientPlayConnectionEvents.DISCONNECT.register(GameHelperClient::onInitializeClient$lambda$2);
        this.logger.info("GamehelperClient init");
    }

    private static final void onInitializeClient$lambda$0(GameHelperClient this$0, class_310 it) {
        while (this$0.keyBinding.method_1436()) {
            it.method_1507((class_437)new InGameScreen((GuiDescription)new HelperDescription(it.field_1755), it.field_1755));
        }
    }

    private static final void onInitializeClient$lambda$1(GameHelperClient this$0, class_634 class_6342, PacketSender packetSender, class_310 class_3102) {
        PlayerDeathHandler.Companion.INSTANCE.build();
        GameRulesHandler.Companion.INSTANCE.build((MinecraftServer)class_310.method_1551().method_1576());
        ClientPlayNetworking.registerReceiver(PlayerDeathS2CPayload.Companion.INSTANCE.getId(), (arg_0, arg_1) -> GameHelperClient.onInitializeClient$lambda$1$0(this$0, arg_0, arg_1));
        ClientPlayNetworking.registerReceiver(PlayerDeathSyncS2CPayload.Companion.INSTANCE.getId(), (arg_0, arg_1) -> GameHelperClient.onInitializeClient$lambda$1$1(this$0, arg_0, arg_1));
        ClientPlayNetworking.registerReceiver(ResponseGameruleBooleanS2CPayload.Companion.INSTANCE.getId(), (arg_0, arg_1) -> GameHelperClient.onInitializeClient$lambda$1$2(this$0, arg_0, arg_1));
        ClientPlayNetworking.registerReceiver(ResponseGameruleIntS2CPayload.Companion.INSTANCE.getId(), (arg_0, arg_1) -> GameHelperClient.onInitializeClient$lambda$1$3(this$0, arg_0, arg_1));
    }

    private static final void onInitializeClient$lambda$1$0(GameHelperClient this$0, PlayerDeathS2CPayload payload, ClientPlayNetworking.Context context) {
        this$0.logger.info("Received PlayerDeathS2CPayload: " + payload.getWorld() + "(" + payload.getPos().method_10263() + ", " + payload.getPos().method_10264() + ", " + payload.getPos().method_10260() + ")");
        Object[] objectArray = new Object[]{payload.getWorld(), payload.getPos().method_10263(), payload.getPos().method_10264(), payload.getPos().method_10260()};
        context.player().method_7353((class_2561)class_2561.method_43469((String)"gamehelper.message.death_position_text", (Object[])objectArray).method_54663(-256), false);
        context.player().method_7353((class_2561)class_2561.method_43471((String)"gamehelper.message.death_position_tp").method_27694(arg_0 -> GameHelperClient.onInitializeClient$lambda$1$0$0(payload, arg_0)), false);
        PlayerDeathHandler playerDeathHandler = PlayerDeathHandler.Companion.instance;
        Intrinsics.checkNotNull((Object)playerDeathHandler);
        playerDeathHandler.addDeathPos(payload.getPos(), payload.getWorld());
    }

    private static final class_2583 onInitializeClient$lambda$1$0$0(PlayerDeathS2CPayload $payload, class_2583 style) {
        return style.method_36139(-16711936).method_30938(Boolean.valueOf(true)).method_10958((class_2558)new class_2558.class_10609("/execute in " + $payload.getWorld() + " run tp " + $payload.getPos().method_10263() + " " + $payload.getPos().method_10264() + " " + $payload.getPos().method_10260())).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43471((String)"gamehelper.screen.death_position.tp.description")));
    }

    private static final void onInitializeClient$lambda$1$1(GameHelperClient this$0, PlayerDeathSyncS2CPayload payload, ClientPlayNetworking.Context context) {
        Object[] objectArray = new Object[]{payload.getWorld(), payload.getX(), payload.getY(), payload.getZ()};
        this$0.logger.debug("Received PlayerDeathSyncS2CPayload: {}({}, {}, {})", objectArray);
        PlayerDeathHandler.Companion.INSTANCE.getInstance().addDeathPos(payload.getX(), payload.getY(), payload.getZ(), payload.getWorld());
    }

    private static final void onInitializeClient$lambda$1$2(GameHelperClient this$0, ResponseGameruleBooleanS2CPayload payload, ClientPlayNetworking.Context context) {
        GameRulesHandler.Companion.INSTANCE.getInstance().updateGameRuleInMultiPlayer(payload.getGameruleName(), payload.getValue(), payload.getTranslationKey());
        this$0.logger.debug("Received ResponseGameruleBooleanS2CPayload: " + payload.getGameruleName() + "=" + payload.getValue());
    }

    private static final void onInitializeClient$lambda$1$3(GameHelperClient this$0, ResponseGameruleIntS2CPayload payload, ClientPlayNetworking.Context context) {
        GameRulesHandler.Companion.INSTANCE.getInstance().updateGameRuleInMultiPlayer(payload.getGameruleName(), payload.getValue(), payload.getTranslationKey());
        this$0.logger.debug("Received ResponseGameruleIntS2CPayload: " + payload.getGameruleName() + "=" + payload.getValue());
    }

    private static final void onInitializeClient$lambda$2(class_634 class_6342, class_310 class_3102) {
        PlayerDeathHandler.Companion.INSTANCE.delete();
        GameRulesHandler.Companion.INSTANCE.delete();
    }
}

