/*
 * Decompiled with CFR 0.152.
 */
package cn.mangofanfan.gamehelper.client.handler;

import cn.mangofanfan.gamehelper.config.ConfigManager;
import cn.mangofanfan.gamehelper.packet.RequestGameruleC2SPayload;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1928;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_746;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001:\u0003567B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\u0005J\r\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\f\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ%\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\n\u00a2\u0006\u0004\b\u0012\u0010\u0013J%\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\n\u00a2\u0006\u0004\b\u0012\u0010\u0015J\u001d\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001d\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0017R\u0019\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR#\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001d0\u001c8\u0006\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!R#\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\"0\u001c8\u0006\u00a2\u0006\f\n\u0004\b#\u0010\u001f\u001a\u0004\b$\u0010!R\u0014\u0010&\u001a\u00020%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u0014\u0010)\u001a\u00020(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u0014\u0010,\u001a\u00020+8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u0017\u0010.\u001a\u00020\u000f8\u0006\u00a2\u0006\f\n\u0004\b.\u0010/\u001a\u0004\b.\u00100R\u001c\u00103\u001a\n 2*\u0004\u0018\u000101018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u00104\u00a8\u00068"}, d2={"Lcn/mangofanfan/gamehelper/client/handler/GameRulesHandler;", "", "Lnet/minecraft/server/MinecraftServer;", "server", "<init>", "(Lnet/minecraft/server/MinecraftServer;)V", "", "updateGameRulesInSinglePlayer", "requestGameRulesInMultiPlayer", "()V", "", "gameruleName", "requestGameRuleInMultiPlayer", "(Ljava/lang/String;)V", "ruleName", "", "value", "translationKey", "updateGameRuleInMultiPlayer", "(Ljava/lang/String;ZLjava/lang/String;)V", "", "(Ljava/lang/String;ILjava/lang/String;)V", "changeGameRule", "(Ljava/lang/String;Ljava/lang/Object;)V", "runGameRuleCommand", "Lnet/minecraft/server/MinecraftServer;", "getServer", "()Lnet/minecraft/server/MinecraftServer;", "", "Lcn/mangofanfan/gamehelper/client/handler/GameRulesHandler$BooleanRuleData;", "booleanRuleMap", "Ljava/util/Map;", "getBooleanRuleMap", "()Ljava/util/Map;", "Lcn/mangofanfan/gamehelper/client/handler/GameRulesHandler$IntRuleData;", "intRuleMap", "getIntRuleMap", "Lnet/minecraft/class_310;", "client", "Lnet/minecraft/class_310;", "Lorg/slf4j/Logger;", "logger", "Lorg/slf4j/Logger;", "Lcn/mangofanfan/gamehelper/config/ConfigManager;", "configManager", "Lcn/mangofanfan/gamehelper/config/ConfigManager;", "isMultiplayer", "Z", "()Z", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "EXECUTOR", "Ljava/util/concurrent/ExecutorService;", "IntRuleData", "BooleanRuleData", "Companion", "gamehelper_client"})
@Environment(value=EnvType.CLIENT)
public final class GameRulesHandler {
    @Nullable
    private final MinecraftServer server;
    @NotNull
    private final Map<String, BooleanRuleData> booleanRuleMap;
    @NotNull
    private final Map<String, IntRuleData> intRuleMap;
    @NotNull
    private final class_310 client;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ConfigManager configManager;
    private final boolean isMultiplayer;
    private final ExecutorService EXECUTOR;

    public GameRulesHandler(@Nullable MinecraftServer server) {
        this.server = server;
        this.booleanRuleMap = new LinkedHashMap();
        this.intRuleMap = new LinkedHashMap();
        class_310 class_3102 = class_310.method_1551();
        Intrinsics.checkNotNull((Object)class_3102);
        this.client = class_3102;
        Logger logger = LoggerFactory.getLogger(GameRulesHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        this.configManager = ConfigManager.Companion.getInstance();
        this.isMultiplayer = this.server == null;
        this.EXECUTOR = Executors.newSingleThreadExecutor();
        if (this.server == null && !this.client.method_1542()) {
            this.requestGameRulesInMultiPlayer();
            this.logger.info("GameRulesHandler init in multiplayer");
            if (this.configManager.getConfig().getShowMoreInfoInGame()) {
                class_746 class_7462 = this.client.field_1724;
                Intrinsics.checkNotNull((Object)class_7462);
                class_7462.method_7353((class_2561)class_2561.method_43471((String)"gamehelper.message.gamerules_handler.init.server.1"), false);
                class_746 class_7463 = this.client.field_1724;
                Intrinsics.checkNotNull((Object)class_7463);
                class_7463.method_7353((class_2561)class_2561.method_43471((String)"gamehelper.message.gamerules_handler.init.server.2"), false);
                class_746 class_7464 = this.client.field_1724;
                Intrinsics.checkNotNull((Object)class_7464);
                class_7464.method_7353((class_2561)class_2561.method_43471((String)"gamehelper.message.gamerules_handler.init.server.3"), false);
            }
        } else if (this.server != null && this.client.method_1542()) {
            this.updateGameRulesInSinglePlayer(this.server);
            this.logger.info("GameRulesHandler init in singleplayer");
            if (this.configManager.getConfig().getShowMoreInfoInGame()) {
                class_746 class_7465 = this.client.field_1724;
                Intrinsics.checkNotNull((Object)class_7465);
                class_7465.method_7353((class_2561)class_2561.method_43471((String)"gamehelper.message.gamerules_handler.init.client.1"), false);
                class_746 class_7466 = this.client.field_1724;
                Intrinsics.checkNotNull((Object)class_7466);
                class_7466.method_7353((class_2561)class_2561.method_43471((String)"gamehelper.message.gamerules_handler.init.client.2"), false);
                class_746 class_7467 = this.client.field_1724;
                Intrinsics.checkNotNull((Object)class_7467);
                class_7467.method_7353((class_2561)class_2561.method_43471((String)"gamehelper.message.gamerules_handler.init.client.3"), false);
            }
        } else {
            this.logger.error("GameRulesHandler init error");
            throw new RuntimeException("Unknown running environment: MinecraftClient.getInstance().isInSingleplayer =" + this.client.method_1542() + " server = " + this.server);
        }
    }

    @Nullable
    public final MinecraftServer getServer() {
        return this.server;
    }

    @NotNull
    public final Map<String, BooleanRuleData> getBooleanRuleMap() {
        return this.booleanRuleMap;
    }

    @NotNull
    public final Map<String, IntRuleData> getIntRuleMap() {
        return this.intRuleMap;
    }

    public final boolean isMultiplayer() {
        return this.isMultiplayer;
    }

    public final void updateGameRulesInSinglePlayer(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        server.method_3767().method_20744(new class_1928.class_4311(server, this){
            final /* synthetic */ MinecraftServer $server;
            final /* synthetic */ GameRulesHandler this$0;
            {
                this.$server = $server;
                this.this$0 = $receiver;
            }

            public void method_27330(class_1928.class_4313<class_1928.class_4312> key, class_1928.class_4314<class_1928.class_4312> type) {
                Intrinsics.checkNotNullParameter(key, (String)"key");
                Intrinsics.checkNotNullParameter(type, (String)"type");
                int value = this.$server.method_3767().method_8356(key);
                Map<String, IntRuleData> map = this.this$0.getIntRuleMap();
                String string = key.method_20771();
                String string2 = key.method_27334();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getTranslationKey(...)");
                IntRuleData intRuleData = new IntRuleData(string2, value);
                map.put(string, intRuleData);
                GameRulesHandler.access$getLogger$p(this.this$0).debug("GameRules IntRule " + key.method_20771() + ": " + value);
            }

            public void method_27329(class_1928.class_4313<class_1928.class_4310> key, class_1928.class_4314<class_1928.class_4310> type) {
                Intrinsics.checkNotNullParameter(key, (String)"key");
                Intrinsics.checkNotNullParameter(type, (String)"type");
                boolean value = this.$server.method_3767().method_8355(key);
                Map<String, BooleanRuleData> map = this.this$0.getBooleanRuleMap();
                String string = key.method_20771();
                String string2 = key.method_27334();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getTranslationKey(...)");
                BooleanRuleData booleanRuleData = new BooleanRuleData(string2, value);
                map.put(string, booleanRuleData);
                GameRulesHandler.access$getLogger$p(this.this$0).debug("GameRules BooleanRule " + key.method_20771() + ": " + value);
            }
        });
    }

    public final void requestGameRulesInMultiPlayer() {
        ClientPlayNetworking.send((class_8710)new RequestGameruleC2SPayload("ALL"));
        this.logger.debug("Sent RequestGameruleC2SPayload(ALL)");
        if (this.configManager.getConfig().getShowMoreInfoInGame()) {
            class_746 class_7462 = this.client.field_1724;
            Intrinsics.checkNotNull((Object)class_7462);
            class_7462.method_7353((class_2561)class_2561.method_43471((String)"gamehelper.message.gamerules_handler.run.request_gamerules_server"), false);
        }
        CompletableFuture.supplyAsync(() -> GameRulesHandler.requestGameRulesInMultiPlayer$lambda$0(this), this.EXECUTOR).thenAcceptAsync(arg_0 -> GameRulesHandler.requestGameRulesInMultiPlayer$lambda$2(arg_0 -> GameRulesHandler.requestGameRulesInMultiPlayer$lambda$1(this, arg_0), arg_0), (Executor)this.EXECUTOR);
    }

    public final void requestGameRuleInMultiPlayer(@NotNull String gameruleName) {
        Intrinsics.checkNotNullParameter((Object)gameruleName, (String)"gameruleName");
        ClientPlayNetworking.send((class_8710)new RequestGameruleC2SPayload(gameruleName));
        this.logger.debug("Sent RequestGameruleC2SPayload(" + gameruleName + ")");
    }

    public final void updateGameRuleInMultiPlayer(@NotNull String ruleName, boolean value, @NotNull String translationKey) {
        Intrinsics.checkNotNullParameter((Object)ruleName, (String)"ruleName");
        Intrinsics.checkNotNullParameter((Object)translationKey, (String)"translationKey");
        this.booleanRuleMap.put(ruleName, new BooleanRuleData(translationKey, value));
    }

    public final void updateGameRuleInMultiPlayer(@NotNull String ruleName, int value, @NotNull String translationKey) {
        Intrinsics.checkNotNullParameter((Object)ruleName, (String)"ruleName");
        Intrinsics.checkNotNullParameter((Object)translationKey, (String)"translationKey");
        this.intRuleMap.put(ruleName, new IntRuleData(translationKey, value));
    }

    public final void changeGameRule(@NotNull String ruleName, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)ruleName, (String)"ruleName");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value;
        if (object instanceof Boolean) {
            BooleanRuleData booleanRuleData = this.booleanRuleMap.get(ruleName);
            if (booleanRuleData != null) {
                booleanRuleData.setValue((Boolean)value);
            }
            System.out.println((Object)ruleName);
            this.runGameRuleCommand(ruleName, value);
        } else if (object instanceof Integer) {
            IntRuleData intRuleData = this.intRuleMap.get(ruleName);
            if (intRuleData != null) {
                intRuleData.setValue(((Number)value).intValue());
            }
            System.out.println((Object)ruleName);
            this.runGameRuleCommand(ruleName, value);
        } else {
            throw new RuntimeException("Unknown game rule value type: " + value);
        }
        if (this.server != null) {
            this.requestGameRuleInMultiPlayer(ruleName);
        }
        this.logger.info("Change gamerule " + ruleName + " to " + value);
    }

    public final void runGameRuleCommand(@NotNull String ruleName, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)ruleName, (String)"ruleName");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        class_634 class_6342 = this.client.method_1562();
        Intrinsics.checkNotNull((Object)class_6342);
        class_6342.method_45730("gamerule " + ruleName + " " + value);
    }

    private static final Boolean requestGameRulesInMultiPlayer$lambda$0(GameRulesHandler this$0) {
        Thread.sleep(5000L);
        return !this$0.booleanRuleMap.isEmpty() && !this$0.intRuleMap.isEmpty();
    }

    private static final Unit requestGameRulesInMultiPlayer$lambda$1(GameRulesHandler this$0, Boolean success) {
        if (!success.booleanValue()) {
            this$0.logger.warn("Request gamerules timeout. Your server may not have GameHelper mod installed.");
            class_746 class_7462 = this$0.client.field_1724;
            Intrinsics.checkNotNull((Object)class_7462);
            class_7462.method_7353((class_2561)class_2561.method_43471((String)"gamehelper.message.gamerules_handler.error.server_not_installed").method_54663(-256), false);
        } else {
            this$0.logger.info("Request gamerules successfully.");
            if (this$0.configManager.getConfig().getShowMoreInfoInGame()) {
                class_746 class_7463 = this$0.client.field_1724;
                Intrinsics.checkNotNull((Object)class_7463);
                class_7463.method_7353((class_2561)class_2561.method_43471((String)"gamehelper.message.gamerules_handler.run.request_gamerules_successfully"), false);
            }
        }
        return Unit.INSTANCE;
    }

    private static final void requestGameRulesInMultiPlayer$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Logger access$getLogger$p(GameRulesHandler $this) {
        return $this.logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\b\u001a\u0004\b\t\u0010\nR\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u000b\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcn/mangofanfan/gamehelper/client/handler/GameRulesHandler$BooleanRuleData;", "", "", "translationKey", "", "value", "<init>", "(Ljava/lang/String;Z)V", "Ljava/lang/String;", "getTranslationKey", "()Ljava/lang/String;", "Z", "getValue", "()Z", "setValue", "(Z)V", "gamehelper_client"})
    @Environment(value=EnvType.CLIENT)
    public static final class BooleanRuleData {
        @NotNull
        private final String translationKey;
        private boolean value;

        public BooleanRuleData(@NotNull String translationKey, boolean value) {
            Intrinsics.checkNotNullParameter((Object)translationKey, (String)"translationKey");
            this.translationKey = translationKey;
            this.value = value;
        }

        @NotNull
        public final String getTranslationKey() {
            return this.translationKey;
        }

        public final boolean getValue() {
            return this.value;
        }

        public final void setValue(boolean bl) {
            this.value = bl;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\t\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\u0003R\u0018\u0010\r\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcn/mangofanfan/gamehelper/client/handler/GameRulesHandler$Companion;", "", "<init>", "()V", "Lcn/mangofanfan/gamehelper/client/handler/GameRulesHandler;", "getInstance", "()Lcn/mangofanfan/gamehelper/client/handler/GameRulesHandler;", "Lnet/minecraft/server/MinecraftServer;", "server", "build", "(Lnet/minecraft/server/MinecraftServer;)Lcn/mangofanfan/gamehelper/client/handler/GameRulesHandler;", "", "delete", "instance", "Lcn/mangofanfan/gamehelper/client/handler/GameRulesHandler;", "gamehelper_client"})
    @Environment(value=EnvType.CLIENT)
    public static final class Companion {
        @NotNull
        public static final Companion INSTANCE = new Companion();
        @JvmField
        @Nullable
        public static GameRulesHandler instance;

        private Companion() {
        }

        @NotNull
        public final GameRulesHandler getInstance() {
            if (instance == null) {
                throw new RuntimeException("GameRulesHandler instance is null");
            }
            GameRulesHandler gameRulesHandler = instance;
            Intrinsics.checkNotNull((Object)gameRulesHandler);
            return gameRulesHandler;
        }

        @NotNull
        public final GameRulesHandler build(@Nullable MinecraftServer server) {
            if (instance == null) {
                instance = new GameRulesHandler(server);
            }
            GameRulesHandler gameRulesHandler = instance;
            Intrinsics.checkNotNull((Object)gameRulesHandler);
            return gameRulesHandler;
        }

        public final void delete() {
            instance = null;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\f\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\b\u001a\u0004\b\t\u0010\nR\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u000b\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcn/mangofanfan/gamehelper/client/handler/GameRulesHandler$IntRuleData;", "", "", "translationKey", "", "value", "<init>", "(Ljava/lang/String;I)V", "Ljava/lang/String;", "getTranslationKey", "()Ljava/lang/String;", "I", "getValue", "()I", "setValue", "(I)V", "gamehelper_client"})
    @Environment(value=EnvType.CLIENT)
    public static final class IntRuleData {
        @NotNull
        private final String translationKey;
        private int value;

        public IntRuleData(@NotNull String translationKey, int value) {
            Intrinsics.checkNotNullParameter((Object)translationKey, (String)"translationKey");
            this.translationKey = translationKey;
            this.value = value;
        }

        @NotNull
        public final String getTranslationKey() {
            return this.translationKey;
        }

        public final int getValue() {
            return this.value;
        }

        public final void setValue(int n) {
            this.value = n;
        }
    }
}

