/*
 * Decompiled with CFR 0.152.
 */
package com.bleepz.sacredsettlements;

import com.bleepz.sacredsettlements.ProtectionRadiusManager;
import com.bleepz.sacredsettlements.VillageBellMenu;
import com.bleepz.sacredsettlements.VillageData;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class BellInteractionHandler {
    @SubscribeEvent
    public void onBlockRightClick(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = level.getBlockState(pos);
        Player player = event.getEntity();
        if (!state.is(Blocks.BELL)) {
            return;
        }
        if (level.isClientSide()) {
            event.setCanceled(true);
            return;
        }
        ProtectionRadiusManager manager = ProtectionRadiusManager.getInstance();
        VillageData villageData = manager.getOrCreateVillageData(pos);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.openVillageGUI(serverPlayer, villageData);
        }
        event.setCanceled(true);
    }

    private void openVillageGUI(ServerPlayer player, VillageData villageData) {
        player.openMenu((MenuProvider)new SimpleMenuProvider((containerId, playerInventory, p) -> new VillageBellMenu(containerId, playerInventory, villageData.getBellPosition()), (Component)Component.literal((String)"Village Bell")), buf -> {
            buf.writeBlockPos(villageData.getBellPosition());
            buf.writeBoolean(villageData.hasOwner());
            if (villageData.hasOwner()) {
                buf.writeUtf(villageData.getOwnerName());
                buf.writeLong(System.currentTimeMillis() - villageData.getOwnershipDurationMillis());
            }
        });
    }
}

