/*
 * Decompiled with CFR 0.152.
 */
package com.bleepz.sacredsettlements;

import com.bleepz.sacredsettlements.ProtectionRadiusManager;
import com.bleepz.sacredsettlements.VillageScanner;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;

public class ProtectionEventHandler {
    @SubscribeEvent
    public void onChunkLoad(ChunkEvent.Load event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        VillageScanner.scanChunkForVillage((LevelChunk)event.getChunk());
    }

    @SubscribeEvent
    public void onBellBreak(BlockEvent.BreakEvent event) {
        ServerPlayer serverPlayer;
        Player player;
        if (event.getState().is(Blocks.BELL) && (player = event.getPlayer()) instanceof ServerPlayer && !(serverPlayer = (ServerPlayer)player).hasPermissions(4)) {
            event.setCanceled(true);
            player.displayClientMessage((Component)Component.literal((String)"\u00a7cVillage bells cannot be destroyed!"), true);
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (this.isAdmin(player)) {
            return;
        }
        if (ProtectionRadiusManager.getInstance().isPositionProtected(event.getPos())) {
            event.setCanceled(true);
            player.displayClientMessage((Component)Component.literal((String)"\u00a7cThis village is protected! You cannot break blocks here."), true);
        }
    }

    @SubscribeEvent
    public void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (this.isAdmin(player)) {
            return;
        }
        if (ProtectionRadiusManager.getInstance().isPositionProtected(event.getPos())) {
            event.setCanceled(true);
            player.displayClientMessage((Component)Component.literal((String)"\u00a7cThis village is protected! You cannot place blocks here."), true);
        }
    }

    @SubscribeEvent
    public void onEntityDamage(LivingIncomingDamageEvent event) {
        if (!(event.getEntity() instanceof Villager) && !(event.getEntity() instanceof IronGolem)) {
            return;
        }
        if (ProtectionRadiusManager.getInstance().isPositionProtected(event.getEntity().blockPosition())) {
            event.setCanceled(true);
        }
    }

    private boolean isAdmin(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            return serverPlayer.hasPermissions(2);
        }
        return false;
    }
}

