/*
 * Decompiled with CFR 0.152.
 */
package com.bleepz.sacredsettlements;

import com.bleepz.sacredsettlements.ProtectionConfig;
import com.bleepz.sacredsettlements.VillageData;
import com.bleepz.sacredsettlements.VillageDataStorage;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;

public class ProtectionRadiusManager {
    private static ProtectionRadiusManager instance;
    private ServerLevel currentLevel;

    private ProtectionRadiusManager() {
    }

    public static ProtectionRadiusManager getInstance() {
        if (instance == null) {
            instance = new ProtectionRadiusManager();
        }
        return instance;
    }

    public void setLevel(ServerLevel level) {
        this.currentLevel = level;
    }

    private Map<BlockPos, VillageData> getVillages() {
        if (this.currentLevel != null) {
            return VillageDataStorage.get(this.currentLevel).getVillages();
        }
        return new HashMap<BlockPos, VillageData>();
    }

    public VillageData getOrCreateVillageData(BlockPos bellPos) {
        BlockPos primaryBell;
        Map<BlockPos, VillageData> villages = this.getVillages();
        if (!villages.containsKey(primaryBell = this.getPrimaryBell(bellPos))) {
            villages.put(primaryBell.immutable(), new VillageData(primaryBell.immutable()));
        }
        return villages.get(primaryBell);
    }

    public VillageData getVillageData(BlockPos bellPos) {
        return this.getVillages().get(bellPos);
    }

    public VillageData findNearestVillage(BlockPos pos) {
        int radius = (Integer)ProtectionConfig.PROTECTION_RADIUS.get();
        int radiusSquared = radius * radius;
        for (VillageData village : this.getVillages().values()) {
            int dz;
            BlockPos bellPos = village.getBellPosition();
            int dx = pos.getX() - bellPos.getX();
            int distanceSquared = dx * dx + (dz = pos.getZ() - bellPos.getZ()) * dz;
            if (distanceSquared > radiusSquared) continue;
            return village;
        }
        return null;
    }

    public BlockPos getPrimaryBell(BlockPos anyBellInVillage) {
        Map<BlockPos, VillageData> villages = this.getVillages();
        if (villages.containsKey(anyBellInVillage)) {
            return anyBellInVillage;
        }
        int radius = (Integer)ProtectionConfig.PROTECTION_RADIUS.get();
        int radiusSquared = radius * radius;
        for (BlockPos primaryBell : villages.keySet()) {
            int dz;
            int dx = anyBellInVillage.getX() - primaryBell.getX();
            int distanceSquared = dx * dx + (dz = anyBellInVillage.getZ() - primaryBell.getZ()) * dz;
            if (distanceSquared > radiusSquared) continue;
            return primaryBell;
        }
        return anyBellInVillage;
    }

    public boolean isPositionProtected(BlockPos pos) {
        return this.findNearestVillage(pos) != null;
    }

    public void clearProtectedVillages() {
        this.getVillages().clear();
    }

    public Map<BlockPos, VillageData> getAllVillages() {
        return new HashMap<BlockPos, VillageData>(this.getVillages());
    }
}

