/*
 * Decompiled with CFR 0.152.
 */
package com.bleepz.sacredsettlements;

import com.bleepz.sacredsettlements.ProtectionConfig;
import com.bleepz.sacredsettlements.ProtectionRadiusManager;
import com.bleepz.sacredsettlements.VillageData;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;

public record PurchaseVillagePacket(BlockPos bellPosition) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PurchaseVillagePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"sacredsettlements", (String)"purchase_village"));
    public static final StreamCodec<ByteBuf, PurchaseVillagePacket> CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, PurchaseVillagePacket::bellPosition, PurchaseVillagePacket::new);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(PurchaseVillagePacket packet, ServerPlayer player) {
        VillageData village = ProtectionRadiusManager.getInstance().getOrCreateVillageData(packet.bellPosition());
        if (village == null) {
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7cVillage not found!"));
            return;
        }
        if (village.hasOwner()) {
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7cThis village is already owned!"));
            return;
        }
        int purchasePrice = (Integer)ProtectionConfig.VILLAGE_PURCHASE_PRICE.get();
        int emeraldCount = 0;
        for (ItemStack stack : player.getInventory().items) {
            if (!stack.is(Items.EMERALD)) continue;
            emeraldCount += stack.getCount();
        }
        if (emeraldCount < purchasePrice) {
            player.sendSystemMessage((Component)Component.literal((String)("\u00a7cYou need " + purchasePrice + " emeralds to purchase this village!")));
            return;
        }
        int toRemove = purchasePrice;
        for (ItemStack stack : player.getInventory().items) {
            if (!stack.is(Items.EMERALD) || toRemove <= 0) continue;
            int removeFromStack = Math.min(toRemove, stack.getCount());
            stack.shrink(removeFromStack);
            toRemove -= removeFromStack;
        }
        village.setOwner(player.getUUID(), player.getName().getString());
        player.sendSystemMessage((Component)Component.literal((String)"\u00a7aYou now own this village!"));
        player.closeContainer();
    }
}

