/*
 * Decompiled with CFR 0.152.
 */
package com.bleepz.sacredsettlements;

import com.bleepz.sacredsettlements.BellInteractionHandler;
import com.bleepz.sacredsettlements.ModMenuTypes;
import com.bleepz.sacredsettlements.ProtectionConfig;
import com.bleepz.sacredsettlements.ProtectionEventHandler;
import com.bleepz.sacredsettlements.ProtectionRadiusManager;
import com.bleepz.sacredsettlements.TaxCollectionSystem;
import com.bleepz.sacredsettlements.UnstuckCommand;
import com.bleepz.sacredsettlements.VillageDataStorage;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.CreativeModeTab;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.slf4j.Logger;

@Mod(value="sacredsettlements")
public class SacredSettlements {
    public static final String MODID = "sacredsettlements";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"sacredsettlements");
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"sacredsettlements");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"sacredsettlements");

    public SacredSettlements(IEventBus modEventBus, ModContainer modContainer) {
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        ModMenuTypes.MENUS.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        NeoForge.EVENT_BUS.register(TaxCollectionSystem.class);
        NeoForge.EVENT_BUS.register((Object)new ProtectionEventHandler());
        NeoForge.EVENT_BUS.register((Object)new BellInteractionHandler());
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ProtectionConfig.SPEC, "sacredsettlements-protection.toml");
    }

    @SubscribeEvent
    public void onCommandRegister(RegisterCommandsEvent event) {
        UnstuckCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
        ServerLevel overworld = event.getServer().overworld();
        ProtectionRadiusManager.getInstance().setLevel(overworld);
        VillageDataStorage.get(overworld);
        LOGGER.info("Sacred Settlements loaded village data");
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        ServerLevel overworld = event.getServer().overworld();
        VillageDataStorage storage = VillageDataStorage.get(overworld);
        storage.saveToFile(overworld);
        VillageDataStorage.reset();
        LOGGER.info("Sacred Settlements saved village data");
    }
}

