/*
 * Decompiled with CFR 0.152.
 */
package com.bleepz.sacredsettlements;

import com.bleepz.sacredsettlements.ProtectionRadiusManager;
import com.bleepz.sacredsettlements.SacredSettlements;
import com.bleepz.sacredsettlements.VillageData;
import com.bleepz.sacredsettlements.VillageDataStorage;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

public class TaxCollectionSystem {
    private static int tickCounter = 0;
    private static final int CHECK_INTERVAL = 1200;
    private static int saveCounter = 0;
    private static final int SAVE_INTERVAL = 6000;

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        ++tickCounter;
        if (++saveCounter >= 6000) {
            saveCounter = 0;
            for (ServerLevel level : event.getServer().getAllLevels()) {
                VillageDataStorage.get(level).saveToFile(level);
            }
        }
        if (tickCounter >= 1200) {
            tickCounter = 0;
            TaxCollectionSystem.checkAndCollectTaxes(event.getServer());
        }
    }

    private static void checkAndCollectTaxes(MinecraftServer server) {
        for (ServerLevel level : server.getAllLevels()) {
            ProtectionRadiusManager manager = ProtectionRadiusManager.getInstance();
            for (VillageData village : manager.getAllVillages().values()) {
                if (!village.hasOwner() || !village.isTaxDue()) continue;
                boolean taxPaid = village.collectTax();
                if (!taxPaid) {
                    SacredSettlements.LOGGER.info("Village at {} abandoned due to unpaid taxes", (Object)village.getBellPosition());
                    village.abandonVillage();
                    continue;
                }
                SacredSettlements.LOGGER.info("Collected {} emeralds in taxes from village at {}", (Object)village.calculateTaxOwed(), (Object)village.getBellPosition());
            }
        }
    }
}

