/*
 * Decompiled with CFR 0.152.
 */
package com.bleepz.sacredsettlements;

import com.bleepz.sacredsettlements.ProtectionRadiusManager;
import com.bleepz.sacredsettlements.VillageData;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Blocks;

public class UnstuckCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"sacred").then(Commands.literal((String)"unstuck").executes(UnstuckCommand::executeUnstuck)));
    }

    private static int executeUnstuck(CommandContext<CommandSourceStack> context) {
        Entity entity = ((CommandSourceStack)context.getSource()).getEntity();
        if (!(entity instanceof ServerPlayer)) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Only players can use this command"));
            return 0;
        }
        ServerPlayer player = (ServerPlayer)entity;
        VillageData village = ProtectionRadiusManager.getInstance().findNearestVillage(player.blockPosition());
        if (village == null) {
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7cYou must be in a protected village to use this command!"));
            return 0;
        }
        BlockPos bellPos = village.getBellPosition();
        BlockPos safePos = UnstuckCommand.findSafePosition((ServerLevel)player.level(), bellPos);
        if (safePos == null) {
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7cCouldn't find a safe location near the bell!"));
            return 0;
        }
        player.teleportTo((double)safePos.getX() + 0.5, (double)safePos.getY(), (double)safePos.getZ() + 0.5);
        player.sendSystemMessage((Component)Component.literal((String)"\u00a7aReturned to village bell!"));
        return 1;
    }

    private static BlockPos findSafePosition(ServerLevel level, BlockPos bellPos) {
        for (int yOffset = 0; yOffset <= 5; ++yOffset) {
            for (int xOffset = -2; xOffset <= 2; ++xOffset) {
                for (int zOffset = -2; zOffset <= 2; ++zOffset) {
                    BlockPos checkPos = bellPos.offset(xOffset, yOffset, zOffset);
                    if (!UnstuckCommand.isSafePosition(level, checkPos)) continue;
                    return checkPos;
                }
            }
        }
        return bellPos.above();
    }

    private static boolean isSafePosition(ServerLevel level, BlockPos pos) {
        BlockPos below = pos.below();
        BlockPos above = pos.above();
        if (!level.getBlockState(below).canOcclude()) {
            return false;
        }
        if (!level.getBlockState(pos).isAir() || !level.getBlockState(above).isAir()) {
            return false;
        }
        return !level.getBlockState(below).is(Blocks.LAVA) && !level.getBlockState(below).is(Blocks.FIRE);
    }
}

