/*
 * Decompiled with CFR 0.152.
 */
package com.bleepz.sacredsettlements;

import com.bleepz.sacredsettlements.ModMenuTypes;
import com.bleepz.sacredsettlements.ProtectionRadiusManager;
import com.bleepz.sacredsettlements.VillageData;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;

public class VillageBellMenu
extends AbstractContainerMenu {
    private VillageData villageData;
    private final BlockPos bellPosition;
    private final SimpleContainer emeraldContainer;
    private Player openingPlayer;
    private String ownerName;
    private long ownershipStartTime;
    private boolean hasOwner;

    public VillageBellMenu(int containerId, Inventory playerInventory, FriendlyByteBuf extraData) {
        this(containerId, playerInventory, extraData.readBlockPos());
        this.openingPlayer = playerInventory.player;
        this.hasOwner = extraData.readBoolean();
        if (this.hasOwner) {
            this.ownerName = extraData.readUtf();
            this.ownershipStartTime = extraData.readLong();
        }
    }

    public VillageBellMenu(int containerId, Inventory playerInventory, BlockPos bellPos) {
        super((MenuType)ModMenuTypes.VILLAGE_BELL_MENU.get(), containerId);
        int col;
        int row;
        this.bellPosition = bellPos;
        this.emeraldContainer = new SimpleContainer(9);
        this.openingPlayer = playerInventory.player;
        if (!playerInventory.player.level().isClientSide()) {
            this.villageData = ProtectionRadiusManager.getInstance().getOrCreateVillageData(bellPos);
            for (int i = 0; i < 9; ++i) {
                this.emeraldContainer.setItem(i, this.villageData.getEmeraldInventory()[i]);
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 3; ++col) {
                int index = col + row * 3;
                this.addSlot(new EmeraldOnlySlot(this.emeraldContainer, index, 62 + col * 18, 17 + row * 18));
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int col2 = 0; col2 < 9; ++col2) {
            this.addSlot(new Slot((Container)playerInventory, col2, 8 + col2 * 18, 142));
        }
    }

    public void removed(@NotNull Player player) {
        super.removed(player);
        if (!player.level().isClientSide() && this.villageData != null) {
            for (int i = 0; i < 9; ++i) {
                this.villageData.setInventorySlot(i, this.emeraldContainer.getItem(i));
            }
        }
    }

    public VillageData getVillageData() {
        return this.villageData;
    }

    public BlockPos getBellPosition() {
        return this.bellPosition;
    }

    public SimpleContainer getEmeraldContainer() {
        return this.emeraldContainer;
    }

    public boolean hasOwner() {
        if (this.villageData != null) {
            return this.villageData.hasOwner();
        }
        return this.hasOwner;
    }

    public String getOwnerName() {
        if (this.villageData != null) {
            return this.villageData.getOwnerName();
        }
        return this.ownerName;
    }

    public String getOwnershipDurationFormatted() {
        long startTime;
        long l = startTime = this.villageData != null ? System.currentTimeMillis() - this.villageData.getOwnershipDurationMillis() : this.ownershipStartTime;
        if (startTime == 0L) {
            return "0s";
        }
        long millis = System.currentTimeMillis() - startTime;
        long seconds = millis / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        if (days > 0L) {
            return days + "d " + hours % 24L + "h";
        }
        if (hours > 0L) {
            return hours + "h " + minutes % 60L + "m";
        }
        if (minutes > 0L) {
            return minutes + "m " + seconds % 60L + "s";
        }
        return seconds + "s";
    }

    public int getTotalEmeralds() {
        int total = 0;
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.emeraldContainer.getItem(i);
            if (!stack.is(Items.EMERALD)) continue;
            total += stack.getCount();
        }
        return total;
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            itemstack = slotStack.copy();
            if (index < 9) {
                if (!this.moveItemStackTo(slotStack, 9, this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
            } else if (slotStack.is(Items.EMERALD)) {
                if (!this.moveItemStackTo(slotStack, 0, 9, false)) {
                    return ItemStack.EMPTY;
                }
            } else {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public boolean stillValid(@NotNull Player player) {
        return true;
    }

    private class EmeraldOnlySlot
    extends Slot {
        public EmeraldOnlySlot(SimpleContainer container, int index, int x, int y) {
            super((Container)container, index, x, y);
        }

        public boolean mayPlace(@NotNull ItemStack stack) {
            return stack.is(Items.EMERALD) && this.canPlayerAccess();
        }

        public boolean mayPickup(@NotNull Player player) {
            return this.canPlayerAccess();
        }

        private boolean canPlayerAccess() {
            if (VillageBellMenu.this.villageData == null) {
                return true;
            }
            if (!VillageBellMenu.this.villageData.hasOwner()) {
                return true;
            }
            return VillageBellMenu.this.villageData.getOwnerId() != null && VillageBellMenu.this.villageData.getOwnerId().equals(VillageBellMenu.this.openingPlayer.getUUID());
        }
    }
}

