/*
 * Decompiled with CFR 0.152.
 */
package com.bleepz.sacredsettlements;

import com.bleepz.sacredsettlements.DynamicButton;
import com.bleepz.sacredsettlements.ProtectionConfig;
import com.bleepz.sacredsettlements.PurchaseVillagePacket;
import com.bleepz.sacredsettlements.VillageBellMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

public class VillageBellScreen
extends AbstractContainerScreen<VillageBellMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"sacredsettlements", (String)"textures/gui/village_bell.png");

    public VillageBellScreen(VillageBellMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 176;
        this.imageHeight = 166;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    protected void init() {
        super.init();
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        if (!((VillageBellMenu)this.menu).hasOwner()) {
            int price = (Integer)ProtectionConfig.VILLAGE_PURCHASE_PRICE.get();
            Button purchaseButton = Button.builder((Component)Component.literal((String)("Buy: " + price)), button -> this.onPurchaseClicked()).bounds(x + 8, y + 20, 48, 50).build();
            this.addRenderableWidget((GuiEventListener)purchaseButton);
        } else {
            int statsX = x + 120;
            int statsY = y + 17;
            int buttonWidth = 52;
            int buttonHeight = 16;
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)("\u00a76" + ((VillageBellMenu)this.menu).getOwnerName())), b -> {}).bounds(statsX, statsY, buttonWidth, buttonHeight).build());
            this.addRenderableWidget((GuiEventListener)new DynamicButton(statsX, statsY + 19, buttonWidth, buttonHeight, () -> Component.literal((String)("\u00a77" + ((VillageBellMenu)this.menu).getOwnershipDurationFormatted())), b -> {}));
            this.addRenderableWidget((GuiEventListener)new DynamicButton(statsX, statsY + 38, buttonWidth, buttonHeight, () -> {
                int emeralds = ((VillageBellMenu)this.menu).getTotalEmeralds();
                double ratePerHour = (Double)ProtectionConfig.TAX_RATE_PER_HOUR.get();
                int collectionHours = (Integer)ProtectionConfig.TAX_COLLECTION_HOURS.get();
                double totalTax = ratePerHour * (double)collectionHours;
                String taxDisplay = ratePerHour == 0.0 ? "" : (ratePerHour < 1.0 ? String.format(" \u00a77-%.1f/hr", ratePerHour) : String.format(" \u00a77-%.0f/hr", ratePerHour));
                return Component.literal((String)("\u00a7a" + emeralds + taxDisplay));
            }, b -> {}));
        }
    }

    private void onPurchaseClicked() {
        if (this.minecraft != null && this.minecraft.getConnection() != null) {
            this.minecraft.getConnection().send((CustomPacketPayload)new PurchaseVillagePacket(((VillageBellMenu)this.menu).getBellPosition()));
        }
    }

    protected void renderBg(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }
}

