/*
 * Decompiled with CFR 0.152.
 */
package com.bleepz.sacredsettlements;

import com.bleepz.sacredsettlements.ProtectionConfig;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.AABB;

public class VillageData {
    private final BlockPos bellPosition;
    private UUID ownerId;
    private String ownerName;
    private final ItemStack[] emeraldInventory;
    private boolean isPurchased;
    private long ownershipStartTime;
    private long lastTaxCollectionTime;

    public VillageData(BlockPos bellPosition) {
        this.bellPosition = bellPosition;
        this.emeraldInventory = new ItemStack[9];
        for (int i = 0; i < 9; ++i) {
            this.emeraldInventory[i] = ItemStack.EMPTY;
        }
        this.isPurchased = false;
        this.ownershipStartTime = 0L;
    }

    public BlockPos getBellPosition() {
        return this.bellPosition;
    }

    public UUID getOwnerId() {
        return this.ownerId;
    }

    public void setOwner(UUID playerId, String playerName) {
        this.ownerId = playerId;
        this.ownerName = playerName;
        this.isPurchased = true;
        this.ownershipStartTime = System.currentTimeMillis();
        this.lastTaxCollectionTime = System.currentTimeMillis();
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public boolean isPurchased() {
        return this.isPurchased;
    }

    public ItemStack[] getEmeraldInventory() {
        return this.emeraldInventory;
    }

    public void setInventorySlot(int slot, ItemStack stack) {
        if (slot >= 0 && slot < 9) {
            this.emeraldInventory[slot] = stack;
        }
    }

    public int getTotalEmeralds() {
        int total = 0;
        for (ItemStack stack : this.emeraldInventory) {
            if (!stack.is(Items.EMERALD)) continue;
            total += stack.getCount();
        }
        return total;
    }

    public boolean hasOwner() {
        return this.ownerId != null && this.isPurchased;
    }

    public long getOwnershipStartTime() {
        return this.ownershipStartTime;
    }

    public void setOwnershipStartTime(Long time) {
        this.ownershipStartTime = time;
    }

    public long getOwnershipDurationMillis() {
        if (!this.hasOwner()) {
            return 0L;
        }
        return System.currentTimeMillis() - this.ownershipStartTime;
    }

    public String getOwnershipDurationFormatted() {
        long millis = this.getOwnershipDurationMillis();
        long seconds = millis / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        if (days > 0L) {
            return days + "d " + hours % 24L + "h";
        }
        if (hours > 0L) {
            return hours + "h " + minutes % 60L + "m";
        }
        if (minutes > 0L) {
            return minutes + "m " + seconds % 60L + "s";
        }
        return seconds + "s";
    }

    public long getLastTaxCollectionTime() {
        return this.lastTaxCollectionTime;
    }

    public void setLastTaxCollectionTime(Long time) {
        this.lastTaxCollectionTime = time;
    }

    public boolean isTaxDue() {
        int collectionInterval;
        if (!this.hasOwner()) {
            return false;
        }
        long hoursSinceLastCollection = (System.currentTimeMillis() - this.lastTaxCollectionTime) / 3600000L;
        return hoursSinceLastCollection >= (long)(collectionInterval = ((Integer)ProtectionConfig.TAX_COLLECTION_HOURS.get()).intValue());
    }

    public int calculateTaxOwed() {
        double ratePerHour = (Double)ProtectionConfig.TAX_RATE_PER_HOUR.get();
        int collectionInterval = (Integer)ProtectionConfig.TAX_COLLECTION_HOURS.get();
        return (int)Math.ceil(ratePerHour * (double)collectionInterval);
    }

    public boolean collectTax() {
        if (!this.isTaxDue()) {
            return true;
        }
        int taxOwed = this.calculateTaxOwed();
        int currentEmeralds = this.getTotalEmeralds();
        if (currentEmeralds < taxOwed) {
            return false;
        }
        int toRemove = taxOwed;
        for (int i = 0; i < 9 && toRemove > 0; ++i) {
            ItemStack stack = this.emeraldInventory[i];
            if (!stack.is(Items.EMERALD)) continue;
            int removeFromStack = Math.min(toRemove, stack.getCount());
            stack.shrink(removeFromStack);
            toRemove -= removeFromStack;
        }
        this.lastTaxCollectionTime = System.currentTimeMillis();
        return true;
    }

    public void abandonVillage() {
        this.ownerId = null;
        this.ownerName = null;
        this.isPurchased = false;
        this.ownershipStartTime = 0L;
        this.lastTaxCollectionTime = 0L;
        for (int i = 0; i < 9; ++i) {
            this.emeraldInventory[i] = ItemStack.EMPTY;
        }
    }

    public int countVillagersInRange(ServerLevel level) {
        int radius = (Integer)ProtectionConfig.PROTECTION_RADIUS.get();
        AABB boundingBox = new AABB(this.bellPosition.offset(-radius, -50, -radius));
        return level.getEntitiesOfClass(Villager.class, boundingBox).size();
    }
}

