/*
 * Decompiled with CFR 0.152.
 */
package com.bleepz.sacredsettlements;

import com.bleepz.sacredsettlements.SacredSettlements;
import com.bleepz.sacredsettlements.VillageData;
import com.mojang.serialization.DynamicOps;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.LevelResource;

public class VillageDataStorage {
    private static final String DATA_NAME = "sacredsettlements_villages";
    private final Map<BlockPos, VillageData> villages = new HashMap<BlockPos, VillageData>();
    private static VillageDataStorage instance;

    public static VillageDataStorage load(CompoundTag tag, HolderLookup.Provider provider) {
        VillageDataStorage storage = new VillageDataStorage();
        if (!tag.contains("Villages")) {
            return storage;
        }
        ListTag villageList = tag.getList("Villages", 10);
        for (int i = 0; i < villageList.size(); ++i) {
            CompoundTag villageTag = villageList.getCompound(i);
            BlockPos bellPos = new BlockPos(villageTag.getInt("BellX"), villageTag.getInt("BellY"), villageTag.getInt("BellZ"));
            VillageData village = new VillageData(bellPos);
            if (villageTag.getBoolean("HasOwner")) {
                long mostSigBits = villageTag.getLong("OwnerIdMost");
                long leastSigBits = villageTag.getLong("OwnerIdLeast");
                UUID ownerId = new UUID(mostSigBits, leastSigBits);
                String ownerName = villageTag.getString("OwnerName");
                long ownershipStart = villageTag.getLong("OwnershipStart");
                long lastTaxCollection = villageTag.getLong("LastTaxCollection");
                village.setOwner(ownerId, ownerName);
                village.setOwnershipStartTime(ownershipStart);
                village.setLastTaxCollectionTime(lastTaxCollection);
            }
            ListTag inventoryList = villageTag.getList("Inventory", 10);
            for (int j = 0; j < inventoryList.size(); ++j) {
                CompoundTag itemTag = inventoryList.getCompound(j);
                int slot = itemTag.getInt("Slot");
                CompoundTag itemData = itemTag.getCompound("Item");
                if (itemData.isEmpty()) continue;
                RegistryOps ops = provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
                ItemStack.CODEC.parse((DynamicOps)ops, (Object)itemData).resultOrPartial(error -> {}).ifPresent(stack -> village.setInventorySlot(slot, (ItemStack)stack));
            }
            storage.villages.put(bellPos, village);
        }
        return storage;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        ListTag villageList = new ListTag();
        for (VillageData village : this.villages.values()) {
            CompoundTag villageTag = new CompoundTag();
            BlockPos bellPos = village.getBellPosition();
            villageTag.putInt("BellX", bellPos.getX());
            villageTag.putInt("BellY", bellPos.getY());
            villageTag.putInt("BellZ", bellPos.getZ());
            villageTag.putBoolean("HasOwner", village.hasOwner());
            if (village.hasOwner()) {
                UUID ownerId = village.getOwnerId();
                villageTag.putLong("OwnerIdMost", ownerId.getMostSignificantBits());
                villageTag.putLong("OwnerIdLeast", ownerId.getLeastSignificantBits());
                villageTag.putString("OwnerName", village.getOwnerName());
                villageTag.putLong("OwnershipStart", village.getOwnershipStartTime());
                villageTag.putLong("LastTaxCollection", village.getLastTaxCollectionTime());
            }
            ListTag inventoryList = new ListTag();
            ItemStack[] inventory = village.getEmeraldInventory();
            for (int i = 0; i < inventory.length; ++i) {
                if (inventory[i].isEmpty()) continue;
                CompoundTag itemTag = new CompoundTag();
                itemTag.putInt("Slot", i);
                RegistryOps ops = provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
                CompoundTag itemNbt = (CompoundTag)ItemStack.CODEC.encodeStart((DynamicOps)ops, (Object)inventory[i]).getOrThrow();
                itemTag.put("Item", (Tag)itemNbt);
                inventoryList.add((Object)itemTag);
            }
            villageTag.put("Inventory", (Tag)inventoryList);
            villageList.add((Object)villageTag);
        }
        tag.put("Villages", (Tag)villageList);
        return tag;
    }

    public Map<BlockPos, VillageData> getVillages() {
        return this.villages;
    }

    public static VillageDataStorage get(ServerLevel level) {
        if (instance == null) {
            instance = new VillageDataStorage();
            instance.loadFromFile(level);
        }
        return instance;
    }

    public void loadFromFile(ServerLevel level) {
        try {
            Path dataDir = level.getServer().getWorldPath(LevelResource.ROOT).resolve("data");
            Path dataFile = dataDir.resolve("sacredsettlements_villages.dat");
            if (Files.exists(dataFile, new LinkOption[0])) {
                CompoundTag tag = NbtIo.readCompressed((Path)dataFile, (NbtAccounter)NbtAccounter.unlimitedHeap());
                VillageDataStorage loaded = VillageDataStorage.load(tag, (HolderLookup.Provider)level.registryAccess());
                this.villages.putAll(loaded.villages);
                SacredSettlements.LOGGER.info("Loaded {} villages from storage", (Object)this.villages.size());
            }
        }
        catch (Exception e) {
            SacredSettlements.LOGGER.error("Failed to load village data", (Throwable)e);
        }
    }

    public void saveToFile(ServerLevel level) {
        try {
            Path dataDir = level.getServer().getWorldPath(LevelResource.ROOT).resolve("data");
            Files.createDirectories(dataDir, new FileAttribute[0]);
            Path dataFile = dataDir.resolve("sacredsettlements_villages.dat");
            CompoundTag tag = this.save(new CompoundTag(), (HolderLookup.Provider)level.registryAccess());
            NbtIo.writeCompressed((CompoundTag)tag, (Path)dataFile);
            SacredSettlements.LOGGER.info("Saved {} villages to storage", (Object)this.villages.size());
        }
        catch (Exception e) {
            SacredSettlements.LOGGER.error("Failed to save village data", (Throwable)e);
        }
    }

    public static void reset() {
        instance = null;
    }
}

