/*
 * Decompiled with CFR 0.152.
 */
package digital.naomie;

import com.google.gson.TypeAdapter;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import dev.xpple.betterconfig.api.ModConfigBuilder;
import digital.naomie.BlockAdapter;
import digital.naomie.BlockSuggestionProvider;
import digital.naomie.VeinMineConfig;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VeinMine
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"serverveinmine");
    public static HashMap<class_2248, class_2248> equivalentBlocks = new HashMap();

    public void onInitialize() {
        LOGGER.info("Server Vein Mine is initializing!");
        new ModConfigBuilder("serverveinmine", VeinMineConfig.class).registerTypeHierarchy(class_2248.class, (TypeAdapter)new BlockAdapter(), (SuggestionProvider)new BlockSuggestionProvider(), (ctx, name) -> {
            String blockString = (String)ctx.getArgument(name, String.class);
            class_2960 blockId = class_2960.method_12829((String)blockString);
            if (blockId == null) {
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().create();
            }
            if (!class_7923.field_41175.method_10250(blockId)) {
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().create();
            }
            return (class_2248)class_7923.field_41175.method_63535(blockId);
        }).build();
        PlayerBlockBreakEvents.AFTER.register((world, player, pos, state, entity) -> {
            if (world.method_8608()) {
                return;
            }
            if (!VeinMineConfig.veinMineableBlocks.contains(state.method_26204())) {
                return;
            }
            if (player.method_5715() != VeinMineConfig.ShiftToActivate) {
                return;
            }
            if (!player.method_6047().method_7951(state)) {
                return;
            }
            this.mineVein(world, pos, state, player);
        });
    }

    private void mineVein(class_1937 world, class_2338 pos, @NotNull class_2680 state, class_1657 player) {
        class_2248 targetBlock = equivalentBlocks.getOrDefault(state.method_26204(), state.method_26204());
        HashSet<class_2338> checked = new HashSet<class_2338>();
        HashSet<class_2338> remaining = new HashSet<class_2338>();
        HashSet<class_2338> targets = new HashSet<class_2338>();
        checked.add(pos);
        remaining.add(pos);
        int total = 0;
        while (total < VeinMineConfig.maxBlocks && !remaining.isEmpty()) {
            class_2338 currentPos = (class_2338)remaining.iterator().next();
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        class_2248 neighborType;
                        class_2248 neighbourBlock;
                        class_2338 neighbor;
                        if (Math.abs(x) + Math.abs(y) + Math.abs(z) == 0 || checked.contains(neighbor = currentPos.method_10069(x, y, z)) || !Objects.equals(targetBlock, neighbourBlock = equivalentBlocks.getOrDefault(neighborType = world.method_8320(neighbor).method_26204(), neighborType))) continue;
                        targets.add(neighbor);
                        remaining.add(neighbor);
                        checked.add(neighbor);
                        ++total;
                    }
                }
            }
            remaining.remove(currentPos);
        }
        if (targets.size() > VeinMineConfig.maxBlocks) {
            player.method_7353(class_2561.method_30163((String)"You're trying to vein mine more blocks than allowed"), true);
            return;
        }
        targets.forEach(block -> {
            if (((PlayerBlockBreakEvents.Before)PlayerBlockBreakEvents.BEFORE.invoker()).beforeBlockBreak(world, player, pos, world.method_8320(pos), world.method_8321(pos))) {
                ((class_3222)player).field_13974.method_14266(block);
            }
        });
    }

    static {
        equivalentBlocks.put(class_2246.field_29219, class_2246.field_10418);
        equivalentBlocks.put(class_2246.field_29221, class_2246.field_27120);
        equivalentBlocks.put(class_2246.field_29027, class_2246.field_10212);
        equivalentBlocks.put(class_2246.field_29026, class_2246.field_10571);
        equivalentBlocks.put(class_2246.field_29028, class_2246.field_10090);
        equivalentBlocks.put(class_2246.field_29030, class_2246.field_10080);
        equivalentBlocks.put(class_2246.field_29029, class_2246.field_10442);
        equivalentBlocks.put(class_2246.field_29220, class_2246.field_10013);
    }
}

