/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.client.gui;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_5348;

public class MessageRenderer {
    public static final int BASE_COLOR = 0xFFFFFF;
    private final class_437 screen;
    private Optional<Message> shownMessage = Optional.empty();

    public MessageRenderer(class_437 class_4372) {
        this.screen = class_4372;
    }

    public void addMessage(class_2561 class_25612) {
        this.shownMessage = Optional.of(new Message(class_25612));
    }

    public void addMessage(class_2561 class_25612, int n) {
        this.shownMessage = Optional.of(new Message(class_25612, n));
    }

    public void tick() {
        if (this.shownMessage.isEmpty()) {
            return;
        }
        Message message = this.shownMessage.get();
        message.tick();
        if (message.isExpired()) {
            this.shownMessage = Optional.empty();
        }
    }

    public void render(class_332 class_3322) {
        this.shownMessage.ifPresent(message -> message.render(this.screen, class_3322));
    }

    private static class Message {
        private static final int SHOW_DURATION = 40;
        private final class_2561 text;
        private final int baseTextColor;
        private int timeRemaining;

        public Message(class_2561 class_25612) {
            this(class_25612, 0xFFFFFF);
        }

        public Message(class_2561 class_25612, int n) {
            this.text = class_25612;
            this.baseTextColor = n;
            this.timeRemaining = 40;
        }

        public void tick() {
            --this.timeRemaining;
        }

        public void render(class_437 class_4372, class_332 class_3322) {
            class_310 class_3102 = class_310.method_1551();
            class_327 class_3272 = class_3102.field_1772;
            int n = class_3272.method_27525((class_5348)this.text);
            int n2 = (class_4372.field_22789 - n) / 2;
            int n3 = class_4372.field_22790 - 20 - 1 - 6;
            Objects.requireNonNull(class_3272);
            int n4 = n3 - 9;
            float f = class_3532.method_15363((float)((float)this.timeRemaining / 10.0f), (float)0.0f, (float)1.0f);
            int n5 = class_3102.field_1690.method_19344(0) >> 24 & 0xFF;
            int n6 = (int)(f * (float)n5) << 24 & 0xFF000000;
            int n7 = this.baseTextColor + ((int)(f * 255.0f) << 24);
            Objects.requireNonNull(class_3272);
            class_3322.method_25294(n2 - 2, n4 - 2, n2 + n + 2, n4 + 9 + 2, n6);
            class_3322.method_27535(class_3272, this.text, n2, n4, n7);
        }

        public boolean isExpired() {
            return this.timeRemaining <= 0;
        }
    }

    @FunctionalInterface
    public static interface HasMessageRenderer {
        public MessageRenderer getMessageRenderer();
    }
}

