/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.client.gui.screen;

import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import me.roundaround.armorstands.client.ArmorStandsClientMod;
import me.roundaround.armorstands.client.gui.MessageRenderer;
import me.roundaround.armorstands.client.gui.screen.ArmorStandLayoutWidget;
import me.roundaround.armorstands.client.gui.screen.PassesEventsThrough;
import me.roundaround.armorstands.client.network.ClientNetworking;
import me.roundaround.armorstands.mixin.ArmorStandEntityAccessor;
import me.roundaround.armorstands.mixin.InGameHudAccessor;
import me.roundaround.armorstands.mixin.MouseAccessor;
import me.roundaround.armorstands.network.ScreenType;
import me.roundaround.armorstands.network.UtilityAction;
import me.roundaround.armorstands.roundalib.client.gui.icon.BuiltinIcon;
import me.roundaround.armorstands.roundalib.client.gui.icon.CustomIcon;
import me.roundaround.armorstands.roundalib.client.gui.layout.linear.LinearLayoutWidget;
import me.roundaround.armorstands.roundalib.client.gui.util.GuiUtil;
import me.roundaround.armorstands.roundalib.client.gui.widget.IconButtonWidget;
import me.roundaround.armorstands.roundalib.client.gui.widget.drawable.FrameWidget;
import me.roundaround.armorstands.screen.ArmorStandScreenHandler;
import net.minecraft.class_1041;
import net.minecraft.class_11906;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_1703;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.minecraft.class_8021;

public abstract class AbstractArmorStandScreen
extends class_465<ArmorStandScreenHandler>
implements PassesEventsThrough {
    protected static final CustomIcon COPY_ICON = new CustomIcon("copy", 20);
    protected static final CustomIcon PASTE_ICON = new CustomIcon("paste", 20);
    protected static final int BACKGROUND_COLOR = GuiUtil.genColorInt(0.0f, 0.0f, 0.0f, 0.7f);
    protected static final int ELEMENT_HEIGHT = 16;
    protected final ArmorStandLayoutWidget layout = new ArmorStandLayoutWidget((class_437)this);
    protected final class_1531 armorStand;
    protected final MessageRenderer messageRenderer;
    protected LinearLayoutWidget utilRow;
    protected LinearLayoutWidget navRow;
    protected IconButtonWidget activePageButton;
    protected boolean supportsUndoRedo = false;
    protected boolean utilizesInventory = false;
    protected boolean passEvents = true;
    protected long currentSyncDelay = 0L;
    private boolean cursorLocked = false;
    private long lastPing = 0L;

    protected AbstractArmorStandScreen(ArmorStandScreenHandler armorStandScreenHandler, class_2561 class_25612) {
        super((class_1703)armorStandScreenHandler, armorStandScreenHandler.getPlayerInventory(), class_25612);
        this.armorStand = armorStandScreenHandler.getArmorStand();
        this.messageRenderer = new MessageRenderer((class_437)this);
    }

    public abstract ScreenType getScreenType();

    public class_1531 getArmorStand() {
        return this.armorStand;
    }

    public MessageRenderer getMessageRenderer() {
        return this.messageRenderer;
    }

    @Override
    public boolean shouldPassEvents() {
        return this.passEvents;
    }

    public void method_25426() {
        this.populateLayout();
        this.collectElements();
        this.method_48640();
    }

    protected class_310 getClient() {
        return Objects.requireNonNull(this.field_22787);
    }

    protected class_746 getPlayer() {
        return this.getClient().field_1724;
    }

    protected void populateLayout() {
        this.initUtilityButtons();
        this.initNavigationButtons();
    }

    protected void initUtilityButtons() {
        if (!this.supportsUndoRedo) {
            return;
        }
        this.utilRow = LinearLayoutWidget.horizontal().spacing(2);
        this.utilRow.add(IconButtonWidget.builder(BuiltinIcon.HELP_18, "armorstands").vanillaSize().messageAndTooltip(this.buildHelpTooltipText()).build());
        this.utilRow.add(IconButtonWidget.builder(COPY_ICON, "armorstands").vanillaSize().messageAndTooltip((class_2561)class_2561.method_43471((String)"armorstands.utility.copy")).onPress(class_41852 -> ClientNetworking.sendUtilityActionPacket(UtilityAction.COPY)).build());
        this.utilRow.add(IconButtonWidget.builder(PASTE_ICON, "armorstands").vanillaSize().messageAndTooltip((class_2561)class_2561.method_43471((String)"armorstands.utility.paste")).onPress(class_41852 -> ClientNetworking.sendUtilityActionPacket(UtilityAction.PASTE)).build());
        this.utilRow.add(IconButtonWidget.builder(BuiltinIcon.UNDO_18, "armorstands").vanillaSize().messageAndTooltip((class_2561)class_2561.method_43471((String)"armorstands.utility.undo")).onPress(class_41852 -> ClientNetworking.sendUndoPacket(false)).build());
        this.utilRow.add(IconButtonWidget.builder(BuiltinIcon.REDO_18, "armorstands").vanillaSize().messageAndTooltip((class_2561)class_2561.method_43471((String)"armorstands.utility.redo")).onPress(class_41852 -> ClientNetworking.sendUndoPacket(true)).build());
        this.layout.topLeft.add(this.utilRow);
    }

    private class_2561 buildHelpTooltipText() {
        String string = class_2561.method_43471((String)("armorstands.help." + (class_11906.field_62586 ? "cmd" : "ctrl"))).getString();
        ArrayList<class_5250> arrayList = new ArrayList<class_5250>();
        arrayList.add(class_2561.method_43471((String)"armorstands.help.main").method_10852(class_5244.field_33849));
        arrayList.add(class_2561.method_43471((String)"armorstands.help.shortcuts"));
        arrayList.add(class_2561.method_43469((String)"armorstands.help.look", (Object[])new Object[]{class_2561.method_43471((String)"armorstands.help.alt")}));
        arrayList.add(class_2561.method_43469((String)"armorstands.help.close", (Object[])new Object[]{this.getStyledBoundText(this.getClient().field_1690.field_1822), class_3675.class_307.field_1668.method_1447(256).method_27445()}));
        arrayList.add(class_2561.method_43469((String)"armorstands.help.change", (Object[])new Object[]{ScreenType.values().length}));
        arrayList.add(class_2561.method_43469((String)"armorstands.help.highlight", (Object[])new Object[]{this.getStyledBoundText(ArmorStandsClientMod.highlightArmorStandKeyBinding)}));
        arrayList.add(class_2561.method_43469((String)"armorstands.help.undo", (Object[])new Object[]{string, class_3675.class_307.field_1668.method_1447(90).method_27445()}));
        arrayList.add(class_2561.method_43469((String)"armorstands.help.redo", (Object[])new Object[]{string, class_3675.class_307.field_1668.method_1447(89).method_27445()}));
        arrayList.add(class_2561.method_43469((String)"armorstands.help.copy", (Object[])new Object[]{string, class_3675.class_307.field_1668.method_1447(67).method_27445()}));
        arrayList.add(class_2561.method_43469((String)"armorstands.help.paste", (Object[])new Object[]{string, class_3675.class_307.field_1668.method_1447(86).method_27445()}));
        return class_5244.method_37109(arrayList);
    }

    private class_2561 getStyledBoundText(class_304 class_3042) {
        class_2561 class_25612 = class_3042.method_16007();
        if (class_3042.method_1415()) {
            return class_2561.method_43470((String)"(").method_10852(class_25612).method_27693(")").method_27695(new class_124[]{class_124.field_1056, class_124.field_1080});
        }
        return class_25612;
    }

    protected void initNavigationButtons() {
        this.navRow = LinearLayoutWidget.horizontal().spacing(2);
        for (ScreenType screenType : ScreenType.values()) {
            IconButtonWidget iconButtonWidget = IconButtonWidget.builder(screenType.getIcon(), "armorstands").vanillaSize().disableIconDim().messageAndTooltip(screenType.getDisplayName()).onPress(class_41852 -> ClientNetworking.sendRequestScreenPacket(this.getArmorStand(), screenType)).build();
            if (this.getScreenType() == screenType) {
                iconButtonWidget.field_22763 = false;
                this.activePageButton = iconButtonWidget;
            }
            this.navRow.add(iconButtonWidget);
        }
        this.layout.topRight.add(this.navRow);
        if (this.activePageButton != null) {
            this.layout.nonPositioned.add(new FrameWidget((class_8021)this.activePageButton));
        }
    }

    protected void collectElements() {
        this.layout.method_48206(class_3642 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)class_3642);
        });
    }

    protected void method_48640() {
        this.layout.method_48222();
    }

    protected void method_37432() {
        assert (this.field_22787 != null);
        ((InGameHudAccessor)this.field_22787.field_1705).invokeUpdateVignetteDarkness(this.field_22787.method_1560());
        this.messageRenderer.tick();
    }

    public void method_25394(class_332 class_3322, int n, int n2, float f) {
        assert (this.field_22787 != null);
        int n3 = this.cursorLocked ? -1 : n;
        int n4 = this.cursorLocked ? -1 : n2;
        ((InGameHudAccessor)this.field_22787.field_1705).invokeRenderVignetteOverlay(class_3322, this.field_22787.method_1560());
        super.method_25394(class_3322, n3, n4, f);
        this.messageRenderer.render(class_3322);
    }

    public void method_52752(class_332 class_3322) {
    }

    protected void method_2389(class_332 class_3322, float f, int n, int n2) {
    }

    protected void method_2388(class_332 class_3322, int n, int n2) {
    }

    public void method_16014(double d, double d2) {
        if (this.cursorLocked) {
            return;
        }
        super.method_16014(d, d2);
    }

    public boolean method_25402(class_11909 class_119092, boolean bl) {
        if (this.cursorLocked) {
            return false;
        }
        class_364 class_3642 = this.method_25399();
        boolean bl2 = super.method_25402(class_119092, bl);
        if (this.utilizesInventory) {
            this.method_25395(class_3642);
        }
        return bl2;
    }

    public boolean method_25403(class_11909 class_119092, double d, double d2) {
        if (this.cursorLocked) {
            return false;
        }
        if (this.utilizesInventory) {
            return super.method_25403(class_119092, d, d2);
        }
        if (this.method_25399() != null && this.method_25397() && class_119092.method_74245() == 0) {
            return this.method_25399().method_25403(class_119092, d, d2);
        }
        return false;
    }

    public boolean method_25406(class_11909 class_119092) {
        if (this.cursorLocked) {
            return false;
        }
        if (this.utilizesInventory) {
            return super.method_25406(class_119092);
        }
        if (this.method_25397() && this.method_25399() != null && class_119092.method_74245() == 0) {
            this.method_25398(false);
            return this.method_25399().method_25406(class_119092);
        }
        this.method_25398(false);
        return this.method_19355(class_119092.comp_4798(), class_119092.comp_4799()).filter(class_3642 -> class_3642.method_25406(class_119092)).isPresent();
    }

    public boolean method_25401(double d, double d2, double d3, double d4) {
        if (this.cursorLocked) {
            return false;
        }
        if (this.navRow != null && this.navRow.getBounds().contains(d, d2)) {
            if (d4 > 0.0) {
                this.goToPreviousScreen();
            } else {
                this.goToNextScreen();
            }
            return true;
        }
        return super.method_25401(d, d2, d3, d4);
    }

    public Optional<class_364> method_19355(double d, double d2) {
        if (this.cursorLocked) {
            return Optional.empty();
        }
        return super.method_19355(d, d2);
    }

    public boolean method_25404(class_11908 class_119082) {
        assert (this.field_22787 != null);
        if (this.field_22787.field_1690.field_1903.method_1417(class_119082)) {
            return false;
        }
        if (this.field_22787.field_1690.field_1822.method_1417(class_119082)) {
            this.method_25419();
            return true;
        }
        switch (class_119082.method_74228()) {
            case 256: {
                this.method_25419();
                return true;
            }
            case 342: 
            case 346: {
                if (!this.passEvents) break;
                this.lockCursor();
                return true;
            }
            case 263: {
                if (!class_119082.method_74240()) break;
                GuiUtil.playClickSound();
                this.goToPreviousScreen();
                return true;
            }
            case 262: {
                if (!class_119082.method_74240()) break;
                GuiUtil.playClickSound();
                this.goToNextScreen();
                return true;
            }
            case 90: {
                if (!this.supportsUndoRedo || !class_119082.method_74240()) break;
                GuiUtil.playClickSound();
                ClientNetworking.sendUndoPacket(false);
                return true;
            }
            case 89: {
                if (!this.supportsUndoRedo || !class_119082.method_74240()) break;
                GuiUtil.playClickSound();
                ClientNetworking.sendUndoPacket(true);
                return true;
            }
            case 67: {
                if (!this.supportsUndoRedo || !class_119082.method_74240()) break;
                GuiUtil.playClickSound();
                ClientNetworking.sendUtilityActionPacket(UtilityAction.COPY);
                return true;
            }
            case 86: {
                if (!this.supportsUndoRedo || !class_119082.method_74240()) break;
                GuiUtil.playClickSound();
                ClientNetworking.sendUtilityActionPacket(UtilityAction.PASTE);
                return true;
            }
        }
        for (ScreenType screenType : ScreenType.values()) {
            if (screenType == this.getScreenType() || !this.field_22787.field_1690.field_1852[screenType.getIndex()].method_1417(class_119082)) continue;
            GuiUtil.playClickSound();
            ClientNetworking.sendRequestScreenPacket(this.armorStand, screenType);
            return true;
        }
        if (this.method_25399() != null && this.method_25399().method_25404(class_119082)) {
            return true;
        }
        return super.method_25404(class_119082);
    }

    public boolean method_16803(class_11908 class_119082) {
        if (this.passEvents && (class_119082.method_74228() == 342 || class_119082.method_74228() == 346)) {
            this.unlockCursor();
            return true;
        }
        return this.method_25399() != null && this.method_25399().method_16803(class_119082);
    }

    public boolean shouldHighlight(class_1297 class_12972) {
        return ArmorStandsClientMod.highlightArmorStandKeyBinding.method_1434() && class_12972 == this.armorStand;
    }

    public boolean isCursorLocked() {
        return this.cursorLocked;
    }

    public void sendPing() {
        this.lastPing = System.currentTimeMillis();
        ClientNetworking.sendPingPacket(Objects.requireNonNull(this.field_22787).field_1724);
    }

    public void onPong() {
        this.currentSyncDelay = System.currentTimeMillis() - this.lastPing;
    }

    public void updatePosOnClient(double d, double d2, double d3) {
        this.armorStand.method_23327(d, d2, d3);
    }

    public void updateYawOnClient(float f) {
        this.armorStand.method_36456(f);
    }

    public void updatePitchOnClient(float f) {
        this.armorStand.method_36457(f);
    }

    public void updateInvulnerableOnClient(boolean bl) {
        this.armorStand.method_5684(bl);
    }

    public void updateDisabledSlotsOnClient(int n) {
        ((ArmorStandEntityAccessor)this.armorStand).setDisabledSlots(n);
    }

    protected void lockCursor() {
        assert (this.field_22787 != null);
        this.cursorLocked = true;
        int n = this.field_22787.method_22683().method_4480() / 2;
        int n2 = this.field_22787.method_22683().method_4507() / 2;
        ((MouseAccessor)this.field_22787.field_1729).setX(n);
        ((MouseAccessor)this.field_22787.field_1729).setY(n2);
        class_3675.method_15984((class_1041)this.field_22787.method_22683(), (int)212995, (double)n, (double)n2);
    }

    protected void unlockCursor() {
        assert (this.field_22787 != null);
        this.cursorLocked = false;
        int n = this.field_22787.method_22683().method_4480() / 2;
        int n2 = this.field_22787.method_22683().method_4507() / 2;
        ((MouseAccessor)this.field_22787.field_1729).setX(n);
        ((MouseAccessor)this.field_22787.field_1729).setY(n2);
        class_3675.method_15984((class_1041)this.field_22787.method_22683(), (int)212993, (double)n, (double)n2);
    }

    protected void goToPreviousScreen() {
        ClientNetworking.sendRequestScreenPacket(this.armorStand, this.getScreenType().previous());
    }

    protected void goToNextScreen() {
        ClientNetworking.sendRequestScreenPacket(this.armorStand, this.getScreenType().next());
    }

    protected static class_2561 getCurrentPosText(class_1297 class_12972) {
        String string = String.format("%.2f", class_12972.method_23317());
        String string2 = String.format("%.2f", class_12972.method_23318());
        String string3 = String.format("%.2f", class_12972.method_23321());
        return class_2561.method_43469((String)"armorstands.current.position", (Object[])new Object[]{string, string2, string3});
    }

    protected static class_2561 getCurrentBlockPosText(class_1297 class_12972) {
        class_2338 class_23382 = class_12972.method_24515();
        return class_2561.method_43469((String)"armorstands.current.block", (Object[])new Object[]{class_23382.method_10263(), class_23382.method_10264(), class_23382.method_10260()});
    }

    protected static class_2561 getCurrentRotationText(class_1297 class_12972) {
        float f = class_12972.method_36454();
        return class_2561.method_43469((String)"armorstands.current.rotation", (Object[])new Object[]{String.format(Locale.ROOT, "%.1f", Float.valueOf(class_3532.method_15393((float)f)))});
    }

    protected static class_2561 getCurrentFacingText(class_1297 class_12972) {
        return AbstractArmorStandScreen.getFacingText(class_2350.method_10150((double)class_12972.method_36454()));
    }

    protected static class_2561 getFacingText(class_2350 class_23502) {
        String string = switch (class_23502) {
            case class_2350.field_11043 -> "negZ";
            case class_2350.field_11035 -> "posZ";
            case class_2350.field_11039 -> "negX";
            default -> "posX";
        };
        class_5250 class_52502 = class_2561.method_43471((String)("armorstands.current.facing." + string));
        return class_2561.method_43469((String)"armorstands.current.facing", (Object[])new Object[]{class_23502.toString(), class_52502.getString()});
    }
}

